/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePluginVersion;
import org.jetbrains.kotlin.idea.configuration.notifications.EapSurveyNotificationKt;
import org.jetbrains.kotlin.idea.configuration.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/PluginStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "checkPluginCompatibility", "", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class PluginStartupActivity
implements StartupActivity.Background {
    public void runActivity(@NotNull Project project) {
        UpdateChecker.INSTANCE.getExcludedFromUpdateCheckPlugins().add("org.jetbrains.kotlin");
        this.checkPluginCompatibility();
        KotlinReportSubmitter.Companion.setupReportingFromRelease();
        KotlinPluginDisposable pluginDisposable = KotlinPluginDisposable.Companion.getInstance(project);
        ReadAction.nonBlocking(() -> PluginStartupActivity.runActivity$lambda$0(project)).inSmartMode(project).expireWith((Disposable)pluginDisposable).finishOnUiThread(ModalityState.any(), arg_0 -> PluginStartupActivity.runActivity$lambda$1((Function1)new Function1<Boolean, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Boolean hasKotlinFiles) {
                if (!hasKotlinFiles.booleanValue()) {
                    return;
                }
                DaemonCodeAnalyzerEx daemonCodeAnalyzerEx = DaemonCodeAnalyzerImpl.getInstanceEx((Project)this.$project);
                Intrinsics.checkNotNull((Object)daemonCodeAnalyzerEx, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
                DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)daemonCodeAnalyzerEx;
                daemonCodeAnalyzer.serializeCodeInsightPasses(true);
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        ReadAction.nonBlocking(() -> PluginStartupActivity.runActivity$lambda$2(project)).inSmartMode(project).expireWith((Disposable)pluginDisposable).finishOnUiThread(ModalityState.any(), arg_0 -> PluginStartupActivity.runActivity$lambda$3((Function1)new Function1<Boolean, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(Boolean hasKotlinFiles) {
                if (!hasKotlinFiles.booleanValue()) {
                    return;
                }
                NewCodeStyleNotificationKt.notifyKotlinStyleUpdateIfNeeded(this.$project);
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    EapSurveyNotificationKt.showEapSurveyNotification(this.$project);
                }
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void checkPluginCompatibility() {
        String string2 = ApplicationInfo.getInstance().getShortVersion();
        if (string2 == null) {
            return;
        }
        String platformVersion = string2;
        boolean isAndroidStudio = KotlinPlatformUtils.isAndroidStudio();
        String rawVersion = KotlinIdePlugin.INSTANCE.getVersion();
        Object object = KotlinIdePluginVersion.Companion.parse-IoAF18A(rawVersion);
        KotlinIdePluginVersion kotlinIdePluginVersion = (KotlinIdePluginVersion)(Result.isFailure-impl((Object)object) ? null : object);
        if (kotlinIdePluginVersion == null) {
            return;
        }
        KotlinIdePluginVersion kotlinPluginVersion = kotlinIdePluginVersion;
        if (!Intrinsics.areEqual((Object)kotlinPluginVersion.getPlatformVersion(), (Object)platformVersion) || kotlinPluginVersion.isAndroidStudio() != isAndroidStudio) {
            String ideName = ApplicationInfo.getInstance().getVersionName();
            Object modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application app$iv = ApplicationManager.getApplication();
            if (app$iv.isDispatchThread()) {
                boolean bl = false;
                Object[] objectArray = new Object[]{rawVersion, ideName, platformVersion};
                Messages.showWarningDialog((String)KotlinBundle.message("plugin.verifier.compatibility.issue.message", objectArray), (String)KotlinBundle.message("plugin.verifier.compatibility.issue.title", new Object[0]));
            } else {
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(rawVersion, ideName, platformVersion){
                    final /* synthetic */ String $rawVersion$inlined;
                    final /* synthetic */ String $ideName$inlined;
                    final /* synthetic */ String $platformVersion$inlined;
                    {
                        this.$rawVersion$inlined = string2;
                        this.$ideName$inlined = string3;
                        this.$platformVersion$inlined = string4;
                    }

                    public final void run() {
                        boolean bl = false;
                        Object[] objectArray = new Object[]{this.$rawVersion$inlined, this.$ideName$inlined, this.$platformVersion$inlined};
                        Messages.showWarningDialog((String)KotlinBundle.message("plugin.verifier.compatibility.issue.message", objectArray), (String)KotlinBundle.message("plugin.verifier.compatibility.issue.title", new Object[0]));
                    }
                }, ModalityState.defaultModalityState());
            }
        }
    }

    private static final Boolean runActivity$lambda$0(Project $project) {
        return ProjectStructureUtils.containsKotlinFile($project);
    }

    private static final void runActivity$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean runActivity$lambda$2(Project $project) {
        return ProjectStructureUtils.containsNonScriptKotlinFile($project);
    }

    private static final void runActivity$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

