/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.PluginUpdateStatus;
import com.intellij.ide.plugins.StandalonePluginUpdateChecker;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.update.VerifyKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u001a\u0010\r\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "Lcom/intellij/ide/plugins/StandalonePluginUpdateChecker;", "()V", "currentVersion", "", "getCurrentVersion", "()Ljava/lang/String;", "runCachedUpdate", "", "callback", "Lkotlin/Function1;", "Lcom/intellij/ide/plugins/PluginUpdateStatus;", "", "runUpdateCheck", "skipUpdateCheck", "verifyUpdate", "status", "Lcom/intellij/ide/plugins/PluginUpdateStatus$Update;", "Companion", "kotlin.plugin-updater"})
public final class KotlinPluginUpdater
extends StandalonePluginUpdateChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PROPERTY_NAME = "kotlin.lastUpdateCheck";
    @NotNull
    private static final Logger LOG = Logger.getInstance(KotlinPluginUpdater.class);

    public KotlinPluginUpdater() {
        super(KotlinIdePlugin.INSTANCE.getId(), PROPERTY_NAME, NotificationGroupManager.getInstance().getNotificationGroup("Kotlin plugin updates"), KotlinIcons.SMALL_LOGO);
    }

    @NotNull
    public String getCurrentVersion() {
        return KotlinIdePlugin.INSTANCE.getVersion();
    }

    public boolean skipUpdateCheck() {
        return KotlinIdePlugin.INSTANCE.isSnapshot() || KotlinIdePlugin.INSTANCE.getHasPatchedVersion();
    }

    @NotNull
    public PluginUpdateStatus verifyUpdate(@NotNull PluginUpdateStatus.Update status) {
        return VerifyKt.verify(status);
    }

    public final void runUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> KotlinPluginUpdater.runUpdateCheck$lambda$0(this, callback2));
    }

    public final void runCachedUpdate(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PluginUpdateStatus cachedStatus = this.getLastUpdateStatus();
        if (cachedStatus != null) {
            if (System.currentTimeMillis() - cachedStatus.getTimestamp() < StandalonePluginUpdateChecker.getCACHED_REQUEST_DELAY() && !(cachedStatus instanceof PluginUpdateStatus.CheckFailed)) {
                callback2.invoke((Object)cachedStatus);
                return;
            }
        }
        this.queueUpdateCheck(callback2);
    }

    private static final void runUpdateCheck$lambda$0(KotlinPluginUpdater this$0, Function1 $callback) {
        this$0.updateCheck($callback);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PROPERTY_NAME", "", "fetchPluginReleaseDate", "Ljava/time/LocalDate;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "version", "channel", "getInstance", "Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "PluginDTO", "ResponseParseException", "kotlin.plugin-updater"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinPluginUpdater getInstance() {
            boolean $i$f$service = false;
            Class<KotlinPluginUpdater> serviceClass$iv = KotlinPluginUpdater.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (KotlinPluginUpdater)((Object)object);
        }

        @Nullable
        public final LocalDate fetchPluginReleaseDate(@NotNull PluginId pluginId, @NotNull String version2, @Nullable String channel) throws IOException, ResponseParseException {
            LocalDate localDate;
            PluginDTO pluginDTO;
            block9: {
                PluginDTO[] pluginDTOs;
                PluginDTO[] pluginDTOArray;
                String url = "https://plugins.jetbrains.com/api/plugins/" + pluginId.getIdString() + "/updates?version=" + version2;
                try {
                    pluginDTOArray = (PluginDTO[])HttpRequests.request((String)url).connect(Companion::fetchPluginReleaseDate$lambda$0);
                }
                catch (JsonIOException ioException) {
                    throw new IOException(ioException);
                }
                catch (JsonSyntaxException syntaxException) {
                    throw new ResponseParseException("Can't parse json response", (Exception)((Object)syntaxException));
                }
                PluginDTO[] $this$firstOrNull$iv = pluginDTOs = pluginDTOArray;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    PluginDTO element$iv;
                    PluginDTO it = element$iv = $this$firstOrNull$iv[j];
                    boolean bl = false;
                    if (!(it.getListed() && it.getApprove() && (Intrinsics.areEqual((Object)it.getChannel(), (Object)channel) || Intrinsics.areEqual((Object)it.getChannel(), (Object)"") && channel == null))) continue;
                    pluginDTO = element$iv;
                    break block9;
                }
                pluginDTO = null;
            }
            if (pluginDTO == null) {
                return null;
            }
            PluginDTO selectedPluginDTO = pluginDTO;
            String string2 = selectedPluginDTO.getCdate();
            if (string2 == null) {
                throw new ResponseParseException("Empty cdate", null, 2, null);
            }
            String dateString = string2;
            try {
                long dateLong = Long.parseLong(dateString);
                localDate = Instant.ofEpochMilli(dateLong).atZone(ZoneOffset.UTC).toLocalDate();
            }
            catch (NumberFormatException e) {
                throw new ResponseParseException("Can't parse long date", e);
            }
            catch (DateTimeException e) {
                throw new ResponseParseException("Can't convert to date", e);
            }
            return localDate;
        }

        private static final PluginDTO[] fetchPluginReleaseDate$lambda$0(HttpRequests.Request it) {
            InputStream inputStream = it.getInputStream();
            Charset charset = Charsets.UTF_8;
            return (PluginDTO[])new GsonBuilder().create().fromJson((Reader)new InputStreamReader(inputStream, charset), PluginDTO[].class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion$ResponseParseException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "message", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "kotlin.plugin-updater"})
        public static final class ResponseParseException
        extends IllegalStateException {
            public ResponseParseException(@NotNull String message2, @Nullable Exception cause) {
                super(message2, cause);
            }

            public /* synthetic */ ResponseParseException(String string2, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    exception = null;
                }
                this(string2, exception);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion$PluginDTO;", "", "()V", "approve", "", "getApprove", "()Z", "setApprove", "(Z)V", "cdate", "", "getCdate", "()Ljava/lang/String;", "setCdate", "(Ljava/lang/String;)V", "channel", "getChannel", "setChannel", "listed", "getListed", "setListed", "kotlin.plugin-updater"})
        private static final class PluginDTO {
            @Nullable
            private String cdate;
            @Nullable
            private String channel;
            private boolean listed = true;
            private boolean approve = true;

            @Nullable
            public final String getCdate() {
                return this.cdate;
            }

            public final void setCdate(@Nullable String string2) {
                this.cdate = string2;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string2) {
                this.channel = string2;
            }

            public final boolean getListed() {
                return this.listed;
            }

            public final void setListed(boolean bl) {
                this.listed = bl;
            }

            public final boolean getApprove() {
                return this.approve;
            }

            public final void setApprove(boolean bl) {
                this.approve = bl;
            }
        }
    }
}

