/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016J\u0016\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0014\u0010\u001b\u001a\u00020\u000e*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u001a\u0010\u001c\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions;", "", "()V", "commonSuperType", "Lorg/jetbrains/kotlin/types/model/SimpleTypeMarker;", "left", "right", "commonSuperTypeBetweenIntegerTypeAndRegularType", "integerLiteralType", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "regularType", "commonSuperTypeBetweenTwoConstantTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;", "createClassLikeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "createSupertypeList", "", "type", "findCommonSuperType", "types", "", "approximateIntegerLiteralBounds", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getApproximatedTypeImpl", "withNullabilityAndAttributes", "nullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "tree"})
@SourceDebugExtension(value={"SMAP\nConeIntegerLiteralTypeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeIntegerLiteralTypeImpl.kt\norg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n26#2:236\n2661#3,7:237\n*S KotlinDebug\n*F\n+ 1 ConeIntegerLiteralTypeImpl.kt\norg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions\n*L\n151#1:236\n168#1:237,7\n*E\n"})
final class ConeIntegerLiteralTypeExtensions {
    @NotNull
    public static final ConeIntegerLiteralTypeExtensions INSTANCE = new ConeIntegerLiteralTypeExtensions();

    private ConeIntegerLiteralTypeExtensions() {
    }

    @NotNull
    public final List<ConeClassLikeType> createSupertypeList(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Object[] objectArray = new ConeClassLikeType[2];
        objectArray[0] = this.createClassLikeType(StandardClassIds.INSTANCE.getNumber());
        ConeKotlinTypeProjectionIn[] coneKotlinTypeProjectionInArray = new ConeKotlinTypeProjectionIn[]{new ConeKotlinTypeProjectionIn(type2)};
        objectArray[1] = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(StandardClassIds.INSTANCE.getComparable()), coneKotlinTypeProjectionInArray, false, null, 8, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final ConeClassLikeType createClassLikeType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean $i$f$emptyArray = false;
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(classId), new ConeTypeProjection[0], false, null, 8, null);
    }

    @NotNull
    public final ConeClassLikeType getApproximatedTypeImpl(@NotNull ConeIntegerLiteralType $this$getApproximatedTypeImpl, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$getApproximatedTypeImpl, (String)"<this>");
        ConeKotlinType coneKotlinType = expectedType;
        ConeSimpleKotlinType coneSimpleKotlinType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
        ConeClassLikeType coneClassLikeType = coneSimpleKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneSimpleKotlinType : null;
        ConeClassLikeType expectedTypeForApproximation = coneClassLikeType != null ? this.withNullabilityAndAttributes(coneClassLikeType, ConeNullability.NOT_NULL, ConeAttributes.Companion.getEmpty()) : null;
        coneSimpleKotlinType = expectedTypeForApproximation;
        ConeClassLikeType approximatedType = (coneSimpleKotlinType == null ? true : !$this$getApproximatedTypeImpl.getPossibleTypes().contains(coneSimpleKotlinType)) ? (ConeClassLikeType)CollectionsKt.first((Iterable)$this$getApproximatedTypeImpl.getPossibleTypes()) : expectedTypeForApproximation;
        return this.withNullabilityAndAttributes(approximatedType, $this$getApproximatedTypeImpl.getNullability(), $this$getApproximatedTypeImpl.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SimpleTypeMarker findCommonSuperType(@NotNull Collection<? extends SimpleTypeMarker> types2) {
        Intrinsics.checkNotNullParameter(types2, (String)"types");
        if (types2.isEmpty()) {
            return null;
        }
        Iterable $this$reduce$iv = types2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right2;
            SimpleTypeMarker simpleTypeMarker = (SimpleTypeMarker)iterator$iv.next();
            SimpleTypeMarker left = (SimpleTypeMarker)accumulator$iv;
            boolean bl = false;
            accumulator$iv = INSTANCE.commonSuperType(left, (SimpleTypeMarker)right2);
        }
        return (SimpleTypeMarker)accumulator$iv;
    }

    private final SimpleTypeMarker commonSuperType(SimpleTypeMarker left, SimpleTypeMarker right2) {
        if (left == null || right2 == null) {
            return null;
        }
        return left instanceof ConeIntegerLiteralType && !(right2 instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)left, right2) : (right2 instanceof ConeIntegerLiteralType && !(left instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)right2, left) : (left instanceof ConeIntegerLiteralConstantType && right2 instanceof ConeIntegerLiteralConstantType ? (SimpleTypeMarker)this.commonSuperTypeBetweenTwoConstantTypes((ConeIntegerLiteralConstantType)left, (ConeIntegerLiteralConstantType)right2) : (left instanceof ConeIntegerConstantOperatorType ? left : (right2 instanceof ConeIntegerConstantOperatorType ? right2 : null))));
    }

    private final SimpleTypeMarker commonSuperTypeBetweenIntegerTypeAndRegularType(ConeIntegerLiteralType integerLiteralType, SimpleTypeMarker regularType) {
        SimpleTypeMarker simpleTypeMarker = regularType;
        return CollectionsKt.contains((Iterable)integerLiteralType.getPossibleTypes(), (Object)simpleTypeMarker) ? regularType : null;
    }

    private final ConeIntegerLiteralConstantType commonSuperTypeBetweenTwoConstantTypes(ConeIntegerLiteralConstantType left, ConeIntegerLiteralConstantType right2) {
        Set possibleTypes2 = CollectionsKt.intersect((Iterable)left.getPossibleTypes(), (Iterable)right2.getPossibleTypes());
        return new ConeIntegerLiteralConstantTypeImpl(left.getValue(), possibleTypes2, left.isUnsigned(), left.getNullability());
    }

    @NotNull
    public final ConeFlexibleType approximateIntegerLiteralBounds(@NotNull ConeFlexibleType $this$approximateIntegerLiteralBounds, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)$this$approximateIntegerLiteralBounds, (String)"<this>");
        ConeKotlinType newLowerBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getLowerBound(), expectedType);
        ConeKotlinType newUpperBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getUpperBound(), expectedType);
        if (newLowerBound != $this$approximateIntegerLiteralBounds.getLowerBound() || newUpperBound != $this$approximateIntegerLiteralBounds.getUpperBound()) {
            return new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible(newLowerBound), ConeTypeUtilsKt.upperBoundIfFlexible(newUpperBound));
        }
        return $this$approximateIntegerLiteralBounds;
    }

    public static /* synthetic */ ConeFlexibleType approximateIntegerLiteralBounds$default(ConeIntegerLiteralTypeExtensions coneIntegerLiteralTypeExtensions, ConeFlexibleType coneFlexibleType, ConeKotlinType coneKotlinType, int n, Object object) {
        if ((n & 1) != 0) {
            coneKotlinType = null;
        }
        return coneIntegerLiteralTypeExtensions.approximateIntegerLiteralBounds(coneFlexibleType, coneKotlinType);
    }

    @NotNull
    public final ConeClassLikeType withNullabilityAndAttributes(@NotNull ConeClassLikeType $this$withNullabilityAndAttributes, @NotNull ConeNullability nullability2, @NotNull ConeAttributes attributes2) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter((Object)$this$withNullabilityAndAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)nullability2), (String)"nullability");
        Intrinsics.checkNotNullParameter((Object)attributes2, (String)"attributes");
        if (nullability2 == $this$withNullabilityAndAttributes.getNullability() && Intrinsics.areEqual((Object)attributes2, (Object)$this$withNullabilityAndAttributes.getAttributes())) {
            return $this$withNullabilityAndAttributes;
        }
        ConeClassLikeType coneClassLikeType2 = $this$withNullabilityAndAttributes;
        if (coneClassLikeType2 instanceof ConeErrorType) {
            coneClassLikeType = $this$withNullabilityAndAttributes;
        } else if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl($this$withNullabilityAndAttributes.getLookupTag(), $this$withNullabilityAndAttributes.getTypeArguments(), nullability2.isNullable(), attributes2);
        } else {
            throw new IllegalStateException("sealed".toString());
        }
        return coneClassLikeType;
    }
}

