/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererWithJavaFlexibleTypes;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "(Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "renderFlexibleType", "", "lowerRendered", "upperRendered", "cones"})
public final class ConeTypeRendererWithJavaFlexibleTypes
extends ConeTypeRenderer {
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererWithJavaFlexibleTypes(@NotNull StringBuilder builder2, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this.setBuilder(builder2);
        this.idRendererCreator = idRendererCreator;
        this.setIdRenderer((ConeIdRenderer)idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeTypeRendererWithJavaFlexibleTypes lowerRenderer = new ConeTypeRendererWithJavaFlexibleTypes(new StringBuilder(), this.idRendererCreator);
        lowerRenderer.render(flexibleType.getLowerBound());
        ConeTypeRendererWithJavaFlexibleTypes upperRenderer = new ConeTypeRendererWithJavaFlexibleTypes(new StringBuilder(), this.idRendererCreator);
        upperRenderer.render(flexibleType.getUpperBound());
        StringBuilder stringBuilder = this.getBuilder();
        String string2 = lowerRenderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lowerRenderer.builder.toString()");
        String string3 = upperRenderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"upperRenderer.builder.toString()");
        stringBuilder.append(this.renderFlexibleType(string2, string3));
    }

    private final String renderFlexibleType(String lowerRendered, String upperRendered) {
        String array2;
        String mutableEntry2;
        String simpleCollection;
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"COLLECTIONS_PACKAGE_FQ_NAME.asString()");
        String kotlinCollectionsPrefix = stringBuilder.append(StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null)).append('/').toString();
        String mutablePrefix = "Mutable";
        String string3 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinCollectionsPrefix + mutablePrefix), (String)upperRendered, (String)kotlinCollectionsPrefix, (String)(kotlinCollectionsPrefix + '(' + mutablePrefix + ')'));
        if (string3 != null) {
            return string3;
        }
        String string4 = mutableEntry2 = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinCollectionsPrefix + "MutableMap.MutableEntry"), (String)upperRendered, (String)(kotlinCollectionsPrefix + "Map.Entry"), (String)(kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry"));
        if (string4 != null) {
            return string4;
        }
        String kotlinPrefix = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '/';
        String string5 = array2 = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinPrefix + "Array<"), (String)upperRendered, (String)(kotlinPrefix + "Array<out "), (String)(kotlinPrefix + "Array<(out) "));
        if (string5 != null) {
            return string5;
        }
        return "ft<" + lowerRendered + ", " + upperRendered + '>';
    }
}

