/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeAnnotationChecker;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsAbstractNativeIndexerChecker;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsAbstractNativeAnnotationChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/name/ClassId;", "indexerKind", "", "requiredParametersCount", "", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/lang/String;I)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public abstract class FirJsAbstractNativeIndexerChecker
extends FirJsAbstractNativeAnnotationChecker {
    @NotNull
    private final String indexerKind;
    private final int requiredParametersCount;

    public FirJsAbstractNativeIndexerChecker(@NotNull ClassId requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkNotNullParameter((Object)requiredAnnotation, (String)"requiredAnnotation");
        Intrinsics.checkNotNullParameter((Object)indexerKind, (String)"indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirValueParameter firstParameterDeclaration;
        ConeKotlinType firstParameter;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)context2), (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        super.check(declaration2, context2, reporter);
        List<FirValueParameter> parameters2 = declaration2.getValueParameters();
        BuiltinTypes builtIns = context2.getSession().getBuiltinTypes();
        if (!((Collection)parameters2).isEmpty() && !((firstParameter = FirTypeUtilsKt.getConeType((firstParameterDeclaration = (FirValueParameter)CollectionsKt.first(parameters2)).getReturnTypeRef())) instanceof ConeErrorType) && !ConeBuiltinTypeUtilsKt.isString(firstParameter) && !TypeUtilsKt.isSubtypeOf(firstParameter, FirTypeUtilsKt.getConeType(builtIns.getNumberType()), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)firstParameterDeclaration.getSource()), FirJsErrors.INSTANCE.getNATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER(), (Object)this.indexerKind, (DiagnosticContext)((DiagnosticContext)context2), null, (int)16, null);
        }
        if (parameters2.size() != this.requiredParametersCount) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirJsErrors.INSTANCE.getNATIVE_INDEXER_WRONG_PARAMETER_COUNT(), (Object)this.requiredParametersCount, (Object)this.indexerKind, (DiagnosticContext)((DiagnosticContext)context2), null, (int)32, null);
        }
        for (FirValueParameter parameter2 : parameters2) {
            if (parameter2.getDefaultValue() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)parameter2.getSource()), FirJsErrors.INSTANCE.getNATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS(), (Object)this.indexerKind, (DiagnosticContext)((DiagnosticContext)context2), null, (int)16, null);
        }
    }
}

