/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionalTypeParameterSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirFunctionalTypeParameterSyntaxChecker;", "()V", "checkModifiers", "", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkPsiOrLightTree", "", "element", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "checkValOrVarKeyword", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedModifiersInFunctionTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n*L\n1#1,64:1\n483#2,4:65\n489#2,6:69\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n*L\n37#1:65,4\n40#1:69,6\n*E\n"})
public final class FirUnsupportedModifiersInFunctionTypeParameterChecker
extends FirFunctionalTypeParameterSyntaxChecker {
    @NotNull
    public static final FirUnsupportedModifiersInFunctionTypeParameterChecker INSTANCE = new FirUnsupportedModifiersInFunctionTypeParameterChecker();

    private FirUnsupportedModifiersInFunctionTypeParameterChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFunctionTypeParameter element3, @NotNull KtSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)context2), (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkModifiers(source, reporter, context2);
        this.checkValOrVarKeyword(source, reporter, context2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkValOrVarKeyword(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = source;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement2 = ((KtPsiSourceElement)source).getPsi();
            KtValVarKeywordOwner ktValVarKeywordOwner = psiElement2 instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement2 : null;
            if (ktValVarKeywordOwner != null && (ktValVarKeywordOwner = ktValVarKeywordOwner.getValOrVarKeyword()) != null) {
                KtValVarKeywordOwner $this$toKtPsiSourceElement_u24default$iv = ktValVarKeywordOwner;
                KtSourceElementKind kind$iv = (KtSourceElementKind)KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = (KtPsiSourceElement)new KtRealPsiSourceElement((PsiElement)$this$toKtPsiSourceElement_u24default$iv);
                } else {
                    if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = (KtPsiSourceElement)new KtFakeSourceElement((PsiElement)$this$toKtPsiSourceElement_u24default$iv, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            ktSourceElement = (KtSourceElement)ktPsiSourceElement;
        } else {
            KtLightSourceElement ktLightSourceElement;
            if (!(ktSourceElement2 instanceof KtLightSourceElement)) throw new NoWhenBranchMatchedException();
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword((FlyweightCapableTreeStructure)source.getTreeStructure(), (LighterASTNode)source.getLighterASTNode());
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                FlyweightCapableTreeStructure tree$iv = source.getTreeStructure();
                KtSourceElementKind kind$iv = (KtSourceElementKind)KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree$iv, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
            ktSourceElement = (KtSourceElement)ktLightSourceElement;
        }
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement keyword = ktSourceElement;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)keyword), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"val or var on parameter in function type", (DiagnosticContext)((DiagnosticContext)context2), null, (int)16, null);
    }

    private final boolean checkModifiers(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList modifiersList = firModifierList;
        for (FirModifier<?> modifier2 : modifiersList.getModifiers()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)modifier2.getSource()), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"modifier on parameter in function type", (DiagnosticContext)((DiagnosticContext)context2), null, (int)16, null);
        }
        return false;
    }
}

