/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNamedVarargChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNamedVarargChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n46#2:89\n60#2,4:92\n1855#3,2:90\n1855#3,2:96\n1#4:98\n*S KotlinDebug\n*F\n+ 1 FirNamedVarargChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker\n*L\n74#1:89\n76#1:92,4\n74#1:90,2\n80#1:96,2\n*E\n"})
public final class FirNamedVarargChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirNamedVarargChecker INSTANCE = new FirNamedVarargChecker();

    private FirNamedVarargChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)context2), (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirFunctionCall || expression2 instanceof FirAnnotation || expression2 instanceof FirDelegatedConstructorCall || expression2 instanceof FirArrayOfCall)) {
            return;
        }
        boolean isAnnotation2 = expression2 instanceof FirAnnotation;
        KtDiagnosticFactory0 redundantSpreadWarningFactory = isAnnotation2 ? FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION() : FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION();
        boolean allowAssignArray = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(isAnnotation2 ? LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations : LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions);
        if (expression2 instanceof FirArrayOfCall) {
            void $this$forEach$iv;
            Object $this$arguments$iv = expression2;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation2, it, it instanceof FirNamedArgumentExpression, null);
            }
        } else {
            FirCall $this$resolvedArgumentMapping$iv = expression2;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMap = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMap).entrySet()) {
                FirExpression argument2 = (FirExpression)entry.getKey();
                FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
                if (!parameter2.isVararg()) continue;
                if (argument2 instanceof FirVarargArgumentsExpression) {
                    Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)argument2).getArguments();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl = false;
                        FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation2, it, true, FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef()));
                    }
                    continue;
                }
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation2, argument2, false, FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef()));
            }
        }
    }

    private static final void check$checkArgument(FirCall $expression, DiagnosticReporter $reporter, KtDiagnosticFactory0 redundantSpreadWarningFactory, CheckerContext $context, boolean allowAssignArray, boolean isAnnotation2, FirExpression argument2, boolean isVararg2, ConeKotlinType expectedArrayType) {
        if (!(argument2 instanceof FirNamedArgumentExpression)) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).isSpread()) {
            if (isVararg2) {
                FirResolvable firResolvable = $expression instanceof FirResolvable ? (FirResolvable)((Object)$expression) : null;
                if (!((firResolvable != null ? firResolvable.getCalleeReference() : null) instanceof FirErrorNamedReference)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource()), (KtDiagnosticFactory0)redundantSpreadWarningFactory, (DiagnosticContext)((DiagnosticContext)$context), null, (int)8, null);
                }
            }
            return;
        }
        FirTypeRef typeRef = ((FirNamedArgumentExpression)argument2).getExpression().getTypeRef();
        if (typeRef instanceof FirErrorTypeRef) {
            return;
        }
        if (((FirNamedArgumentExpression)argument2).getExpression() instanceof FirArrayOfCall) {
            return;
        }
        if (allowAssignArray && FirTypeUtilsKt.isArrayType(typeRef)) {
            return;
        }
        if (isAnnotation2) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource()), (KtDiagnosticFactoryForDeprecation0)FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION(), (DiagnosticContext)((DiagnosticContext)$context), null, (int)8, null);
        } else {
            if (!(expectedArrayType != null)) {
                boolean bl = false;
                String string2 = "expectedArrayType must be passed for function call";
                throw new IllegalArgumentException(string2.toString());
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirNamedArgumentExpression)argument2).getExpression().getSource()), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION(), (Object)expectedArrayType, (DiagnosticContext)((DiagnosticContext)$context), null, (int)16, null);
        }
    }
}

