/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImplicitNothingReturnTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,35:1\n37#2:36\n*S KotlinDebug\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n*L\n23#1:36\n*E\n"})
public final class FirImplicitNothingReturnTypeChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirImplicitNothingReturnTypeChecker INSTANCE = new FirImplicitNothingReturnTypeChecker();

    private FirImplicitNothingReturnTypeChecker() {
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)context2), (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirSimpleFunction) && !(declaration2 instanceof FirProperty)) {
            return;
        }
        if (declaration2 instanceof FirProperty && ((FirProperty)declaration2).isLocal()) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = declaration2;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        if (DeclarationUtilsKt.getHasExplicitReturnType(declaration2.getSymbol())) {
            return;
        }
        if (ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()))) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirCallableDeclaration firCallableDeclaration = declaration2;
            if (firCallableDeclaration instanceof FirSimpleFunction) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_RETURN_TYPE();
            } else if (firCallableDeclaration instanceof FirProperty) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_PROPERTY_TYPE();
            } else {
                throw new IllegalStateException("Should not be here".toString());
            }
            KtDiagnosticFactory0 factory2 = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), (KtDiagnosticFactory0)factory2, (DiagnosticContext)((DiagnosticContext)context2), null, (int)8, null);
        }
    }
}

