/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBackingFieldChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getProperDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExplicitBackingFieldForbiddenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExplicitBackingFieldForbiddenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,55:1\n15#2:56\n*S KotlinDebug\n*F\n+ 1 FirExplicitBackingFieldForbiddenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExplicitBackingFieldForbiddenChecker\n*L\n38#1:56\n*E\n"})
public final class FirExplicitBackingFieldForbiddenChecker
extends FirDeclarationChecker<FirBackingField> {
    @NotNull
    public static final FirExplicitBackingFieldForbiddenChecker INSTANCE = new FirExplicitBackingFieldForbiddenChecker();

    private FirExplicitBackingFieldForbiddenChecker() {
    }

    @Override
    public void check(@NotNull FirBackingField declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)context2), (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2 instanceof FirDefaultPropertyBackingField) {
            return;
        }
        FirDeclarationStatus status = ((FirProperty)declaration2.getPropertySymbol().getFir()).getStatus();
        if (!(status instanceof FirResolvedDeclarationStatus)) {
            return;
        }
        FirCallableSymbol $this$isAbstract$iv = declaration2.getPropertySymbol();
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), (KtDiagnosticFactory0)this.getProperDiagnostic(context2), (DiagnosticContext)((DiagnosticContext)context2), null, (int)8, null);
        }
        if (FirCallableSymbolKt.isExtension(declaration2.getPropertySymbol())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_EXTENSION(), (DiagnosticContext)((DiagnosticContext)context2), null, (int)8, null);
        }
    }

    private final KtDiagnosticFactory0 getProperDiagnostic(CheckerContext context2) {
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context2);
        return (firClass != null ? firClass.getClassKind() : null) == ClassKind.INTERFACE ? FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_INTERFACE() : FirErrors.INSTANCE.getEXPLICIT_BACKING_FIELD_IN_ABSTRACT_PROPERTY();
    }
}

