/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002\u001a\u0018\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\u0005\u001a\u0012\u0010\u0011\u001a\u00020\t*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"MODIFIER_KEYWORD_SET", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "valOrVarKeyword", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "Lorg/jetbrains/kotlin/KtSourceElement;", "getValOrVarKeyword", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "contains", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "token", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "Lorg/jetbrains/kotlin/fir/FirElement;", "getModifierList", "hasModifier", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirKeywordUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirKeywordUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirKeywordUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class FirKeywordUtilsKt {
    @NotNull
    private static final TokenSet MODIFIER_KEYWORD_SET;

    @Nullable
    public static final FirModifierList getModifierList(@Nullable KtSourceElement $this$getModifierList) {
        FirModifierList firModifierList;
        KtSourceElement ktSourceElement = $this$getModifierList;
        if (ktSourceElement == null) {
            firModifierList = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            FirModifierList.FirPsiModifierList firPsiModifierList;
            PsiElement psiElement2 = ((KtPsiSourceElement)$this$getModifierList).getPsi();
            KtModifierListOwner ktModifierListOwner = psiElement2 instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement2 : null;
            if (ktModifierListOwner != null && (ktModifierListOwner = ktModifierListOwner.getModifierList()) != null) {
                KtModifierListOwner it = ktModifierListOwner;
                boolean bl = false;
                firPsiModifierList = new FirModifierList.FirPsiModifierList((KtModifierList)it);
            } else {
                firPsiModifierList = null;
            }
            firModifierList = firPsiModifierList;
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            Object v3;
            block10: {
                Iterable iterable = SourceHelpersKt.getChildren($this$getModifierList.getLighterASTNode(), (FlyweightCapableTreeStructure<LighterASTNode>)$this$getModifierList.getTreeStructure());
                for (Object t : iterable) {
                    LighterASTNode it = (LighterASTNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.MODIFIER_LIST)) continue;
                    v3 = t;
                    break block10;
                }
                v3 = null;
            }
            LighterASTNode lighterASTNode = v3;
            if (lighterASTNode == null) {
                return null;
            }
            LighterASTNode modifierListNode = lighterASTNode;
            int offsetDelta = $this$getModifierList.getStartOffset() - $this$getModifierList.getLighterASTNode().getStartOffset();
            firModifierList = new FirModifierList.FirLightModifierList(modifierListNode, (FlyweightCapableTreeStructure<LighterASTNode>)$this$getModifierList.getTreeStructure(), offsetDelta);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firModifierList;
    }

    public static final boolean contains(@Nullable FirModifierList $this$contains, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        FirModifierList firModifierList = $this$contains;
        return firModifierList != null ? firModifierList.contains(token) : false;
    }

    @Nullable
    public static final FirModifier<?> getModifier(@NotNull FirElement $this$getModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)$this$getModifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList($this$getModifier.getSource());
        return firModifierList != null ? firModifierList.get(token) : null;
    }

    public static final boolean hasModifier(@NotNull FirElement $this$hasModifier, @NotNull KtModifierKeywordToken token) {
        Intrinsics.checkNotNullParameter((Object)$this$hasModifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return FirKeywordUtilsKt.contains(FirKeywordUtilsKt.getModifierList($this$hasModifier.getSource()), token);
    }

    @Nullable
    public static final KtKeywordToken getValOrVarKeyword(@Nullable KtSourceElement $this$valOrVarKeyword) {
        Object object;
        KtSourceElement ktSourceElement = $this$valOrVarKeyword;
        if (ktSourceElement == null) {
            object = null;
        } else if (ktSourceElement instanceof KtPsiSourceElement) {
            PsiElement psiElement2 = ((KtPsiSourceElement)$this$valOrVarKeyword).getPsi();
            KtValVarKeywordOwner ktValVarKeywordOwner = psiElement2 instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement2 : null;
            if (ktValVarKeywordOwner != null && (ktValVarKeywordOwner = ktValVarKeywordOwner.getValOrVarKeyword()) != null) {
                IElementType iElementType;
                KtValVarKeywordOwner it = ktValVarKeywordOwner;
                boolean bl = false;
                ASTNode aSTNode = it.getNode();
                Object object2 = iElementType = aSTNode != null ? aSTNode.getElementType() : null;
                object = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
            } else {
                object = null;
            }
        } else if (ktSourceElement instanceof KtLightSourceElement) {
            IElementType iElementType;
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword((FlyweightCapableTreeStructure)$this$valOrVarKeyword.getTreeStructure(), (LighterASTNode)$this$valOrVarKeyword.getLighterASTNode());
            Object object3 = iElementType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
            object = iElementType instanceof KtKeywordToken ? (KtKeywordToken)iElementType : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static final /* synthetic */ TokenSet access$getMODIFIER_KEYWORD_SET$p() {
        return MODIFIER_KEYWORD_SET;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = KtTokens.SOFT_KEYWORDS;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.FUN_KEYWORD};
        tokenSetArray[1] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(KtTokens.SOFT_KEYW\u2026D, KtTokens.FUN_KEYWORD))");
        MODIFIER_KEYWORD_SET = tokenSet;
    }
}

