/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.ReplOutputProcessor;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.utils.repl.ReplEscapeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u001c\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\b\b\u0002\u0010#\u001a\u00020$H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0007H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/console/ReplOutputHandler;", "Lcom/intellij/execution/process/OSProcessHandler;", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "process", "Ljava/lang/Process;", "commandLine", "", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;Ljava/lang/Process;Ljava/lang/String;)V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "kotlin.jvm.PlatformType", "inputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isBuildInfoChecked", "", "outputProcessor", "Lorg/jetbrains/kotlin/console/ReplOutputProcessor;", "buildWarningIfNeededBeforeInit", "", "content", "createCompilerMessages", "", "Lorg/jetbrains/kotlin/console/SeverityDetails;", "runtimeErrorsReport", "handleReplMessage", "text", "isSilentlyDestroyOnClose", "notifyTextAvailable", "key", "Lcom/intellij/openapi/util/Key;", "strToSource", "Lorg/xml/sax/InputSource;", "s", "encoding", "Ljava/nio/charset/Charset;", "toSeverity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "kotlin.repl"})
public final class ReplOutputHandler
extends OSProcessHandler {
    @NotNull
    private final KotlinConsoleRunner runner;
    private boolean isBuildInfoChecked;
    private final DocumentBuilderFactory factory;
    @NotNull
    private final ReplOutputProcessor outputProcessor;
    @NotNull
    private final StringBuilder inputBuffer;

    public ReplOutputHandler(@NotNull KotlinConsoleRunner runner, @NotNull Process process2, @NotNull String commandLine) {
        super(process2, commandLine);
        this.runner = runner;
        this.factory = DocumentBuilderFactory.newInstance();
        this.outputProcessor = new ReplOutputProcessor(this.runner);
        this.inputBuffer = new StringBuilder();
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> key) {
        if (StringsKt.startsWith$default((String)text2, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2, null)) {
            return;
        }
        if (Intrinsics.areEqual(key, (Object)ProcessOutputTypes.STDOUT)) {
            this.inputBuffer.append(text2);
            String resultingText = this.inputBuffer.toString();
            if (StringsKt.endsWith$default((String)resultingText, (String)"\n", (boolean)false, (int)2, null)) {
                this.handleReplMessage(resultingText);
                this.inputBuffer.setLength(0);
            }
        } else {
            super.notifyTextAvailable(text2, key);
        }
    }

    private final void handleReplMessage(String text2) {
        Document document;
        if (StringsKt.isBlank((CharSequence)text2)) {
            return;
        }
        try {
            document = this.factory.newDocumentBuilder().parse(ReplOutputHandler.strToSource$default(this, text2, null, 2, null));
        }
        catch (Exception e) {
            RunExecuteActionsKt.logError(ReplOutputHandler.class, "Couldn't parse REPL output: " + text2, e);
            return;
        }
        Document output = document;
        Node node2 = output.getFirstChild();
        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
        Element root = (Element)node2;
        ReplEscapeType outputType = ReplEscapeType.Companion.valueOfOrNull(root.getAttribute("type"));
        String content2 = ReplUtilKt.replNormalizeLineBreaks((String)ReplUtilKt.replUnescapeLineBreaks((String)root.getTextContent()));
        ReplEscapeType replEscapeType = outputType;
        switch (replEscapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[replEscapeType.ordinal()]) {
            case 1: {
                this.buildWarningIfNeededBeforeInit(content2);
                break;
            }
            case 2: {
                this.outputProcessor.printHelp(content2);
                break;
            }
            case 3: {
                this.outputProcessor.printUserOutput(content2);
                break;
            }
            case 4: {
                this.outputProcessor.printResultWithGutterIcon(content2);
                break;
            }
            case 5: {
                this.runner.setReadLineMode(true);
                break;
            }
            case 6: {
                this.runner.setReadLineMode(false);
                break;
            }
            case 7: {
                this.outputProcessor.highlightCompilerErrors(this.createCompilerMessages(content2));
                break;
            }
            case 8: 
            case 9: {
                this.outputProcessor.printRuntimeError(((Object)StringsKt.trim((CharSequence)content2)).toString() + "\n");
                break;
            }
            case 10: {
                this.outputProcessor.printInternalErrorMessage(content2);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                Object object = this.runner.getCommandHistory().lastUnprocessedEntry();
                if (object != null && (object = ((CommandHistory.Entry)object).getEntryText()) != null) {
                    Object it = object;
                    boolean bl = false;
                    this.runner.successfulLine((String)it);
                }
                break;
            }
            default: {
                RunExecuteActionsKt.logError$default(ReplOutputHandler.class, "Unexpected output type:\n" + outputType, null, 4, null);
            }
        }
        Object[] objectArray = new ReplEscapeType[]{ReplEscapeType.SUCCESS, ReplEscapeType.ERRORS_REPORTED, ReplEscapeType.READLINE_END};
        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)outputType)) {
            this.runner.getCommandHistory().entryProcessed();
        }
    }

    private final void buildWarningIfNeededBeforeInit(String content2) {
        if (!this.isBuildInfoChecked) {
            this.outputProcessor.printBuildInfoWarningIfNeeded();
            this.isBuildInfoChecked = true;
        }
        if (StringsKt.startsWith$default((String)content2, (String)"Welcome", (boolean)false, (int)2, null)) {
            this.outputProcessor.printUserOutput(KotlinIdeaReplBundle.message("repl.is.in.experimental.stage", new Object[0]) + "\n");
        }
        this.outputProcessor.printInitialPrompt(content2);
    }

    private final InputSource strToSource(String s, Charset encoding) {
        byte[] byArray = s.getBytes(encoding);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new InputSource(new ByteArrayInputStream(byArray));
    }

    static /* synthetic */ InputSource strToSource$default(ReplOutputHandler replOutputHandler, String string2, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return replOutputHandler.strToSource(string2, charset);
    }

    private final List<SeverityDetails> createCompilerMessages(String runtimeErrorsReport) {
        ArrayList<SeverityDetails> compilerMessages = new ArrayList<SeverityDetails>();
        Document report = this.factory.newDocumentBuilder().parse(this.strToSource(runtimeErrorsReport, Charsets.UTF_16));
        NodeList entries2 = report.getElementsByTagName("reportEntry");
        int n = entries2.getLength();
        for (int i2 = 0; i2 < n; ++i2) {
            Node node2 = entries2.item(i2);
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element reportEntry = (Element)node2;
            Severity severityLevel = this.toSeverity(reportEntry.getAttribute("severity"));
            int rangeStart = Integer.parseInt(reportEntry.getAttribute("rangeStart"));
            int rangeEnd = Integer.parseInt(reportEntry.getAttribute("rangeEnd"));
            String description2 = reportEntry.getTextContent();
            compilerMessages.add(new SeverityDetails(severityLevel, description2, new TextRange(rangeStart, rangeEnd)));
        }
        return compilerMessages;
    }

    private final Severity toSeverity(String $this$toSeverity) {
        return switch ($this$toSeverity) {
            case "ERROR" -> Severity.ERROR;
            case "WARNING" -> Severity.WARNING;
            case "INFO" -> Severity.INFO;
            default -> throw new IllegalArgumentException("Unsupported Severity: '" + $this$toSeverity + "'");
        };
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReplEscapeType.values().length];
            try {
                nArray[ReplEscapeType.INITIAL_PROMPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.HELP_PROMPT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.USER_OUTPUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.REPL_RESULT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.READLINE_START.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.READLINE_END.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.REPL_INCOMPLETE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.COMPILE_ERROR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.RUNTIME_ERROR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.INTERNAL_ERROR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.ERRORS_REPORTED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplEscapeType.SUCCESS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

