/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.KotlinArtifacts;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "module", "Lcom/intellij/openapi/module/Module;", "previousCompilationFailed", "", "Companion", "kotlin.repl"})
public final class KotlinConsoleKeeper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.console");

    public KotlinConsoleKeeper(@NotNull Project project) {
        this.project = project;
        this.consoleMap = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile) {
        return this.consoleMap.get(virtualFile);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile, @NotNull KotlinConsoleRunner console) {
        return this.consoleMap.put(virtualFile, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile) {
        return this.consoleMap.remove(virtualFile);
    }

    @NotNull
    public final KotlinConsoleRunner run(@NotNull Module module2, boolean previousCompilationFailed) {
        String path2 = module2.getModuleFilePath();
        Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = Companion.createReplCommandLine(this.project, module2);
        TargetEnvironmentRequest environmentRequest = (TargetEnvironmentRequest)pair.component1();
        TargetedCommandLine cmdLine = (TargetedCommandLine)pair.component2();
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module2, environmentRequest, cmdLine, previousCompilationFailed, this.project, KotlinIdeaReplBundle.message("name.kotlin.repl", new Object[0]), path2);
        consoleRunner.initAndRun();
        return consoleRunner;
    }

    public static /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module2, bl);
    }

    @JvmStatic
    @NotNull
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createReplCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.repl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KotlinConsoleKeeper getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinConsoleKeeper> serviceClass$iv = KotlinConsoleKeeper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinConsoleKeeper)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<TargetEnvironmentRequest, TargetedCommandLine> createReplCommandLine(@NotNull Project project, @Nullable Module module2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PathsList pathsList;
            JavaParameters javaParameters = new JavaParametersBuilder(project).withSdkFrom(module2, true).withMainClassName("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler").build();
            WslTargetEnvironmentConfiguration wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk());
            WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = wslConfiguration;
            if (wslTargetEnvironmentConfiguration == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(project)) == null) {
                wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
            }
            WslTargetEnvironmentConfiguration request = wslTargetEnvironmentConfiguration;
            javaParameters.setCharset(null);
            ParametersList $this$createReplCommandLine_u24lambda_u240 = javaParameters.getVMParametersList();
            boolean bl = false;
            $this$createReplCommandLine_u24lambda_u240.add("-Dkotlin.repl.ideMode=true");
            boolean $i$f$isUnitTestMode22 = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                Sdk sdk2 = javaParameters.getJdk();
                boolean bl2 = sdk2 != null && (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) != null ? sdk2.isAtLeast(JavaSdkVersion.JDK_1_9) : false;
                if (bl2) {
                    $this$createReplCommandLine_u24lambda_u240.add("--add-opens");
                    $this$createReplCommandLine_u24lambda_u240.add("java.base/java.util=ALL-UNNAMED");
                }
            }
            PathsList $this$createReplCommandLine_u24lambda_u242 = pathsList = javaParameters.getClassPath();
            boolean bl3 = false;
            Object $i$f$isUnitTestMode22 = new File[]{KotlinArtifacts.getKotlinCompiler(), KotlinArtifacts.getKotlinStdlib(), KotlinArtifacts.getKotlinReflect(), KotlinArtifacts.getKotlinScriptRuntime(), KotlinArtifacts.getTrove4j(), KotlinArtifacts.getKotlinDaemon(), KotlinArtifacts.getKotlinScriptingCompiler(), KotlinArtifacts.getKotlinScriptingCompilerImpl(), KotlinArtifacts.getKotlinScriptingCommon(), KotlinArtifacts.getKotlinScriptingJvm(), KotlinArtifacts.getJetbrainsAnnotations()};
            List classPath = CollectionsKt.listOf((Object[])$i$f$isUnitTestMode22);
            $i$f$isUnitTestMode22 = classPath;
            Object object = $this$createReplCommandLine_u24lambda_u242;
            int $i$f$map2 = 0;
            void var13_24 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                File file3 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Path path2 = file2.toPath();
                String absolutePath = ((Object)path2.toAbsolutePath()).toString();
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    LOG.warn("Compiler dependency classpath " + absolutePath + " does not exist");
                }
                collection.add(absolutePath);
            }
            object.addAll((List)destination$iv$iv);
            if (module2 != null) {
                void $this$filterIsInstanceTo$iv$iv$iv;
                List<String> classPath2 = JavaParametersBuilder.Companion.getModuleDependencies(module2);
                if (!((Collection)classPath2).isEmpty()) {
                    javaParameters.setUseDynamicParameters(javaParameters.isDynamicClasspath());
                    ParametersList $this$createReplCommandLine_u24lambda_u243 = javaParameters.getProgramParametersList();
                    boolean bl5 = false;
                    $this$createReplCommandLine_u24lambda_u243.add("-cp");
                    CompositeParameterTargetedValue compositeValue = new CompositeParameterTargetedValue();
                    object = classPath2.iterator();
                    $i$f$map2 = 0;
                    while (object.hasNext()) {
                        int index = $i$f$map2++;
                        String s = (String)object.next();
                        if (index > 0) {
                            compositeValue.addLocalPart(String.valueOf(request.getTargetPlatform().getPlatform().pathSeparator));
                        }
                        compositeValue.addPathPart(s);
                    }
                    $this$createReplCommandLine_u24lambda_u243.add(compositeValue);
                }
                TargetPlatform $this$subplatformsOfType$iv = TargetPlatformDetectorUtils.getPlatform(module2);
                boolean $i$f$subplatformsOfType = false;
                Iterable $this$filterIsInstance$iv$iv = $this$subplatformsOfType$iv.getComponentPlatforms();
                boolean $i$f$filterIsInstance = false;
                Iterable $i$f$map2 = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof JdkPlatform)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                JdkPlatform jdkPlatform = (JdkPlatform)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
                if (jdkPlatform != null && (jdkPlatform = jdkPlatform.getTargetVersion()) != null) {
                    JdkPlatform it = jdkPlatform;
                    boolean bl6 = false;
                    ParametersList $this$createReplCommandLine_u24lambda_u245_u24lambda_u244 = javaParameters.getProgramParametersList();
                    boolean bl7 = false;
                    $this$createReplCommandLine_u24lambda_u245_u24lambda_u244.add("-jvm-target");
                    $this$createReplCommandLine_u24lambda_u245_u24lambda_u244.add(it.getDescription());
                }
            }
            ParametersList $this$createReplCommandLine_u24lambda_u247 = javaParameters.getProgramParametersList();
            boolean bl8 = false;
            $this$createReplCommandLine_u24lambda_u247.add("-kotlin-home");
            File kotlinHome = KotlinPluginLayout.getKotlinc();
            if (!kotlinHome.exists()) {
                boolean bl9 = false;
                String string2 = "Kotlin compiler is not found";
                throw new IllegalStateException(string2.toString());
            }
            $this$createReplCommandLine_u24lambda_u247.add(new CompositeParameterTargetedValue().addPathPart(((Object)kotlinHome.toPath().toAbsolutePath()).toString()));
            return TuplesKt.to((Object)request, (Object)javaParameters.toCommandLine((TargetEnvironmentRequest)request).build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

