/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.gutter.ConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.ReplIcons;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/console/HistoryUpdater;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "getConsoleView", "()Lcom/intellij/execution/console/LanguageConsoleImpl;", "consoleView$delegate", "Lkotlin/Lazy;", "addCommandTextToHistoryEditor", "", "trimmedCommandText", "", "addFoldingRegion", "historyEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "startOffset", "", "endOffset", "command", "addLineBreakIfNeeded", "printNewCommandInHistory", "Lcom/intellij/openapi/util/TextRange;", "kotlin.repl"})
public final class HistoryUpdater {
    @NotNull
    private final KotlinConsoleRunner runner;
    @NotNull
    private final Lazy consoleView$delegate;

    public HistoryUpdater(@NotNull KotlinConsoleRunner runner) {
        this.runner = runner;
        this.consoleView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageConsoleImpl>(this){
            final /* synthetic */ HistoryUpdater this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LanguageConsoleImpl invoke() {
                LanguageConsoleView languageConsoleView = HistoryUpdater.access$getRunner$p(this.this$0).getConsoleView();
                Intrinsics.checkNotNull((Object)languageConsoleView, (String)"null cannot be cast to non-null type com.intellij.execution.console.LanguageConsoleImpl");
                return (LanguageConsoleImpl)languageConsoleView;
            }
        }));
    }

    private final LanguageConsoleImpl getConsoleView() {
        Lazy lazy = this.consoleView$delegate;
        return (LanguageConsoleImpl)lazy.getValue();
    }

    @NotNull
    public final TextRange printNewCommandInHistory(@NotNull String trimmedCommandText) {
        RangeHighlighter rangeHighlighter;
        EditorEx historyEditor = this.getConsoleView().getHistoryViewer();
        this.addLineBreakIfNeeded(historyEditor);
        int startOffset = historyEditor.getDocument().getTextLength();
        this.addCommandTextToHistoryEditor(trimmedCommandText);
        int endOffset2 = historyEditor.getDocument().getTextLength();
        this.addFoldingRegion(historyEditor, startOffset, endOffset2, trimmedCommandText);
        RangeHighlighter $this$printNewCommandInHistory_u24lambda_u240 = rangeHighlighter = historyEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset2, 6000, null, HighlighterTargetArea.EXACT_RANGE);
        boolean bl = false;
        IconWithTooltip historyMarker = this.runner.isReadLineMode() ? ReplIcons.INSTANCE.getREADLINE_MARKER() : ReplIcons.INSTANCE.getCOMMAND_MARKER();
        $this$printNewCommandInHistory_u24lambda_u240.setGutterIconRenderer((GutterIconRenderer)new ConsoleIndicatorRenderer(historyMarker));
        historyEditor.getScrollingModel().scrollVertically(endOffset2);
        return new TextRange(startOffset, endOffset2);
    }

    private final void addCommandTextToHistoryEditor(String trimmedCommandText) {
        EditorEx consoleEditor = this.getConsoleView().getConsoleEditor();
        DocumentEx consoleDocument = consoleEditor.getDocument();
        consoleDocument.setText((CharSequence)trimmedCommandText);
        LanguageConsoleImpl.printWithHighlighting((LanguageConsoleView)((LanguageConsoleView)this.getConsoleView()), (Editor)((Editor)consoleEditor), (TextRange)new TextRange(0, consoleDocument.getTextLength()));
        this.getConsoleView().flushDeferredText();
        consoleDocument.setText((CharSequence)"");
    }

    private final void addLineBreakIfNeeded(EditorEx historyEditor) {
        if (this.runner.isReadLineMode()) {
            return;
        }
        DocumentEx historyDocument = historyEditor.getDocument();
        String historyText = historyDocument.getText();
        int textLength = historyText.length();
        if (!StringsKt.endsWith$default((CharSequence)historyText, (char)'\n', (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
            if (textLength == 0) {
                this.runner.addGutterIndicator(historyEditor, ReplIcons.INSTANCE.getHISTORY_INDICATOR());
            } else {
                historyDocument.insertString(textLength + 1, (CharSequence)"\n");
            }
        } else if (!StringsKt.endsWith$default((String)historyText, (String)"\n\n", (boolean)false, (int)2, null)) {
            historyDocument.insertString(textLength, (CharSequence)"\n");
        }
    }

    private final void addFoldingRegion(EditorEx historyEditor, int startOffset, int endOffset2, String command2) {
        List cmdLines = StringsKt.lines((CharSequence)command2);
        int linesCount = cmdLines.size();
        if (linesCount < 2) {
            return;
        }
        FoldingModelEx foldingModel = historyEditor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> HistoryUpdater.addFoldingRegion$lambda$1(foldingModel, startOffset, endOffset2, cmdLines));
    }

    private static final void addFoldingRegion$lambda$1(FoldingModelEx $foldingModel, int $startOffset, int $endOffset, List $cmdLines) {
        $foldingModel.addFoldRegion($startOffset, $endOffset, $cmdLines.get(0) + " ...");
    }

    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$p(HistoryUpdater $this) {
        return $this.runner;
    }
}

