/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.HistoryUpdateListener;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/console/HistoryKeyListener;", "Ljava/awt/event/KeyAdapter;", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "project", "Lcom/intellij/openapi/project/Project;", "consoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "history", "Lorg/jetbrains/kotlin/console/CommandHistory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/kotlin/console/CommandHistory;)V", "historyPos", "", "prevCaretOffset", "unfinishedCommand", "", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "moveHistoryCursor", "move", "Lorg/jetbrains/kotlin/console/HistoryKeyListener$HistoryMove;", "onNewEntry", "entry", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "HistoryMove", "kotlin.repl"})
public final class HistoryKeyListener
extends KeyAdapter
implements HistoryUpdateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx consoleEditor;
    @NotNull
    private final CommandHistory history;
    private int historyPos;
    private int prevCaretOffset;
    @NotNull
    private String unfinishedCommand;

    public HistoryKeyListener(@NotNull Project project, @NotNull EditorEx consoleEditor, @NotNull CommandHistory history) {
        this.project = project;
        this.consoleEditor = consoleEditor;
        this.history = history;
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @Override
    public void onNewEntry(@NotNull CommandHistory.Entry entry) {
        this.historyPos = this.history.getSize();
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                this.moveHistoryCursor(HistoryMove.UP);
                break;
            }
            case 40: {
                this.moveHistoryCursor(HistoryMove.DOWN);
                break;
            }
            case 37: 
            case 39: {
                this.prevCaretOffset = this.consoleEditor.getCaretModel().getOffset();
            }
        }
    }

    private final void moveHistoryCursor(HistoryMove move) {
        if (this.history.getSize() == 0) {
            return;
        }
        if (LookupManager.getInstance((Project)this.project).getActiveLookup() != null) {
            return;
        }
        CaretModel caret = this.consoleEditor.getCaretModel();
        DocumentEx document = this.consoleEditor.getDocument();
        int curOffset = caret.getOffset();
        int curLine = document.getLineNumber(curOffset);
        int totalLines = document.getLineCount();
        boolean isMultiline2 = totalLines > 1;
        switch (WhenMappings.$EnumSwitchMapping$0[move.ordinal()]) {
            case 1: {
                if (curLine != 0 || isMultiline2 && this.prevCaretOffset != 0) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                if (this.historyPos == this.history.getSize()) {
                    this.unfinishedCommand = document.getText();
                }
                this.historyPos = Math.max(this.historyPos - 1, 0);
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.moveHistoryCursor$lambda$0(document, this, caret));
                break;
            }
            case 2: {
                if (this.historyPos == this.history.getSize()) {
                    return;
                }
                if (curLine != totalLines - 1 || isMultiline2 && this.prevCaretOffset != document.getTextLength()) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                this.historyPos = Math.min(this.historyPos + 1, this.history.getSize());
                WriteCommandAction.runWriteCommandAction((Project)this.project, () -> HistoryKeyListener.moveHistoryCursor$lambda$1(document, this));
            }
        }
    }

    private static final void moveHistoryCursor$lambda$0(DocumentEx $document, HistoryKeyListener this$0, CaretModel $caret) {
        $document.setText((CharSequence)this$0.history.get(this$0.historyPos).getEntryText());
        EditorUtil.scrollToTheEnd((Editor)((Editor)this$0.consoleEditor));
        this$0.prevCaretOffset = 0;
        $caret.moveToOffset(0);
    }

    private static final void moveHistoryCursor$lambda$1(DocumentEx $document, HistoryKeyListener this$0) {
        $document.setText((CharSequence)(this$0.historyPos == this$0.history.getSize() ? this$0.unfinishedCommand : this$0.history.get(this$0.historyPos).getEntryText()));
        this$0.prevCaretOffset = $document.getTextLength();
        EditorUtil.scrollToTheEnd((Editor)((Editor)this$0.consoleEditor));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/console/HistoryKeyListener$HistoryMove;", "", "(Ljava/lang/String;I)V", "UP", "DOWN", "kotlin.repl"})
    private static final class HistoryMove
    extends Enum<HistoryMove> {
        public static final /* enum */ HistoryMove UP = new HistoryMove();
        public static final /* enum */ HistoryMove DOWN = new HistoryMove();
        private static final /* synthetic */ HistoryMove[] $VALUES;

        public static HistoryMove[] values() {
            return (HistoryMove[])$VALUES.clone();
        }

        public static HistoryMove valueOf(String value2) {
            return Enum.valueOf(HistoryMove.class, value2);
        }

        static {
            $VALUES = historyMoveArray = new HistoryMove[]{HistoryMove.UP, HistoryMove.DOWN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HistoryMove.values().length];
            try {
                nArray[HistoryMove.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HistoryMove.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

