/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtPsiTypeProviderMixIn;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtTypeMappingMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\t\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0002J\u001a\u0010\u0012\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0014\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker;", "", "()V", "typeParametersMatch", "", "psi", "Lcom/intellij/psi/PsiMethod;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "isTheSameTypes", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "context", "Lcom/intellij/psi/PsiType;", "ktType", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "mode", "Lorg/jetbrains/kotlin/analysis/api/types/KtTypeMappingMode;", "isVararg", "representsTheSameDeclaration", "returnTypesMatch", "valueParametersMatch", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "symbol-light-classes"})
@SourceDebugExtension(value={"SMAP\nPsiDeclarationAndKtSymbolEqualityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n23539#2,8:89\n1#3:97\n1864#4,3:98\n*S KotlinDebug\n*F\n+ 1 PsiDeclarationAndKtSymbolEqualityChecker.kt\norg/jetbrains/kotlin/analysis/providers/PsiDeclarationAndKtSymbolEqualityChecker\n*L\n43#1:89,8\n58#1:98,3\n*E\n"})
public final class PsiDeclarationAndKtSymbolEqualityChecker {
    @NotNull
    public static final PsiDeclarationAndKtSymbolEqualityChecker INSTANCE = new PsiDeclarationAndKtSymbolEqualityChecker();

    private PsiDeclarationAndKtSymbolEqualityChecker() {
    }

    public final boolean representsTheSameDeclaration(@NotNull KtAnalysisSession $this$representsTheSameDeclaration, @NotNull PsiMethod psi2, @NotNull KtCallableSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)$this$representsTheSameDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!this.returnTypesMatch($this$representsTheSameDeclaration, psi2, symbol2)) {
            return false;
        }
        if (!this.typeParametersMatch(psi2, symbol2)) {
            return false;
        }
        return !(symbol2 instanceof KtFunctionLikeSymbol) || this.valueParametersMatch($this$representsTheSameDeclaration, psi2, (KtFunctionLikeSymbol)symbol2);
    }

    private final boolean returnTypesMatch(KtAnalysisSession $this$returnTypesMatch, PsiMethod psi2, KtCallableSymbol symbol2) {
        boolean bl;
        if (symbol2 instanceof KtConstructorSymbol) {
            return true;
        }
        PsiType psiType = psi2.getReturnType();
        if (psiType != null) {
            PsiType it = psiType;
            boolean bl2 = false;
            bl = INSTANCE.isTheSameTypes($this$returnTypesMatch, psi2, it, symbol2.getReturnType(), KtTypeMappingMode.RETURN_TYPE, false);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean typeParametersMatch(PsiMethod psi2, KtCallableSymbol symbol2) {
        void $this$zip$iv;
        if (psi2.getTypeParameters().length != symbol2.getTypeParameters().size()) {
            return false;
        }
        PsiTypeParameter[] psiTypeParameterArray = psi2.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"psi.typeParameters");
        Object[] objectArray = psiTypeParameterArray;
        Iterable other$iv = symbol2.getTypeParameters();
        boolean $i$f$zip = false;
        int arraySize$iv = ((void)$this$zip$iv).length;
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10), arraySize$iv));
        int i$iv = 0;
        for (Object element$iv : other$iv) {
            void typeParameterSymbol;
            void psiTypeParameter;
            if (i$iv >= arraySize$iv) break;
            int n = i$iv++;
            KtTypeParameterSymbol ktTypeParameterSymbol = (KtTypeParameterSymbol)element$iv;
            PsiTypeParameter psiTypeParameter2 = (PsiTypeParameter)$this$zip$iv[n];
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)psiTypeParameter.getName(), (Object)typeParameterSymbol.getName().asString())) {
                return false;
            }
            arrayList.add(Unit.INSTANCE);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean valueParametersMatch(KtAnalysisSession $this$valueParametersMatch, PsiMethod psi2, KtFunctionLikeSymbol symbol2) {
        int valueParameterCount;
        int n = valueParameterCount = symbol2.isExtension() ? symbol2.getValueParameters().size() + 1 : symbol2.getValueParameters().size();
        if (psi2.getParameterList().getParametersCount() != valueParameterCount) {
            return false;
        }
        if (symbol2.isExtension()) {
            boolean bl;
            PsiParameter psiParameter = psi2.getParameterList().getParameters()[0];
            KtType ktType = KtCallableSymbolKt.getReceiverType(symbol2);
            if (ktType != null) {
                KtType it = ktType;
                boolean bl2 = false;
                PsiType psiType = psiParameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psiParameter.type");
                bl = PsiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes$default(INSTANCE, $this$valueParametersMatch, psi2, psiType, it, null, false, 8, null);
            } else {
                bl = false;
            }
            if (!bl) {
                return false;
            }
        }
        int offset2 = symbol2.isExtension() ? 1 : 0;
        Iterable $this$forEachIndexed$iv = symbol2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void valueParameterSymbol;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtValueParameterSymbol ktValueParameterSymbol = (KtValueParameterSymbol)item$iv;
            int index = n2;
            boolean bl = false;
            PsiParameter psiParameter = psi2.getParameterList().getParameters()[index + offset2];
            if (!Intrinsics.areEqual((Object)valueParameterSymbol.getName().asString(), (Object)psiParameter.getName())) {
                return false;
            }
            if (valueParameterSymbol.isVararg() != psiParameter.isVarArgs()) {
                return false;
            }
            PsiType psiType = psiParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psiParameter.type");
            if (INSTANCE.isTheSameTypes($this$valueParametersMatch, psi2, psiType, valueParameterSymbol.getReturnType(), KtTypeMappingMode.VALUE_PARAMETER, valueParameterSymbol.isVararg())) continue;
            return false;
        }
        return true;
    }

    private final boolean isTheSameTypes(KtAnalysisSession $this$isTheSameTypes, PsiMethod context2, PsiType psi2, KtType ktType, KtTypeMappingMode mode, boolean isVararg2) {
        PsiType psiType;
        if (Intrinsics.areEqual((Object)psi2, (Object)PsiType.VOID) && $this$isTheSameTypes.isUnit(ktType)) {
            return true;
        }
        PsiType psiType2 = KtPsiTypeProviderMixIn.asPsiType$default($this$isTheSameTypes, ktType, (PsiElement)context2, true, mode, false, 8, null);
        if (psiType2 == null) {
            return false;
        }
        PsiType ktTypeRendered = psiType2;
        if (isVararg2) {
            PsiArrayType psiArrayType = ktTypeRendered.createArrayType();
            Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"ktTypeRendered.createArrayType()");
            psiType = (PsiType)psiArrayType;
        } else {
            psiType = ktTypeRendered;
        }
        PsiType rendered2 = psiType;
        return Intrinsics.areEqual((Object)rendered2, (Object)psi2);
    }

    static /* synthetic */ boolean isTheSameTypes$default(PsiDeclarationAndKtSymbolEqualityChecker psiDeclarationAndKtSymbolEqualityChecker, KtAnalysisSession ktAnalysisSession, PsiMethod psiMethod, PsiType psiType, KtType ktType, KtTypeMappingMode ktTypeMappingMode, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            ktTypeMappingMode = KtTypeMappingMode.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return psiDeclarationAndKtSymbolEqualityChecker.isTheSameTypes(ktAnalysisSession, psiMethod, psiType, ktType, ktTypeMappingMode, bl);
    }
}

