/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.KtConstantValueForAnnotation;
import org.jetbrains.kotlin.analysis.api.KtInitializerValue;
import org.jetbrains.kotlin.analysis.api.KtNonConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.types.KtTypeNullability;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0013*\u00020\u0013H\u0000\u00a8\u0006\u0014"}, d2={"asKtInitializerValue", "Lorg/jetbrains/kotlin/analysis/api/KtInitializerValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "forAnnotationDefaultValue", "", "computeImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "useSiteSession", "getReferencedElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "toConeNullability", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "Lorg/jetbrains/kotlin/analysis/api/types/KtTypeNullability;", "unwrap", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "analysis-api-fir"})
public final class FirUtilsKt {
    @NotNull
    public static final PsiElement unwrap(@NotNull PsiElement $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return $this$unwrap instanceof KtExpression ? (PsiElement)FirUtilsKt.unwrap((KtExpression)$this$unwrap) : $this$unwrap;
    }

    @NotNull
    public static final KtExpression unwrap(@NotNull KtExpression $this$unwrap) {
        KtExpression ktExpression;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        KtExpression ktExpression2 = $this$unwrap;
        if (ktExpression2 instanceof KtLabeledExpression) {
            KtExpression ktExpression3 = ((KtLabeledExpression)$this$unwrap).getBaseExpression();
            object = ktExpression3 != null ? FirUtilsKt.unwrap(ktExpression3) : null;
        } else if (ktExpression2 instanceof KtAnnotatedExpression) {
            KtExpression ktExpression4 = ((KtAnnotatedExpression)$this$unwrap).getBaseExpression();
            object = ktExpression4 != null ? FirUtilsKt.unwrap(ktExpression4) : null;
        } else if (ktExpression2 instanceof KtFunctionLiteral) {
            PsiElement psiElement2 = ((KtFunctionLiteral)$this$unwrap).getParent();
            KtLambdaExpression ktLambdaExpression2 = psiElement2 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement2 : null;
            object = ktLambdaExpression2 != null ? FirUtilsKt.unwrap((KtExpression)ktLambdaExpression2) : null;
        } else {
            object = ktExpression = $this$unwrap;
        }
        if (object == null) {
            ktExpression = $this$unwrap;
        }
        return ktExpression;
    }

    @NotNull
    public static final ConeKotlinType getReferencedElementType(@NotNull FirNamedReference $this$getReferencedElementType) {
        Collection<FirBasedSymbol<?>> collection;
        Intrinsics.checkNotNullParameter((Object)$this$getReferencedElementType, (String)"<this>");
        FirNamedReference firNamedReference = $this$getReferencedElementType;
        if (firNamedReference instanceof FirResolvedNamedReference) {
            collection = CollectionsKt.listOf(((FirResolvedNamedReference)$this$getReferencedElementType).getResolvedSymbol());
        } else if (firNamedReference instanceof FirErrorNamedReference) {
            collection = org.jetbrains.kotlin.analysis.api.fir.FirUtilsKt.getCandidateSymbols((FirErrorNamedReference)$this$getReferencedElementType);
        } else {
            throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass($this$getReferencedElementType.getClass())).toString());
        }
        Collection<FirBasedSymbol<?>> symbols = collection;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)symbols);
        Object e = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        FirCallableDeclaration firCallableDeclaration = e instanceof FirCallableDeclaration ? (FirCallableDeclaration)e : null;
        if (firCallableDeclaration == null) {
            return new ConeErrorType(new ConeUnresolvedNameError($this$getReferencedElementType.getName()), false, null, null, 14, null);
        }
        FirCallableDeclaration firCallableDeclaration2 = firCallableDeclaration;
        return firCallableDeclaration2.getSymbol().getResolvedReturnType();
    }

    @NotNull
    public static final ConeNullability toConeNullability(@NotNull KtTypeNullability $this$toConeNullability) {
        ConeNullability coneNullability;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toConeNullability), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toConeNullability.ordinal()]) {
            case 1: {
                coneNullability = ConeNullability.NULLABLE;
                break;
            }
            case 2: {
                coneNullability = ConeNullability.NOT_NULL;
                break;
            }
            case 3: {
                coneNullability = ConeNullability.UNKNOWN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneNullability;
    }

    @Nullable
    public static final FqName computeImportableName(@NotNull FirCallableSymbol<?> $this$computeImportableName, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter($this$computeImportableName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)useSiteSession), (String)"useSiteSession");
        ClassId classId = $this$computeImportableName.getCallableId().getClassId();
        if (classId == null) {
            return $this$computeImportableName.getCallableId().asSingleFqName();
        }
        ClassId containingClassId = classId;
        if ($this$computeImportableName instanceof FirConstructorSymbol) {
            return containingClassId.asSingleFqName();
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$computeImportableName, useSiteSession);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> containingClass = firClassLikeSymbol;
        boolean canBeImported = containingClass.getOrigin() instanceof FirDeclarationOrigin.Java || FirHelpersKt.getClassKind(containingClass) == ClassKind.ENUM_CLASS || FirHelpersKt.getClassKind(containingClass) == ClassKind.OBJECT;
        return canBeImported ? $this$computeImportableName.getCallableId().asSingleFqName() : null;
    }

    @NotNull
    public static final KtInitializerValue asKtInitializerValue(@NotNull FirExpression $this$asKtInitializerValue, @NotNull FirSession session, boolean forAnnotationDefaultValue) {
        KtAnnotationValue annotationConstantValue;
        Intrinsics.checkNotNullParameter((Object)$this$asKtInitializerValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        PsiElement psiElement2 = UtilsKt.getPsi($this$asKtInitializerValue);
        KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
        KtConstantValue evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue($this$asKtInitializerValue, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
        KtInitializerValue ktInitializerValue = evaluated == null ? (forAnnotationDefaultValue ? ((annotationConstantValue = FirAnnotationValueConverter.INSTANCE.toConstantValue($this$asKtInitializerValue, session)) != null ? (KtInitializerValue)new KtConstantValueForAnnotation(annotationConstantValue, ktExpression) : (KtInitializerValue)new KtNonConstantInitializerValue(ktExpression)) : (KtInitializerValue)new KtNonConstantInitializerValue(ktExpression)) : (KtInitializerValue)new KtConstantInitializerValue(evaluated, ktExpression);
        return ktInitializerValue;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtTypeNullability.values().length];
            try {
                nArray[KtTypeNullability.NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtTypeNullability.NON_NULLABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtTypeNullability.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

