/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirImportOptimizerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirReferenceShortenerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImplStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0002\u0013\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "", "isQualified", "", "()Z", "outerTypeQualifier", "getOuterTypeQualifier", "()Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "referencedByName", "Lorg/jetbrains/kotlin/name/Name;", "getReferencedByName", "()Lorg/jetbrains/kotlin/name/Name;", "referencedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "getReferencedClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "Companion", "KtDotExpressionTypeQualifier", "KtUserTypeQualifier", "Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier$KtDotExpressionTypeQualifier;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier$KtUserTypeQualifier;", "analysis-api-fir"})
interface TypeQualifier {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.analysis.api.fir.components.TypeQualifier$Companion.$$INSTANCE;

    @NotNull
    public ClassId getReferencedClassId();

    @NotNull
    public Name getReferencedByName();

    public boolean isQualified();

    @Nullable
    public TypeQualifier getOuterTypeQualifier();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier$Companion;", "", "()V", "createFor", "Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "qualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "analysis-api-fir"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final TypeQualifier createFor(@NotNull FirResolvedQualifier qualifier2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
            ClassId classId = qualifier2.getClassId();
            if (classId == null) {
                return null;
            }
            ClassId wholeClassId = classId;
            PsiElement psiElement2 = UtilsKt.getPsi(qualifier2);
            KtExpression ktExpression2 = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression psi2 = ktExpression2;
            psiElement2 = psi2;
            if (psiElement2 instanceof KtDotQualifiedExpression) {
                ktExpression = psi2;
            } else if (psiElement2 instanceof KtNameReferenceExpression) {
                KtDotQualifiedExpression ktDotQualifiedExpression = KtFirReferenceShortenerKt.getDotQualifiedExpressionForSelector((KtElement)psi2);
                ktExpression = (KtExpression)(ktDotQualifiedExpression != null ? (KtExpressionImplStub)ktDotQualifiedExpression : (KtExpressionImplStub)psi2);
            } else {
                ktExpression = psi2;
            }
            KtExpression wholeQualifier = ktExpression;
            return new KtDotExpressionTypeQualifier(wholeClassId, (KtElement)wholeQualifier);
        }

        @Nullable
        public final TypeQualifier createFor(@NotNull FirResolvedTypeRef typeRef) {
            Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
            ClassId classId = KtFirImportOptimizerKt.access$getResolvedClassId(typeRef);
            if (classId == null) {
                return null;
            }
            ClassId wholeClassId = classId;
            PsiElement psiElement2 = UtilsKt.getPsi(typeRef);
            KtTypeReference ktTypeReference = psiElement2 instanceof KtTypeReference ? (KtTypeReference)psiElement2 : null;
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference psi2 = ktTypeReference;
            KtTypeElement ktTypeElement = psi2.getTypeElement();
            KtTypeElement ktTypeElement2 = ktTypeElement != null ? KtPsiUtilKt.unwrapNullability((KtTypeElement)ktTypeElement) : null;
            KtUserType ktUserType2 = ktTypeElement2 instanceof KtUserType ? (KtUserType)ktTypeElement2 : null;
            if (ktUserType2 == null) {
                return null;
            }
            KtUserType wholeUserType = ktUserType2;
            return new KtUserTypeQualifier(wholeClassId, wholeUserType);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier$KtDotExpressionTypeQualifier;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "referencedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "qualifier", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/psi/KtElement;)V", "dotQualifier", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "isQualified", "", "()Z", "outerTypeQualifier", "getOuterTypeQualifier", "()Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "referencedByName", "Lorg/jetbrains/kotlin/name/Name;", "getReferencedByName", "()Lorg/jetbrains/kotlin/name/Name;", "getReferencedClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "typeNameReference", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "analysis-api-fir"})
    private static final class KtDotExpressionTypeQualifier
    implements TypeQualifier {
        @NotNull
        private final ClassId referencedClassId;
        @Nullable
        private final KtDotQualifiedExpression dotQualifier;
        @NotNull
        private final KtNameReferenceExpression typeNameReference;

        public KtDotExpressionTypeQualifier(@NotNull ClassId referencedClassId, @NotNull KtElement qualifier2) {
            Intrinsics.checkNotNullParameter((Object)referencedClassId, (String)"referencedClassId");
            Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
            this.referencedClassId = referencedClassId;
            this.dotQualifier = qualifier2 instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)qualifier2 : null;
            KtDotExpressionTypeQualifier ktDotExpressionTypeQualifier = this;
            KtDotExpressionTypeQualifier ktDotExpressionTypeQualifier2 = this;
            boolean bl = false;
            if (!(qualifier2 instanceof KtNameReferenceExpression || qualifier2 instanceof KtDotQualifiedExpression || qualifier2 instanceof KtCallExpression)) {
                boolean bl2 = false;
                String string2 = "Unexpected qualifier '" + qualifier2.getText() + "' of type '" + Reflection.getOrCreateKotlinClass(qualifier2.getClass()) + '\'';
                throw new IllegalArgumentException(string2.toString());
            }
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)qualifier2);
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression == null) {
                throw new IllegalStateException(("Cannot get referenced name from '" + qualifier2.getText() + '\'').toString());
            }
            ktDotExpressionTypeQualifier2.typeNameReference = ktNameReferenceExpression;
        }

        @Override
        @NotNull
        public ClassId getReferencedClassId() {
            return this.referencedClassId;
        }

        @Override
        @NotNull
        public Name getReferencedByName() {
            return this.typeNameReference.getReferencedNameAsName();
        }

        @Override
        public boolean isQualified() {
            return this.dotQualifier != null;
        }

        @Override
        @Nullable
        public TypeQualifier getOuterTypeQualifier() {
            ClassId classId = this.getReferencedClassId().getOuterClassId();
            if (classId == null) {
                return null;
            }
            ClassId outerClassId = classId;
            KtDotQualifiedExpression ktDotQualifiedExpression = this.dotQualifier;
            if (ktDotQualifiedExpression == null || (ktDotQualifiedExpression = ktDotQualifiedExpression.getReceiverExpression()) == null) {
                return null;
            }
            KtDotQualifiedExpression outerQualifier = ktDotQualifiedExpression;
            return new KtDotExpressionTypeQualifier(outerClassId, (KtElement)outerQualifier);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier$KtUserTypeQualifier;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "referencedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "qualifier", "Lorg/jetbrains/kotlin/psi/KtUserType;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/psi/KtUserType;)V", "isQualified", "", "()Z", "outerTypeQualifier", "getOuterTypeQualifier", "()Lorg/jetbrains/kotlin/analysis/api/fir/components/TypeQualifier;", "referencedByName", "Lorg/jetbrains/kotlin/name/Name;", "getReferencedByName", "()Lorg/jetbrains/kotlin/name/Name;", "getReferencedClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "analysis-api-fir"})
    private static final class KtUserTypeQualifier
    implements TypeQualifier {
        @NotNull
        private final ClassId referencedClassId;
        @NotNull
        private final KtUserType qualifier;

        public KtUserTypeQualifier(@NotNull ClassId referencedClassId, @NotNull KtUserType qualifier2) {
            Intrinsics.checkNotNullParameter((Object)referencedClassId, (String)"referencedClassId");
            Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
            this.referencedClassId = referencedClassId;
            this.qualifier = qualifier2;
        }

        @Override
        @NotNull
        public ClassId getReferencedClassId() {
            return this.referencedClassId;
        }

        @Override
        @NotNull
        public Name getReferencedByName() {
            KtSimpleNameExpression ktSimpleNameExpression = this.qualifier.getReferenceExpression();
            if (ktSimpleNameExpression == null || (ktSimpleNameExpression = ktSimpleNameExpression.getReferencedNameAsName()) == null) {
                throw new IllegalStateException(("Cannot get referenced name from '" + this.qualifier.getText() + '\'').toString());
            }
            return ktSimpleNameExpression;
        }

        @Override
        public boolean isQualified() {
            return this.qualifier.getQualifier() != null;
        }

        @Override
        @Nullable
        public TypeQualifier getOuterTypeQualifier() {
            ClassId classId = this.getReferencedClassId().getOuterClassId();
            if (classId == null) {
                return null;
            }
            ClassId outerClassId = classId;
            KtUserType ktUserType2 = this.qualifier.getQualifier();
            if (ktUserType2 == null) {
                return null;
            }
            KtUserType outerQualifier = ktUserType2;
            return new KtUserTypeQualifier(outerClassId, outerQualifier);
        }
    }
}

