/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolInfoProvider;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirBackingFieldSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirPackageSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "annotationUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "getGetterDeprecation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol;", "getJavaGetterName", "Lorg/jetbrains/kotlin/name/Name;", "getJavaSetterName", "getJvmName", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "getJvmNameAsString", "", "getSetterDeprecation", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirSymbolInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 checks.kt\norg/jetbrains/kotlin/analysis/utils/errors/ChecksKt\n*L\n1#1,119:1\n1#2:120\n1#2:125\n1#2:131\n13#3,4:121\n17#3:126\n13#3,4:127\n17#3:132\n*S KotlinDebug\n*F\n+ 1 KtFirSymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider\n*L\n78#1:125\n90#1:131\n78#1:121,4\n78#1:126\n90#1:127,4\n90#1:132\n*E\n"})
public final class KtFirSymbolInfoProvider
extends KtSymbolInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final ApiVersion apiVersion;

    public KtFirSymbolInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
        this.apiVersion = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getAnalysisSession().getUseSiteSession$analysis_api_fir()).getApiVersion();
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (symbol2 instanceof KtFirBackingFieldSymbol || symbol2 instanceof KtFirPackageSymbol || symbol2 instanceof KtReceiverParameterSymbol) {
            return null;
        }
        if (!(symbol2 instanceof KtFirSymbol)) {
            boolean bl = false;
            String string2 = String.valueOf(Reflection.getOrCreateKotlinClass(this.getClass()));
            throw new IllegalArgumentException(string2.toString());
        }
        Object firSymbol = ((KtFirSymbol)symbol2).getFirSymbol();
        if (firSymbol instanceof FirPropertySymbol) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, this.apiVersion, annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, this.apiVersion, new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2, @Nullable AnnotationUseSiteTarget annotationUseSiteTarget) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (annotationUseSiteTarget != null) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{annotationUseSiteTarget};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), this.apiVersion, annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), this.apiVersion, new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @Override
    @Nullable
    public DeprecationInfo getGetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), this.apiVersion, annotationUseSiteTargetArray);
    }

    @Override
    @Nullable
    public DeprecationInfo getSetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), this.apiVersion, annotationUseSiteTargetArray);
    }

    @Override
    @NotNull
    public Name getJavaGetterName(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            return ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaGetterSymbol().getName();
        }
        Object firProperty = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string3 = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string3.toString());
        }
        return this.getJvmName((FirProperty)firProperty, false);
    }

    @Override
    @Nullable
    public Name getJavaSetterName(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            KtFunctionSymbol ktFunctionSymbol = ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaSetterSymbol();
            return ktFunctionSymbol != null ? ktFunctionSymbol.getName() : null;
        }
        Object firProperty = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
        boolean $i$f$requireIsInstance = false;
        if (!(firProperty instanceof FirProperty)) {
            boolean bl = false;
            String string3 = "Expected " + Reflection.getOrCreateKotlinClass(FirProperty.class) + " instead of " + Reflection.getOrCreateKotlinClass(firProperty.getClass()) + " for " + firProperty;
            throw new IllegalArgumentException(string3.toString());
        }
        if (((FirProperty)firProperty).isVal()) {
            return null;
        }
        return this.getJvmName((FirProperty)firProperty, true);
    }

    private final Name getJvmName(FirProperty property2, boolean isSetter) {
        if (FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)property2, StandardClassIds.Annotations.INSTANCE.getJvmField(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir())) {
            return property2.getName();
        }
        Name name2 = Name.identifier((String)this.getJvmNameAsString(property2, isSetter));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(getJvmNameAsString(property, isSetter))");
        return name2;
    }

    private final String getJvmNameAsString(FirProperty property2, boolean isSetter) {
        String jvmNameFromAccessor;
        FirPropertyAccessor accessor;
        AnnotationUseSiteTarget useSiteTarget = isSetter ? AnnotationUseSiteTarget.PROPERTY_SETTER : AnnotationUseSiteTarget.PROPERTY_GETTER;
        String jvmNameFromProperty = FirAnnotationUtilsKt.getJvmNameFromAnnotation(property2, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), useSiteTarget);
        if (jvmNameFromProperty != null) {
            return jvmNameFromProperty;
        }
        FirPropertyAccessor firPropertyAccessor = accessor = isSetter ? property2.getSetter() : property2.getGetter();
        String string2 = jvmNameFromAccessor = firPropertyAccessor != null ? FirAnnotationUtilsKt.getJvmNameFromAnnotation$default(firPropertyAccessor, this.getAnalysisSession().getUseSiteSession$analysis_api_fir(), null, 2, null) : null;
        if (jvmNameFromAccessor != null) {
            return jvmNameFromAccessor;
        }
        String string3 = property2.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"property.name.identifier");
        String identifier2 = string3;
        return isSetter ? JvmAbi.setterName((String)identifier2) : JvmAbi.getterName((String)identifier2);
    }
}

