/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.FieldDescription;
import org.jetbrains.eval4j.MembersKt;
import org.jetbrains.eval4j.MethodDescription;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020#H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0016J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0019H\u0016J\u0018\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u00103\u001a\u00020\u000fH\u0002J.\u00104\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u0006\u00106\u001a\u00020\fH\u0016J0\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00192\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010;\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\u001c\u0010<\u001a\u00020\f2\b\u0010=\u001a\u0004\u0018\u00010\u00112\b\u0010>\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u0015H\u0016J2\u0010B\u001a\u0004\u0018\u00010:2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020%2\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001d2\u0006\u0010F\u001a\u00020\tH\u0016J2\u0010G\u001a\u0004\u0018\u00010:2\u0006\u0010H\u001a\u00020I2\u0006\u0010E\u001a\u00020%2\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010G\u001a\u0004\u0018\u00010:2\u0006\u0010H\u001a\u00020J2\u0006\u0010E\u001a\u00020%2\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001d2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010K\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u0015H\u0016J\u001a\u0010K\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u00152\b\u0010M\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010N\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020\u0005H\u0002J\u0010\u0010O\u001a\u00020\u00192\u0006\u0010P\u001a\u00020\u000fH\u0016J,\u0010Q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001d2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dH\u0002J\u0018\u0010S\u001a\u00020\u00192\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001dH\u0002J\u0018\u0010T\u001a\u00020\u00192\u0006\u0010U\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010V\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u0015H\u0016J\u001e\u0010W\u001a\u00020\u00192\u0006\u0010U\u001a\u00020\u00152\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0016J \u0010Y\u001a\u00020Z2\u0006\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00192\u0006\u0010[\u001a\u00020\u0019H\u0016J \u0010\\\u001a\u00020Z2\u0006\u00100\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010[\u001a\u00020\u0019H\u0016J\u0018\u0010]\u001a\u00020Z2\u0006\u0010 \u001a\u00020!2\u0006\u0010[\u001a\u00020\u0019H\u0016J \u0010^\u001a\u00020\f2\u0006\u0010E\u001a\u00020%2\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001dH\u0002J\u0018\u0010_\u001a\u00020\u00192\u0006\u0010`\u001a\u00020\u00192\u0006\u0010H\u001a\u00020\u0015H\u0002J\f\u0010,\u001a\u00020a*\u00020\u0019H\u0002J\u0018\u0010b\u001a\u00020c*\u00020\u00152\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010d\u001a\u00020#*\u00020\u00152\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010e\u001a\u00020Z*\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001dH\u0002J\u0014\u0010f\u001a\u00020Z*\n\u0012\u0006\u0012\u0004\u0018\u00010:0\u001dH\u0002J\u0012\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d*\u00020%H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006h"}, d2={"Lorg/jetbrains/eval4j/jdi/JDIEval;", "Lorg/jetbrains/eval4j/Eval;", "vm", "Lcom/sun/jdi/VirtualMachine;", "defaultClassLoader", "Lcom/sun/jdi/ClassLoaderReference;", "thread", "Lcom/sun/jdi/ThreadReference;", "invokePolicy", "", "(Lcom/sun/jdi/VirtualMachine;Lcom/sun/jdi/ClassLoaderReference;Lcom/sun/jdi/ThreadReference;I)V", "isJava8OrLater", "", "primitiveTypes", "", "", "kotlin.jvm.PlatformType", "Lcom/sun/jdi/Type;", "getThread", "()Lcom/sun/jdi/ThreadReference;", "arrayElementType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getArrayElementType", "(Lorg/jetbrains/org/objectweb/asm/Type;)Lorg/jetbrains/org/objectweb/asm/Type;", "fillArray", "Lorg/jetbrains/eval4j/Value;", "elementType", "size", "nestedSizes", "", "findField", "Lcom/sun/jdi/Field;", "fieldDesc", "Lorg/jetbrains/eval4j/FieldDescription;", "receiver", "Lcom/sun/jdi/ReferenceType;", "findMethod", "Lcom/sun/jdi/Method;", "methodDesc", "Lorg/jetbrains/eval4j/MethodDescription;", "clazz", "findMethodOrNull", "findStaticField", "getArrayElement", "array", "index", "getArrayLength", "getField", "instance", "getStaticField", "internalNameWithoutModuleSuffix", "name", "invokeMethod", "arguments", "invokeSpecial", "invokeMethodWithReflection", "ownerType", "args", "Lcom/sun/jdi/Value;", "invokeStaticMethod", "isArrayOfInterfaces", "valueType", "expectedType", "isInstanceOf", "value", "targetType", "jdiInvokeMethod", "obj", "Lcom/sun/jdi/ObjectReference;", "method", "policy", "jdiInvokeStaticMethod", "type", "Lcom/sun/jdi/ClassType;", "Lcom/sun/jdi/InterfaceType;", "loadClass", "classType", "classLoader", "loadClassByName", "loadString", "str", "mapArguments", "expectedTypes", "mirrorOfArgs", "newArray", "arrayType", "newInstance", "newMultiDimensionalArray", "dimensionSizes", "setArrayElement", "", "newValue", "setField", "setStaticField", "shouldInvokeMethodWithReflection", "unboxType", "boxedValue", "Lcom/sun/jdi/ArrayReference;", "asArrayType", "Lcom/sun/jdi/ArrayType;", "asReferenceType", "disableCollection", "enableCollection", "safeArgumentTypes", "kotlin.jvm-debugger.eval4j"})
public class JDIEval
implements Eval {
    @NotNull
    private final VirtualMachine vm;
    @Nullable
    private final ClassLoaderReference defaultClassLoader;
    @NotNull
    private final ThreadReference thread;
    private final int invokePolicy;
    @NotNull
    private final Map<String, com.sun.jdi.Type> primitiveTypes;
    private final boolean isJava8OrLater;

    public JDIEval(@NotNull VirtualMachine vm, @Nullable ClassLoaderReference defaultClassLoader, @NotNull ThreadReference thread, int invokePolicy) {
        this.vm = vm;
        this.defaultClassLoader = defaultClassLoader;
        this.thread = thread;
        this.invokePolicy = invokePolicy;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Type.BOOLEAN_TYPE.getClassName(), (Object)this.vm.mirrorOf(true).type()), TuplesKt.to((Object)Type.BYTE_TYPE.getClassName(), (Object)this.vm.mirrorOf((byte)1).type()), TuplesKt.to((Object)Type.SHORT_TYPE.getClassName(), (Object)this.vm.mirrorOf((short)1).type()), TuplesKt.to((Object)Type.INT_TYPE.getClassName(), (Object)this.vm.mirrorOf(1).type()), TuplesKt.to((Object)Type.CHAR_TYPE.getClassName(), (Object)this.vm.mirrorOf('1').type()), TuplesKt.to((Object)Type.LONG_TYPE.getClassName(), (Object)this.vm.mirrorOf(1L).type()), TuplesKt.to((Object)Type.FLOAT_TYPE.getClassName(), (Object)this.vm.mirrorOf(1.0f).type()), TuplesKt.to((Object)Type.DOUBLE_TYPE.getClassName(), (Object)this.vm.mirrorOf(1.0).type())};
        this.primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
        this.isJava8OrLater = StringUtil.compareVersionNumbers((String)this.vm.version(), (String)"1.8") >= 0;
    }

    @NotNull
    protected final ThreadReference getThread() {
        return this.thread;
    }

    @Override
    @NotNull
    public Value loadClass(@NotNull Type classType) {
        return this.loadClass(classType, this.defaultClassLoader);
    }

    private final Value loadClass(Type classType, ClassLoaderReference classLoader2) {
        List<ReferenceType> loadedClasses = this.vm.classesByName(JdiEvalKt.getJdiName(classType));
        if (!((Collection)loadedClasses).isEmpty()) {
            for (ReferenceType loadedClass : loadedClasses) {
                if (!loadedClass.isPrepared() || !JdiEvalKt.access$getBOOTSTRAP_CLASS_DESCRIPTORS$p().contains(classType.getDescriptor()) && !Intrinsics.areEqual((Object)loadedClass.classLoader(), (Object)classLoader2)) continue;
                return JdiValuesKt.asValue(loadedClass.classObject());
            }
        }
        if (classLoader2 == null) {
            return this.invokeStaticMethod(new MethodDescription(JdiEvalKt.access$getCLASS$p().getInternalName(), "forName", "(Ljava/lang/String;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(JdiEvalKt.getJdiName(classType)))));
        }
        Object[] objectArray = new AbstractValue[]{JdiValuesKt.asValue(this.vm.mirrorOf(JdiEvalKt.getJdiName(classType))), ValuesKt.boolean(true), JdiValuesKt.asValue(classLoader2)};
        return this.invokeStaticMethod(new MethodDescription(JdiEvalKt.access$getCLASS$p().getInternalName(), "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object[])objectArray));
    }

    private final com.sun.jdi.Type loadClassByName(String name2, ClassLoaderReference classLoader2) {
        com.sun.jdi.Type type2;
        String baseTypeName;
        CharSequence $this$count$iv = name2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '[')) continue;
            ++count$iv;
        }
        int dimensions = count$iv;
        if (dimensions > 0) {
            String string2 = name2.substring(0, StringsKt.indexOf$default((CharSequence)name2, (char)'[', (int)0, (boolean)false, (int)6, null));
            v1 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            v1 = baseTypeName = name2;
        }
        if ((type2 = this.primitiveTypes.get(baseTypeName)) == null) {
            type2 = this.asReferenceType(Type.getType((String)("L" + baseTypeName + ";")), classLoader2);
        }
        com.sun.jdi.Type baseType = type2;
        return dimensions == 0 ? baseType : (com.sun.jdi.Type)this.asReferenceType(Type.getType((String)(StringsKt.repeat((CharSequence)"[", (int)dimensions) + JdiValuesKt.asType(baseType).getDescriptor())), classLoader2);
    }

    @Override
    @NotNull
    public Value loadString(@NotNull String str) {
        return JdiValuesKt.asValue(this.vm.mirrorOf(str));
    }

    @Override
    @NotNull
    public Value newInstance(@NotNull Type classType) {
        return new NewObjectValue(classType);
    }

    @Override
    public boolean isInstanceOf(@NotNull Value value2, @NotNull Type targetType) {
        boolean bl;
        boolean bl2 = bl = targetType.getSort() == 10 || targetType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Can't check isInstanceOf() for non-object type " + targetType;
            throw new AssertionError((Object)string2);
        }
        Value clazz = this.loadClass(targetType);
        return ValuesKt.getBoolean(Eval.invokeMethod$default(this, clazz, new MethodDescription(JdiEvalKt.access$getCLASS$p().getInternalName(), "isInstance", "(Ljava/lang/Object;)Z", false), CollectionsKt.listOf((Object)value2), false, 8, null));
    }

    private final ReferenceType asReferenceType(Type $this$asReferenceType, ClassLoaderReference classLoader2) {
        ClassObjectReference classObjectReference = JdiValuesKt.getJdiClass(this.loadClass($this$asReferenceType, classLoader2));
        Intrinsics.checkNotNull((Object)classObjectReference);
        return classObjectReference.reflectedType();
    }

    static /* synthetic */ ReferenceType asReferenceType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asReferenceType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asReferenceType(type2, classLoaderReference);
    }

    private final ArrayType asArrayType(Type $this$asArrayType, ClassLoaderReference classLoader2) {
        ReferenceType referenceType = this.asReferenceType($this$asArrayType, classLoader2);
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
        return (ArrayType)referenceType;
    }

    static /* synthetic */ ArrayType asArrayType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asArrayType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asArrayType(type2, classLoaderReference);
    }

    @Override
    @NotNull
    public Value newArray(@NotNull Type arrayType, int size) {
        ArrayType jdiArrayType = JDIEval.asArrayType$default(this, arrayType, null, 1, null);
        return JdiValuesKt.asValue(jdiArrayType.newInstance(size));
    }

    private final Type getArrayElementType(Type $this$arrayElementType) {
        boolean bl;
        boolean bl2 = bl = $this$arrayElementType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Not an array type: " + $this$arrayElementType;
            throw new AssertionError((Object)string2);
        }
        String string3 = $this$arrayElementType.getDescriptor().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        return Type.getType((String)string3);
    }

    private final Value fillArray(Type elementType, int size, List<Integer> nestedSizes) {
        Value arr = this.newArray(Type.getType((String)("[" + elementType.getDescriptor())), size);
        if (!((Collection)nestedSizes).isEmpty()) {
            Type nestedElementType = this.getArrayElementType(elementType);
            int nestedSize = ((Number)nestedSizes.get(0)).intValue();
            List tail = CollectionsKt.drop((Iterable)nestedSizes, (int)1);
            for (int i2 = 0; i2 < size; ++i2) {
                this.setArrayElement(arr, ValuesKt.int(i2), this.fillArray(nestedElementType, nestedSize, tail));
            }
        }
        return arr;
    }

    @Override
    @NotNull
    public Value newMultiDimensionalArray(@NotNull Type arrayType, @NotNull List<Integer> dimensionSizes) {
        return this.fillArray(this.getArrayElementType(arrayType), ((Number)dimensionSizes.get(0)).intValue(), CollectionsKt.drop((Iterable)dimensionSizes, (int)1));
    }

    private final ArrayReference array(Value $this$array) {
        ObjectReference objectReference = ValuesKt.checkNull(JdiValuesKt.getJdiObj($this$array));
        Intrinsics.checkNotNull((Object)objectReference, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayReference");
        return (ArrayReference)objectReference;
    }

    @Override
    @NotNull
    public Value getArrayLength(@NotNull Value array2) {
        return ValuesKt.int(this.array(array2).length());
    }

    @Override
    @NotNull
    public Value getArrayElement(@NotNull Value array2, @NotNull Value index) {
        try {
            return JdiValuesKt.asValue(this.array(array2).getValue(ValuesKt.getInt(index)));
        }
        catch (IndexOutOfBoundsException e) {
            ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public void setArrayElement(@NotNull Value array2, @NotNull Value index, @NotNull Value newValue) {
        try {
            this.array(array2).setValue(ValuesKt.getInt(index), JdiValuesKt.asJdiValue(newValue, this.vm, this.getArrayElementType(array2.getAsmType())));
            return;
        }
        catch (IndexOutOfBoundsException e) {
            ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    private final Field findField(FieldDescription fieldDesc, ReferenceType receiver2) {
        Comparable<ReferenceType> comparable = receiver2;
        if (comparable != null && (comparable = comparable.fieldByName(fieldDesc.getName())) != null) {
            Comparable<ReferenceType> it = comparable;
            boolean bl = false;
            return it;
        }
        Field field2 = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(fieldDesc), null, 1, null).fieldByName(fieldDesc.getName());
        if (field2 != null) {
            Field it = field2;
            boolean bl = false;
            return it;
        }
        ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field not found: " + fieldDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Field findField$default(JDIEval jDIEval, FieldDescription fieldDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findField");
        }
        if ((n & 2) != 0) {
            referenceType = null;
        }
        return jDIEval.findField(fieldDescription, referenceType);
    }

    private final Field findStaticField(FieldDescription fieldDesc) {
        Field field2 = JDIEval.findField$default(this, fieldDesc, null, 2, null);
        if (!field2.isStatic()) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field is not static: " + fieldDesc));
            throw new KotlinNothingValueException();
        }
        return field2;
    }

    @Override
    @NotNull
    public Value getStaticField(@NotNull FieldDescription fieldDesc) {
        Field field2 = this.findStaticField(fieldDesc);
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(field2){
            final /* synthetic */ Field $field;
            {
                this.$field = $field;
                super(0);
            }

            public final com.sun.jdi.Value invoke() {
                return this.$field.declaringType().getValue(this.$field);
            }
        }), field2, null, 2, null));
    }

    @Override
    public void setStaticField(@NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        Field field2 = this.findStaticField(fieldDesc);
        if (field2.isFinal()) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't modify a final field: " + field2));
            throw new KotlinNothingValueException();
        }
        ReferenceType referenceType = field2.declaringType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't a field in a non-class: " + field2));
            throw new KotlinNothingValueException();
        }
        ClassType clazz = classType;
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, JdiValuesKt.asType(field2.type()));
        JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(clazz, field2, jdiValue){
            final /* synthetic */ ClassType $clazz;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;
            {
                this.$clazz = $clazz;
                this.$field = $field;
                this.$jdiValue = $jdiValue;
                super(0);
            }

            public final void invoke() {
                this.$clazz.setValue(this.$field, this.$jdiValue);
            }
        }), field2, null, 2, null);
    }

    private final Method findMethod(MethodDescription methodDesc, ReferenceType clazz) {
        Method method = this.findMethodOrNull(methodDesc, clazz);
        if (method != null) {
            return method;
        }
        ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method not found: " + methodDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Method findMethod$default(JDIEval jDIEval, MethodDescription methodDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMethod");
        }
        if ((n & 2) != 0) {
            referenceType = JDIEval.asReferenceType$default(jDIEval, MembersKt.getOwnerType(methodDescription), null, 1, null);
        }
        return jDIEval.findMethod(methodDescription, referenceType);
    }

    /*
     * WARNING - void declaration
     */
    private final Method findMethodOrNull(MethodDescription methodDesc, ReferenceType clazz) {
        String methodName2 = methodDesc.getName();
        Method method = null;
        ReferenceType referenceType = clazz;
        if (referenceType instanceof ClassType) {
            method = ((ClassType)clazz).concreteMethodByName(methodName2, methodDesc.getDesc());
        } else if (referenceType instanceof ArrayType) {
            ReferenceType objectType = JDIEval.asReferenceType$default(this, JdiEvalKt.access$getOBJECT$p(), null, 1, null);
            method = this.findMethodOrNull(methodDesc, objectType);
            if (method == null && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"clone") && Intrinsics.areEqual((Object)methodDesc.getDesc(), (Object)"()[Ljava/lang/Object;")) {
                method = this.findMethodOrNull(new MethodDescription(JdiEvalKt.access$getOBJECT$p().getInternalName(), "clone", "()[Ljava/lang/Object;", false), objectType);
            }
        } else {
            method = (Method)CollectionsKt.firstOrNull(clazz.methodsByName(methodName2, methodDesc.getDesc()));
        }
        if (method != null) {
            return method;
        }
        String internalNameWithoutSuffix = this.internalNameWithoutModuleSuffix(methodName2);
        if (internalNameWithoutSuffix != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = clazz.visibleMethods();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                String name2 = it.name();
                if (!(StringsKt.startsWith$default((String)name2, (String)internalNameWithoutSuffix, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)name2, (char)'$', (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.signature(), (Object)methodDesc.getDesc()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List internalMethods = (List)destination$iv$iv;
            if (!((Collection)internalMethods).isEmpty()) {
                Method method2 = (Method)CollectionsKt.singleOrNull((List)internalMethods);
                if (method2 == null) {
                    ValuesKt.throwBrokenCodeException(new IllegalArgumentException("Several internal methods found for " + methodDesc));
                    throw new KotlinNothingValueException();
                }
                return method2;
            }
        }
        return null;
    }

    private final String internalNameWithoutModuleSuffix(String name2) {
        String demangledName;
        String string2;
        int indexOfDollar = StringsKt.indexOf$default((CharSequence)name2, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (indexOfDollar >= 0) {
            String string3 = name2.substring(0, indexOfDollar);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = null;
        }
        String string4 = demangledName = string2;
        return string4 != null ? string4 + "$" : null;
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Override
    @NotNull
    public Value invokeStaticMethod(@NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2) {
        Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
        if (!method.isStatic()) {
            ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method is not static: " + methodDesc));
            throw new KotlinNothingValueException();
        }
        ReferenceType declaringType = method.declaringType();
        List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(method));
        if (this.shouldInvokeMethodWithReflection(method, args)) {
            return this.invokeMethodWithReflection(JdiValuesKt.asType(declaringType), ValuesKt.getNULL_VALUE(), args, methodDesc);
        }
        this.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(declaringType, this, method, args){
            final /* synthetic */ ReferenceType $declaringType;
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ Method $method;
            final /* synthetic */ List<com.sun.jdi.Value> $args;
            {
                this.$declaringType = $declaringType;
                this.this$0 = $receiver;
                this.$method = $method;
                this.$args = $args;
                super(0);
            }

            @Nullable
            public final com.sun.jdi.Value invoke() {
                com.sun.jdi.Value value2;
                ReferenceType referenceType = this.$declaringType;
                if (referenceType instanceof ClassType) {
                    value2 = this.this$0.jdiInvokeStaticMethod((ClassType)this.$declaringType, this.$method, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                } else if (referenceType instanceof InterfaceType) {
                    if (!JDIEval.access$isJava8OrLater$p(this.this$0)) {
                        String message2 = "Calling interface static methods is not supported in JVM " + JDIEval.access$getVm$p(this.this$0).version() + " (" + this.$method + ")";
                        ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message2));
                        throw new KotlinNothingValueException();
                    }
                    value2 = this.this$0.jdiInvokeStaticMethod((InterfaceType)this.$declaringType, this.$method, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                } else {
                    String message3 = "Calling static methods is only supported for classes and interfaces (" + this.$method + ")";
                    ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message3));
                    throw new KotlinNothingValueException();
                }
                return value2;
            }
        }), method, null, 2, null);
        this.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    @Override
    @NotNull
    public Value getField(@NotNull Value instance2, @NotNull FieldDescription fieldDesc) {
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        Field field2 = this.findField(fieldDesc, receiver2.referenceType());
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(receiver2, field2){
            final /* synthetic */ ObjectReference $receiver;
            final /* synthetic */ Field $field;
            {
                this.$receiver = $receiver;
                this.$field = $field;
                super(0);
            }

            public final com.sun.jdi.Value invoke() {
                com.sun.jdi.Value value2;
                try {
                    value2 = this.$receiver.getValue(this.$field);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Possibly incompatible types: field declaring type = " + this.$field.declaringType() + ", instance type = " + this.$receiver.referenceType());
                }
                return value2;
            }
        }), field2, receiver2));
    }

    @Override
    public void setField(@NotNull Value instance2, @NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        Field field2 = this.findField(fieldDesc, receiver2.referenceType());
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, JdiValuesKt.asType(field2.type()));
        JdiEvalKt.access$mayThrow((Function0)new Function0<Unit>(receiver2, field2, jdiValue){
            final /* synthetic */ ObjectReference $receiver;
            final /* synthetic */ Field $field;
            final /* synthetic */ com.sun.jdi.Value $jdiValue;
            {
                this.$receiver = $receiver;
                this.$field = $field;
                this.$jdiValue = $jdiValue;
                super(0);
            }

            public final void invoke() {
                this.$receiver.setValue(this.$field, this.$jdiValue);
            }
        });
    }

    private final Value unboxType(Value boxedValue, Type type2) {
        MethodDescription methodDescription;
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Integer", "intValue", "()I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BOOLEAN_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.CHAR_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "charValue", "()C", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.SHORT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "shortValue", "()S", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Long", "longValue", "()J", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BYTE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Byte", "byteValue", "()B", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Float", "floatValue", "()F", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Double", "doubleValue", "()D", false);
        } else {
            throw new UnsupportedOperationException("Couldn't unbox non primitive type " + type2.getInternalName());
        }
        MethodDescription method = methodDescription;
        return this.invokeMethod(boxedValue, method, CollectionsKt.emptyList(), true);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
        return obj.invokeMethod(this.thread, method, args, policy);
    }

    @Override
    @NotNull
    public Value invokeMethod(@NotNull Value instance2, @NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2, boolean invokeSpecial) {
        Value value2;
        if (invokeSpecial && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"<init>")) {
            Method ctor = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            Intrinsics.checkNotNull((Object)instance2, (String)"null cannot be cast to non-null type org.jetbrains.eval4j.NewObjectValue");
            ReferenceType referenceType = JDIEval.asReferenceType$default(this, ((NewObjectValue)instance2).getAsmType(), null, 1, null);
            Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
            ClassType clazz = (ClassType)referenceType;
            List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(ctor));
            this.disableCollection(args);
            ObjectReference result2 = (ObjectReference)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow((Function0)new Function0<ObjectReference>(clazz, this, ctor, args){
                final /* synthetic */ ClassType $clazz;
                final /* synthetic */ JDIEval this$0;
                final /* synthetic */ Method $ctor;
                final /* synthetic */ List<com.sun.jdi.Value> $args;
                {
                    this.$clazz = $clazz;
                    this.this$0 = $receiver;
                    this.$ctor = $ctor;
                    this.$args = $args;
                    super(0);
                }

                public final ObjectReference invoke() {
                    return this.$clazz.newInstance(this.this$0.getThread(), this.$ctor, this.$args, JDIEval.access$getInvokePolicy$p(this.this$0));
                }
            }), ctor, null, 2, null);
            this.enableCollection(args);
            ((NewObjectValue)instance2).setValue(result2);
            return JdiValuesKt.asValue(result2);
        }
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance2));
        if (invokeSpecial) {
            Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            value2 = JDIEval.invokeMethod$doInvokeMethod(this, arguments2, instance2, methodDesc, obj, method, this.invokePolicy | 2);
        } else {
            ReferenceType referenceType = obj.referenceType();
            if (referenceType == null) {
                referenceType = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(methodDesc), null, 1, null);
            }
            Method method = this.findMethod(methodDesc, referenceType);
            value2 = JDIEval.invokeMethod$doInvokeMethod(this, arguments2, instance2, methodDesc, obj, method, this.invokePolicy);
        }
        return value2;
    }

    private final boolean shouldInvokeMethodWithReflection(Method method, List<? extends com.sun.jdi.Value> args) {
        boolean bl;
        block6: {
            List<com.sun.jdi.Type> list2;
            if (method.isVarArgs()) {
                return false;
            }
            try {
                list2 = method.argumentTypes();
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
            List<com.sun.jdi.Type> argumentTypes2 = list2;
            Iterable $this$any$iv = CollectionsKt.zip((Iterable)args, (Iterable)argumentTypes2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)it.getFirst();
                    if (!this.isArrayOfInterfaces(value2 != null ? value2.type() : null, (com.sun.jdi.Type)it.getSecond())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayOfInterfaces(com.sun.jdi.Type valueType, com.sun.jdi.Type expectedType) {
        ArrayType arrayType = valueType instanceof ArrayType ? (ArrayType)valueType : null;
        if (!((arrayType != null ? arrayType.componentType() : null) instanceof InterfaceType)) return false;
        ArrayType arrayType2 = expectedType instanceof ArrayType ? (ArrayType)expectedType : null;
        if (!Intrinsics.areEqual((Object)(arrayType2 != null ? arrayType2.componentType() : null), (Object)JDIEval.asReferenceType$default(this, JdiEvalKt.access$getOBJECT$p(), null, 1, null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Value invokeMethodWithReflection(Type ownerType, Value instance2, List<? extends com.sun.jdi.Value> args, MethodDescription methodDesc) {
        void $this$toTypedArray$iv;
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Eval eval2 = this;
        Value value2 = this.loadClass(ownerType);
        MethodDescription methodDescription = new MethodDescription(JdiEvalKt.access$getCLASS$p().getInternalName(), "getDeclaredMethod", "(Ljava/lang/String;[L" + JdiEvalKt.access$getCLASS$p().getInternalName() + ";)Ljava/lang/reflect/Method;", true);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)JdiValuesKt.asValue(this.vm.mirrorOf(methodDesc.getName())));
        Object[] objectArray = (Object[])MembersKt.getParameterTypes(methodDesc);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        MethodDescription methodDescription2 = methodDescription;
        Value value3 = value2;
        Eval eval3 = eval2;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type2 = (Type)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadClass((Type)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new Value[0]));
        Value methodToInvoke = Eval.invokeMethod$default(eval3, value3, methodDescription2, CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Value[spreadBuilder.size()])), false, 8, null);
        Eval.invokeMethod$default(this, methodToInvoke, new MethodDescription(Type.getType(AccessibleObject.class).getInternalName(), "setAccessible", "(Z)V", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(true))), false, 8, null);
        objectArray = new Value[]{instance2, this.mirrorOfArgs(args)};
        Value invocationResult = Eval.invokeMethod$default(this, methodToInvoke, new MethodDescription(methodToInvoke.getAsmType().getInternalName(), "invoke", "(L" + JdiEvalKt.access$getOBJECT$p().getInternalName() + ";[L" + JdiEvalKt.access$getOBJECT$p().getInternalName() + ";)L" + JdiEvalKt.access$getOBJECT$p().getInternalName() + ";", true), CollectionsKt.listOf((Object[])objectArray), false, 8, null);
        return MembersKt.getReturnType(methodDesc).getSort() != 10 && MembersKt.getReturnType(methodDesc).getSort() != 9 && MembersKt.getReturnType(methodDesc).getSort() != 0 ? this.unboxType(invocationResult, MembersKt.getReturnType(methodDesc)) : invocationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Value mirrorOfArgs(List<? extends com.sun.jdi.Value> args) {
        Value arrayObject = this.newArray(Type.getType((String)("[" + JdiEvalKt.access$getOBJECT$p().getDescriptor())), args.size());
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            com.sun.jdi.Value value3 = (com.sun.jdi.Value)item$iv;
            int index = n;
            boolean bl = false;
            Value indexValue = JdiValuesKt.asValue(this.vm.mirrorOf(index));
            this.setArrayElement(arrayObject, indexValue, JdiValuesKt.asValue((com.sun.jdi.Value)value2));
        }
        return arrayObject;
    }

    private final void disableCollection(List<? extends com.sun.jdi.Value> $this$disableCollection) {
        Iterable $this$forEach$iv = $this$disableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            ObjectReference objectReference = it instanceof ObjectReference ? (ObjectReference)it : null;
            if (objectReference == null) continue;
            objectReference.disableCollection();
        }
    }

    private final void enableCollection(List<? extends com.sun.jdi.Value> $this$enableCollection) {
        Iterable $this$forEach$iv = $this$enableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            ObjectReference objectReference = it instanceof ObjectReference ? (ObjectReference)it : null;
            if (objectReference == null) continue;
            objectReference.enableCollection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> mapArguments(List<? extends Value> arguments2, List<? extends com.sun.jdi.Type> expectedTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)arguments2, (Iterable)expectedTypes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Value arg = (Value)it.component1();
            com.sun.jdi.Type expectedType = (com.sun.jdi.Type)it.component2();
            collection.add(JdiValuesKt.asJdiValue(arg, this.vm, JdiValuesKt.asType(expectedType)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<com.sun.jdi.Type> safeArgumentTypes(Method $this$safeArgumentTypes) {
        try {
            return $this$safeArgumentTypes.argumentTypes();
        }
        catch (ClassNotLoadedException e) {
            v0 = $this$safeArgumentTypes.argumentTypeNames();
            Intrinsics.checkNotNull(v0);
            $this$map$iv = v0;
            $i$f$map = false;
            var5_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block36: {
                    block35: {
                        var10_10 = (String)item$iv$iv;
                        var14_14 = destination$iv$iv;
                        $i$a$-map-JDIEval$safeArgumentTypes$1 = false;
                        v1 = $this$safeArgumentTypes.declaringType();
                        v2 = classLoader = v1 != null ? v1.classLoader() : null;
                        if (classLoader == null) break block35;
                        v3 = this.loadClassByName((String)name, classLoader);
                        break block36;
                    }
                    var13_13 = name;
                    if (var13_13 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var13_13.hashCode()) {
                        case 3625364: {
                            if (var13_13.equals("void")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 64711720: {
                            if (var13_13.equals("boolean")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 3039496: {
                            if (var13_13.equals("byte")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case -1325958191: {
                            if (var13_13.equals("double")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 3052374: {
                            if (var13_13.equals("char")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 109413500: {
                            if (var13_13.equals("short")) {
                                tmp = 6;
                            }
                            break;
                        }
                        case 97526364: {
                            if (var13_13.equals("float")) {
                                tmp = 7;
                            }
                            break;
                        }
                        case 104431: {
                            if (var13_13.equals("int")) {
                                tmp = 8;
                            }
                            break;
                        }
                        case 3327612: {
                            if (var13_13.equals("long")) {
                                tmp = 9;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v3 = $this$safeArgumentTypes.virtualMachine().mirrorOfVoid().type();
                            break;
                        }
                        case 2: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.BOOLEAN_TYPE.getClassName());
                            break;
                        }
                        case 3: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.BYTE_TYPE.getClassName());
                            break;
                        }
                        case 5: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.CHAR_TYPE.getClassName());
                            break;
                        }
                        case 6: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.SHORT_TYPE.getClassName());
                            break;
                        }
                        case 8: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.INT_TYPE.getClassName());
                            break;
                        }
                        case 9: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.LONG_TYPE.getClassName());
                            break;
                        }
                        case 7: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.FLOAT_TYPE.getClassName());
                            break;
                        }
                        case 4: {
                            v3 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.DOUBLE_TYPE.getClassName());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v4 = (ReferenceType)CollectionsKt.firstOrNull($this$safeArgumentTypes.virtualMachine().classesByName((String)name));
                            if (v4 == null) {
                                throw new IllegalStateException("Unknown class " + (String)name);
                            }
                            v3 = v4;
                        }
                    }
                }
                var14_14.add(v3);
            }
            return (List)destination$iv$iv;
        }
    }

    private static final Value invokeMethod$doInvokeMethod(JDIEval this$0, List<? extends Value> $arguments, Value $instance, MethodDescription $methodDesc, ObjectReference obj, Method method, int policy) {
        List<com.sun.jdi.Value> args = this$0.mapArguments($arguments, this$0.safeArgumentTypes(method));
        if (this$0.shouldInvokeMethodWithReflection(method, args)) {
            return this$0.invokeMethodWithReflection($instance.getAsmType(), $instance, args, $methodDesc);
        }
        this$0.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow((Function0)new Function0<com.sun.jdi.Value>(this$0, obj, method, args, policy){
            final /* synthetic */ JDIEval this$0;
            final /* synthetic */ ObjectReference $obj;
            final /* synthetic */ Method $method;
            final /* synthetic */ List<com.sun.jdi.Value> $args;
            final /* synthetic */ int $policy;
            {
                this.this$0 = $receiver;
                this.$obj = $obj;
                this.$method = $method;
                this.$args = $args;
                this.$policy = $policy;
                super(0);
            }

            @Nullable
            public final com.sun.jdi.Value invoke() {
                return this.this$0.jdiInvokeMethod(this.$obj, this.$method, this.$args, this.$policy);
            }
        }), method, obj);
        this$0.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    public static final /* synthetic */ int access$getInvokePolicy$p(JDIEval $this) {
        return $this.invokePolicy;
    }

    public static final /* synthetic */ boolean access$isJava8OrLater$p(JDIEval $this) {
        return $this.isJava8OrLater;
    }

    public static final /* synthetic */ VirtualMachine access$getVm$p(JDIEval $this) {
        return $this.vm;
    }
}

