/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmdcodecompletion.ftl;

import com.android.gmdcodecompletion.GmdCodeCompleteUtilsKt;
import com.android.gmdcodecompletion.GmdDeviceCatalogService;
import com.android.gmdcodecompletion.GmdDeviceCatalogState;
import com.android.gmdcodecompletion.ftl.FtlDeviceCatalog;
import com.android.gmdcodecompletion.ftl.FtlDeviceCatalogState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@State(name="FtlDeviceCatalogService", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Service(value={Service.Level.APP})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u00020\u0002X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogService;", "Lcom/android/gmdcodecompletion/GmdDeviceCatalogService;", "Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogState;", "()V", "myDeviceCatalogState", "getMyDeviceCatalogState", "()Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogState;", "setMyDeviceCatalogState", "(Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogState;)V", "runBeforeUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "updateDeviceCatalogTaskAction", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.android.gmd-code-completion"})
public final class FtlDeviceCatalogService
extends GmdDeviceCatalogService<FtlDeviceCatalogState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FtlDeviceCatalogState myDeviceCatalogState = new FtlDeviceCatalogState(null, null, 3, null);

    public FtlDeviceCatalogService() {
        super((GmdDeviceCatalogState)new FtlDeviceCatalogState(null, null, 3, null), "FtlDeviceCatalogService");
    }

    @Override
    @NotNull
    protected FtlDeviceCatalogState getMyDeviceCatalogState() {
        return this.myDeviceCatalogState;
    }

    @Override
    protected void setMyDeviceCatalogState(@NotNull FtlDeviceCatalogState ftlDeviceCatalogState) {
        Intrinsics.checkNotNullParameter((Object)ftlDeviceCatalogState, (String)"<set-?>");
        this.myDeviceCatalogState = ftlDeviceCatalogState;
    }

    @Override
    protected boolean runBeforeUpdate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GmdCodeCompleteUtilsKt.isFtlPluginEnabled(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceCatalogTaskAction(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Lock lock = this.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            indicator.setText("Checking cache freshness");
            if (this.getMyDeviceCatalogState().isCacheFresh()) {
                return;
            }
            indicator.setText("Fetching device catalog from FTL Server");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, 7);
            Date date = calendar.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"calendar.time");
            this.setMyDeviceCatalogState(new FtlDeviceCatalogState(date, new FtlDeviceCatalog().syncDeviceCatalog()));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        indicator.setText("FTL device catalog cache updated");
        indicator.setFraction(1.0);
    }

    @JvmStatic
    @NotNull
    public static final FtlDeviceCatalogService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogService$Companion;", "", "()V", "getInstance", "Lcom/android/gmdcodecompletion/ftl/FtlDeviceCatalogService;", "intellij.android.gmd-code-completion"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FtlDeviceCatalogService getInstance() {
            Object object = ApplicationManager.getApplication().getService(FtlDeviceCatalogService.class);
            Intrinsics.checkNotNull((Object)object);
            return (FtlDeviceCatalogService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

