/*
 * Decompiled with CFR 0.152.
 */
package com.android.gmdcodecompletion.completions;

import com.android.gmdcodecompletion.CurrentPsiElement;
import com.android.gmdcodecompletion.DevicePropertyName;
import com.android.gmdcodecompletion.GmdCodeCompleteUtilsKt;
import com.android.gmdcodecompletion.GmdDeviceCatalog;
import com.android.gmdcodecompletion.MinAndTargetApiLevel;
import com.android.gmdcodecompletion.completions.DeviceType;
import com.android.gmdcodecompletion.completions.GmdCodeCompletionContributorKt;
import com.android.gmdcodecompletion.completions.GmdCodeCompletionLookupElement;
import com.android.gmdcodecompletion.completions.GmdDeviceDefinitionPatternMatchingProvider;
import com.android.gmdcodecompletion.completions.lookupelementprovider.BaseLookupElementProvider;
import com.android.gmdcodecompletion.completions.lookupelementprovider.FtlLookupElementProvider;
import com.android.gmdcodecompletion.completions.lookupelementprovider.ManagedVirtualLookupElementProvider;
import com.android.gmdcodecompletion.ftl.FtlDeviceCatalog;
import com.android.gmdcodecompletion.ftl.FtlDeviceCatalogService;
import com.android.gmdcodecompletion.ftl.FtlDeviceCatalogState;
import com.android.gmdcodecompletion.managedvirtual.ManagedVirtualDeviceCatalog;
import com.android.gmdcodecompletion.managedvirtual.ManagedVirtualDeviceCatalogService;
import com.android.gmdcodecompletion.managedvirtual.ManagedVirtualDeviceCatalogState;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/gmdcodecompletion/completions/GmdCodeCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "addDeviceParameterSuggestion", "", "devicePropertyName", "Lcom/android/gmdcodecompletion/DevicePropertyName;", "position", "Lcom/intellij/psi/PsiElement;", "deviceCatalog", "Lcom/android/gmdcodecompletion/GmdDeviceCatalog;", "sorter", "Lcom/intellij/codeInsight/completion/CompletionSorter;", "lookupElementProvider", "Lcom/android/gmdcodecompletion/completions/lookupelementprovider/BaseLookupElementProvider;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addDevicePropertyNameSuggestion", "deviceType", "Lcom/android/gmdcodecompletion/completions/DeviceType;", "addGmdCompletions", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getDevicePropertyName", "intellij.android.gmd-code-completion"})
@SourceDebugExtension(value={"SMAP\nGmdCodeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GmdCodeCompletionContributor.kt\ncom/android/gmdcodecompletion/completions/GmdCodeCompletionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1603#2,9:245\n1851#2:254\n1852#2:256\n1612#2:257\n1#3:255\n*S KotlinDebug\n*F\n+ 1 GmdCodeCompletionContributor.kt\ncom/android/gmdcodecompletion/completions/GmdCodeCompletionContributor\n*L\n160#1:245,9\n160#1:254\n160#1:256\n160#1:257\n160#1:255\n*E\n"})
public final class GmdCodeCompletionContributor
extends CompletionContributor {
    public GmdCodeCompletionContributor() {
        final CompletionSorter customSorter2 = CompletionService.getCompletionService().emptySorter().weigh(new LookupElementWeigher(){

            @NotNull
            public Comparable<LookupElement> weigh(@NotNull LookupElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return new GmdCodeCompletionLookupElement(element);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)GmdCodeCompletionContributorKt.access$getFtlDevicePropertyPattern$p(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Project project = parameters.getPosition().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.position.project");
                if (!GmdCodeCompleteUtilsKt.isFtlPluginEnabled(project)) {
                    return;
                }
                CompletionSorter completionSorter = customSorter2;
                Intrinsics.checkNotNullExpressionValue((Object)completionSorter, (String)"customSorter");
                this.addGmdCompletions(parameters, completionSorter, ((FtlDeviceCatalogState)FtlDeviceCatalogService.Companion.getInstance().getState()).getMyDeviceCatalog(), result);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)GmdCodeCompletionContributorKt.access$getManagedVirtualDevicePropertyPattern$p(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                CompletionSorter completionSorter = customSorter2;
                Intrinsics.checkNotNullExpressionValue((Object)completionSorter, (String)"customSorter");
                this.addGmdCompletions(parameters, completionSorter, ((ManagedVirtualDeviceCatalogState)ManagedVirtualDeviceCatalogService.Companion.getInstance().getState()).getMyDeviceCatalog(), result);
            }
        });
    }

    private final DevicePropertyName getDevicePropertyName(PsiElement position) {
        DevicePropertyName devicePropertyName;
        Language language = position.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
            PsiElement psiElement;
            GrAssignmentExpression grAssignmentExpression;
            PsiElement psiElement2 = GmdCodeCompleteUtilsKt.superParent$default(position, 0, 1, null);
            Object object = psiElement2 instanceof GrAssignmentExpression ? (GrAssignmentExpression)psiElement2 : null;
            if ((object == null || (object = object.getLValue()) == null || (object = object.getText()) == null) && (object = (grAssignmentExpression = (psiElement = GmdCodeCompleteUtilsKt.superParent(position, 3)) instanceof GrAssignmentExpression ? (GrAssignmentExpression)psiElement : null) != null && (psiElement = grAssignmentExpression.getLValue()) != null ? psiElement.getText() : null) == null) {
                return null;
            }
            Object devicePropertyName2 = object;
            devicePropertyName = DevicePropertyName.Companion.fromOrNull((String)devicePropertyName2);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            PsiElement psiElement;
            KtBinaryExpression ktBinaryExpression;
            PsiElement psiElement3 = GmdCodeCompleteUtilsKt.superParent$default(position, 0, 1, null);
            Object object = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
            if ((object == null || (object = object.getLeft()) == null || (object = object.getText()) == null) && (object = (ktBinaryExpression = (psiElement = GmdCodeCompleteUtilsKt.superParent(position, 3)) instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null) != null && (psiElement = ktBinaryExpression.getLeft()) != null ? psiElement.getText() : null) == null) {
                return null;
            }
            Object devicePropertyName3 = object;
            devicePropertyName = DevicePropertyName.Companion.fromOrNull((String)devicePropertyName3);
        } else {
            GmdCodeCompletionContributorKt.access$getLOGGER().warn(position.getLanguage() + " is not supported yet for GMD code completion. Groovy and Kotlin are currently supported");
            devicePropertyName = null;
        }
        return devicePropertyName;
    }

    private final void addGmdCompletions(CompletionParameters parameters, CompletionSorter sorter, GmdDeviceCatalog deviceCatalog, CompletionResultSet result) {
        DeviceType deviceType;
        ProgressManager.checkCanceled();
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        if (GenericPsiUtils.getModule((PsiElement)psiElement) == null) {
            return;
        }
        if (deviceCatalog.isEmpty()) {
            return;
        }
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parameters.position");
        PsiElement currentPosition = psiElement2;
        DevicePropertyName devicePropertyName = this.getDevicePropertyName(currentPosition);
        GmdDeviceCatalog gmdDeviceCatalog = deviceCatalog;
        if (gmdDeviceCatalog instanceof FtlDeviceCatalog) {
            deviceType = DeviceType.FTL;
        } else if (gmdDeviceCatalog instanceof ManagedVirtualDeviceCatalog) {
            deviceType = DeviceType.MANAGED_VIRTUAL;
        } else {
            GmdCodeCompletionContributorKt.access$getLOGGER().warn(deviceCatalog.getClass() + " is not supported. It should be one of FtlDeviceCatalog or ManagedVirtualDeviceCatalog");
            return;
        }
        DeviceType deviceType2 = deviceType;
        if (devicePropertyName != null) {
            BaseLookupElementProvider lookupElementProvider = deviceType2 == DeviceType.FTL ? (BaseLookupElementProvider)FtlLookupElementProvider.INSTANCE : (BaseLookupElementProvider)ManagedVirtualLookupElementProvider.INSTANCE;
            this.addDeviceParameterSuggestion(devicePropertyName, currentPosition, deviceCatalog, sorter, lookupElementProvider, result);
        } else if (Intrinsics.areEqual((Object)currentPosition.getLanguage(), (Object)GroovyLanguage.INSTANCE)) {
            this.addDevicePropertyNameSuggestion(currentPosition, deviceType2, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addDevicePropertyNameSuggestion(PsiElement position, DeviceType deviceType, CompletionResultSet result) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        HashMap<DevicePropertyName, String> existingProperties = GmdDeviceDefinitionPatternMatchingProvider.INSTANCE.getSiblingPropertyMap(position, CurrentPsiElement.DEVICE_PROPERTY_NAME);
        Function1 filterLogic2 = (Function1)new Function1<DevicePropertyName, Boolean>(deviceType, existingProperties){
            final /* synthetic */ DeviceType $deviceType;
            final /* synthetic */ HashMap<DevicePropertyName, String> $existingProperties;
            {
                this.$deviceType = $deviceType;
                this.$existingProperties = $existingProperties;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DevicePropertyName it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return this.$deviceType == DeviceType.FTL ? !((Map)this.$existingProperties).containsKey((Object)((Object)it)) : !(((Map)this.$existingProperties).containsKey((Object)((Object)it)) || it == DevicePropertyName.API_PREVIEW && ((Map)this.$existingProperties).containsKey((Object)((Object)DevicePropertyName.API_LEVEL)) || it == DevicePropertyName.API_LEVEL && ((Map)this.$existingProperties).containsKey((Object)((Object)DevicePropertyName.API_PREVIEW)));
            }
        };
        Iterable iterable = (Iterable)deviceType.getAvailableDeviceProperties();
        CompletionResultSet completionResultSet = result.caseInsensitive();
        boolean $i$f$mapNotNull = false;
        void var8_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GmdCodeCompletionLookupElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DevicePropertyName it = (DevicePropertyName)((Object)element$iv$iv);
            boolean bl2 = false;
            if ((((Boolean)filterLogic2.invoke((Object)it)).booleanValue() ? new GmdCodeCompletionLookupElement(it.getPropertyName() + " = ", 0, null, null, 14, null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        completionResultSet.addAllElements((Iterable)((List)destination$iv$iv));
    }

    private final void addDeviceParameterSuggestion(DevicePropertyName devicePropertyName, PsiElement position, GmdDeviceCatalog deviceCatalog, CompletionSorter sorter, BaseLookupElementProvider lookupElementProvider, CompletionResultSet result) {
        CompletionResultSet completionResultSet;
        if (GmdDeviceDefinitionPatternMatchingProvider.INSTANCE.getSiblingPropertyMap(position, CurrentPsiElement.DEVICE_PROPERTY_VALUE).get((Object)devicePropertyName) != null) {
            return;
        }
        HashMap<DevicePropertyName, String> deviceProperties = GmdDeviceDefinitionPatternMatchingProvider.INSTANCE.getSiblingPropertyMap(position, CurrentPsiElement.DEVICE_PROPERTY_VALUE);
        MinAndTargetApiLevel minAndTargetApiLevel = GmdDeviceDefinitionPatternMatchingProvider.INSTANCE.getMinAndTargetSdk(ModuleExtensionsKt.getAndroidFacet((PsiElement)position));
        if (deviceProperties.get((Object)devicePropertyName) != null) {
            return;
        }
        Collection<LookupElement> suggestions = lookupElementProvider.generateDevicePropertyValueSuggestionList(devicePropertyName, deviceProperties, minAndTargetApiLevel, deviceCatalog);
        CompletionResultSet $this$addDeviceParameterSuggestion_u24lambda_u241 = completionResultSet = result.caseInsensitive();
        boolean bl = false;
        if (devicePropertyName.getNeedCustomComparable()) {
            $this$addDeviceParameterSuggestion_u24lambda_u241.withRelevanceSorter(sorter).addAllElements((Iterable)suggestions);
        } else {
            $this$addDeviceParameterSuggestion_u24lambda_u241.addAllElements((Iterable)suggestions);
        }
    }
}

