/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.test.common;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.testFramework.EqualsToFile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.test.common.RenderLogTestBase;
import org.jetbrains.uast.visitor.UastVisitor;
import org.junit.Assert;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0005H&J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\f\u0010\u000e\u001a\u00020\u0003*\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/uast/test/common/RenderLogTestBase;", "", "check", "", "testName", "", "file", "Lorg/jetbrains/uast/UFile;", "checkParentConsistency", "", "getTestDataPath", "getTestFile", "Ljava/io/File;", "ext", "checkContainingFileForAllElements", "intellij.platform.uast.tests"})
public interface RenderLogTestBase {
    @NotNull
    public String getTestDataPath();

    private File getTestFile(String testName2, String ext) {
        return new File(this.getTestDataPath(), StringsKt.substringBeforeLast$default((String)testName2, (char)'.', null, (int)2, null) + "." + ext);
    }

    default public void check(@NotNull String testName2, @NotNull UFile file2) {
        this.check(testName2, file2, true);
    }

    default public void check(@NotNull String testName2, @NotNull UFile file2, boolean checkParentConsistency2) {
        File renderFile = this.getTestFile(testName2, "render.txt");
        File logFile = this.getTestFile(testName2, "log.txt");
        EqualsToFile.assertEqualsToFile("Render string", renderFile, file2.asRenderString());
        EqualsToFile.assertEqualsToFile("Log string", logFile, UastUtils.asRecursiveLogString$default((UElement)((UElement)file2), null, (int)1, null));
        if (checkParentConsistency2) {
            this.checkParentConsistency(file2);
        }
        this.checkContainingFileForAllElements(file2);
    }

    default public void checkParentConsistency(@NotNull UFile file2) {
        Map parentMap = new LinkedHashMap();
        file2.accept(new UastVisitor(parentMap){
            @NotNull
            private final Stack<UElement> parentStack;
            final /* synthetic */ Map<PsiElement, String> $parentMap;
            {
                this.$parentMap = $parentMap;
                this.parentStack = new Stack<E>();
            }

            public boolean visitElement(@NotNull UElement node2) {
                UElement parent = node2.getUastParent();
                if (parent == null) {
                    Object object;
                    Assert.assertTrue((String)("Wrong null-parent of " + node2.getClass() + " '" + ((object = node2.getSourcePsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + "'"), (boolean)this.parentStack.empty());
                } else {
                    Object object;
                    Assert.assertEquals((String)("Wrong parent of " + node2.getClass() + " '" + ((object = node2.getSourcePsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + "'"), (Object)this.parentStack.peek(), (Object)parent);
                }
                PsiElement psiElement = node2.getSourcePsi();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    Map<PsiElement, String> map = this.$parentMap;
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    if (!map.containsKey(it)) {
                        map.put(it, CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)this.parentStack), null, null, null, (int)0, null, (Function1)checkParentConsistency.visitElement.1.1.INSTANCE, (int)31, null));
                    }
                }
                this.parentStack.push(node2);
                return false;
            }

            public void afterVisitElement(@NotNull UElement node2) {
                super.afterVisitElement(node2);
                this.parentStack.pop();
            }
        });
        file2.getSourcePsi().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(parentMap){
            final /* synthetic */ Map<PsiElement, String> $parentMap;
            {
                this.$parentMap = $parentMap;
            }

            public void visitElement(@NotNull PsiElement element) {
                UElement uElement = UastContextKt.toUElement((PsiElement)element);
                String expectedParents = this.$parentMap.get(element);
                if (expectedParents != null) {
                    Assert.assertNotNull((String)("Expected to be able to convert PSI element " + element), (Object)uElement);
                    UElement uElement2 = uElement;
                    Intrinsics.checkNotNull((Object)uElement2);
                    String parents2 = SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Object)uElement2.getUastParent(), (Function1)checkParentConsistency.visitElement.parents.1.INSTANCE), null, null, null, (int)0, null, (Function1)checkParentConsistency.visitElement.parents.2.INSTANCE, (int)31, null);
                    Assert.assertEquals((String)("Inconsistent parents for " + uElement + " (converted from " + element + ") parent: -> " + uElement.getUastParent()), (Object)expectedParents, (Object)parents2);
                }
                super.visitElement(element);
            }
        });
    }

    default public void checkContainingFileForAllElements(@NotNull UFile $this$checkContainingFileForAllElements) {
        $this$checkContainingFileForAllElements.accept(new UastVisitor($this$checkContainingFileForAllElements){
            final /* synthetic */ UFile $this_checkContainingFileForAllElements;
            {
                this.$this_checkContainingFileForAllElements = $receiver;
            }

            public boolean visitElement(@NotNull UElement node2) {
                PsiElement anchorPsi;
                UElement uastAnchor;
                PsiElement psiElement = node2.getSourcePsi();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    UFile uFile = this.$this_checkContainingFileForAllElements;
                    PsiElement sourcePsi = psiElement2;
                    boolean bl = false;
                    UElement uElement = UastContextKt.toUElement((PsiElement)sourcePsi);
                    Intrinsics.checkNotNull((Object)uElement);
                    UElement uElement2 = uElement;
                    Assert.assertEquals((String)("getContainingUFile should be equal to source for " + uElement2.getClass() + " for " + sourcePsi.getText()), (Object)uFile, (Object)UastUtils.getContainingUFile((UElement)uElement2));
                }
                Lazy nodeContainingFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiFile>(node2){
                    final /* synthetic */ UElement $node;
                    {
                        this.$node = $node;
                        super(0);
                    }

                    @NotNull
                    public final PsiFile invoke() {
                        PsiElement psiElement;
                        block3: {
                            for (UElement it : UElementKt.getWithContainingElements((UElement)this.$node)) {
                                boolean bl = false;
                                psiElement = it.getSourcePsi();
                                if (psiElement == null) {
                                    continue;
                                }
                                break block3;
                            }
                            psiElement = null;
                        }
                        if (psiElement == null) {
                            throw new NoSuchElementException("No element of the sequence was transformed to a non-null value.");
                        }
                        PsiFile psiFile = psiElement.getContainingFile();
                        Intrinsics.checkNotNull((Object)psiFile);
                        return psiFile;
                    }
                }));
                UDeclaration uDeclaration = node2 instanceof UDeclaration ? (UDeclaration)node2 : null;
                Object object = uastAnchor = uDeclaration != null ? uDeclaration.getUastAnchor() : null;
                if (uastAnchor != null) {
                    PsiElement psiElement3 = node2.getSourcePsi();
                    PsiElement psiElement4 = uastAnchor.getSourcePsi();
                    Assert.assertEquals((String)("should be appropriate sourcePsi for uastAnchor for " + node2.getClass() + " [" + (psiElement3 != null ? psiElement3.getText() : null) + "] "), (Object)checkContainingFileForAllElements.1.visitElement$lambda$1((Lazy<? extends PsiFile>)nodeContainingFile$delegate), (Object)(psiElement4 != null ? psiElement4.getContainingFile() : null));
                }
                UElement uElement = uastAnchor;
                Object object2 = anchorPsi = uElement != null ? uElement.getSourcePsi() : null;
                if (anchorPsi != null) {
                    Assert.assertEquals((Object)anchorPsi.getContainingFile(), (Object)checkContainingFileForAllElements.1.visitElement$lambda$1((Lazy<? extends PsiFile>)nodeContainingFile$delegate));
                }
                return false;
            }

            private static final PsiFile visitElement$lambda$1(Lazy<? extends PsiFile> $nodeContainingFile$delegate) {
                Lazy<? extends PsiFile> lazy = $nodeContainingFile$delegate;
                return (PsiFile)lazy.getValue();
            }
        });
    }
}

