/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class OCHighlightUsagesCase
extends OCCodeInsightTestCase {
    private static final String REF = "s";

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
    }

    protected void assertUsagesCpp(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.CPP, false, true);
    }

    protected void noUsagesCpp(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.CPP, true, true);
    }

    protected void assertUsagesC(@NotNull String text) {
        this.assertUsages(text, (OCLanguageKind)CLanguageKind.C, false, true);
    }

    protected void assertUsages(@NotNull String text, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations) {
        this.assertUsages(text, languageKind, checkNothingToFindAtCursor, withDeclarations, false);
    }

    protected void assertUsages(@NotNull String text, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations, boolean withRefMerge) {
        OCFile file2 = this.configureByText(text.replaceAll("<s>", "").replace("</s>", ""), languageKind);
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)TargetElementUtil.getInstance().getReferenceSearchFlags());
        if (targetElement == null && checkNothingToFindAtCursor) {
            return;
        }
        OCHighlightUsagesCase.assertNotNull((String)"Nothing to find at cursor", (Object)targetElement);
        AbstractCollection allUsages = new ArrayList();
        IdentifierHighlighterPass.getHighlightUsages((PsiElement)targetElement, (PsiElement)file2, (boolean)withDeclarations, allUsages, allUsages);
        if (withRefMerge) {
            allUsages = new HashSet(allUsages);
        }
        OCHighlightUsagesCase.assertEquals((String)text.replace("<caret>", ""), (String)CodeInsightTestFixtureImpl.getTagsFromSegments(file2.getText(), allUsages, REF, null));
    }
}

