/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFindUsagesTestCase
extends OCCodeInsightTestCase {
    Map<String, FindUsageCase> myUsageCases;

    public OCFindUsagesTestCase(String relativeProjectPath) {
        super(relativeProjectPath);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myUsageCases = this.readTestData();
    }

    protected void doTestFindUsages() {
        this.doTestFindUsages(null);
    }

    protected void doTestFindUsages(@Nullable SearchScope scope) {
        FindUsageCase aCase = this.getUsageCases();
        Collection<Usage> usages = aCase.usages;
        String expected = OCFindUsagesTestCase.getExpectedUsages(usages);
        for (Usage usage : usages) {
            if (usage.type == Usage.Type.SINK) continue;
            this.myCodeInsightFixture.getFixture().openFileInEditor(usage.file);
            this.getEditor().getCaretModel().moveToLogicalPosition(new LogicalPosition(usage.line, usage.column));
            this.myCodeInsightFixture.checkFindUsages(expected, usage.toString(), scope);
            this.myCodeInsightFixture.checkFindUsagesOnNonDispatchThread(expected, usage.toString(), scope);
        }
    }

    protected void doTestFindUsagesKeyword() {
        for (FindUsageCase usageCase : this.myUsageCases.values()) {
            for (Usage usage : usageCase.usages) {
                if (usage.type != Usage.Type.NONE) continue;
                this.myCodeInsightFixture.getFixture().openFileInEditor(usage.file);
                LogicalPosition pos = new LogicalPosition(usage.line, usage.column);
                this.getEditor().getCaretModel().moveToLogicalPosition(pos);
                PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)TargetElementUtil.getInstance().getReferenceSearchFlags());
                OCFindUsagesTestCase.assertNull((String)("find usages for keyword is incorrect: " + usage), (Object)targetElement);
            }
        }
    }

    private FindUsageCase getUsageCases() {
        String name = this.getTestName(true);
        FindUsageCase aCase = this.myUsageCases.get(name);
        OCFindUsagesTestCase.assertNotNull((String)("can't find data for " + name), (Object)aCase);
        Collection<Usage> usages = aCase.usages;
        Usage oneDirectionRef = (Usage)ContainerUtil.find(usages, usage -> usage.type == Usage.Type.SOURCE);
        if (oneDirectionRef != null) {
            Usage validUsage = (Usage)ContainerUtil.find(usages, usage -> usage.type != Usage.Type.SOURCE);
            OCFindUsagesTestCase.assertNotNull((String)("not a single usage is found for " + name), (Object)validUsage);
        }
        return aCase;
    }

    private static String getExpectedUsages(Collection<Usage> usages) {
        List strings = ContainerUtil.skipNulls((Collection)ContainerUtil.map(usages, usage -> usage.type == Usage.Type.SOURCE ? null : usage.toString()));
        Collections.sort(strings);
        return StringUtil.join((Collection)strings, (String)"\n");
    }

    private HashMap<String, FindUsageCase> readTestData() {
        MultiMap<String, Usage> usageMap = new MultiMap<String, Usage>(){

            @NotNull
            protected Collection<Usage> createCollection() {
                return new HashSet<Usage>();
            }
        };
        VfsUtilCore.processFilesRecursively((VirtualFile)((OCMockProjectFixture)this.myProjectFixture).getProjectDir(), arg_0 -> OCFindUsagesTestCase.lambda$readTestData$3((MultiMap)usageMap, arg_0));
        HashMap<String, FindUsageCase> cases = new HashMap<String, FindUsageCase>();
        for (Map.Entry entry : usageMap.entrySet()) {
            String testName2 = (String)entry.getKey();
            Collection usages = (Collection)entry.getValue();
            cases.put(testName2, new FindUsageCase(usages));
        }
        return cases;
    }

    private static /* synthetic */ boolean lambda$readTestData$3(MultiMap usageMap, VirtualFile file2) {
        if (file2.isDirectory()) {
            return true;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        Matcher m = Pattern.compile("/\\*([\\?!@])?([\\w ]+)\\*/").matcher(doc.getText());
        while (m.find()) {
            String modifiers = m.group(1);
            String testName2 = m.group(2);
            int offset = m.end();
            int lineNumber = doc.getLineNumber(offset);
            int column = offset - doc.getLineStartOffset(lineNumber);
            Usage.Type type = Usage.Type.DEFAULT;
            if (modifiers != null) {
                if (modifiers.contains("!")) {
                    type = Usage.Type.SOURCE;
                } else if (modifiers.contains("?")) {
                    type = Usage.Type.SINK;
                } else if (modifiers.contains("@")) {
                    type = Usage.Type.NONE;
                }
            }
            for (String t : testName2.split(" ")) {
                usageMap.putValue((Object)t, (Object)new Usage(type, file2, lineNumber, column));
            }
        }
        return true;
    }

    private static class FindUsageCase {
        final Collection<Usage> usages;

        FindUsageCase(Collection<Usage> usages) {
            this.usages = usages;
        }
    }

    private static class Usage {
        final Type type;
        final VirtualFile file;
        final int line;
        final int column;

        Usage(Type type, VirtualFile file2, int line, int column) {
            this.type = type;
            this.file = file2;
            this.line = line;
            this.column = column;
        }

        public String toString() {
            return this.file.getName() + ":" + (this.line + 1) + ":" + (this.column + 1);
        }

        public static enum Type {
            DEFAULT,
            SOURCE,
            SINK,
            NONE;

        }
    }
}

