/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectReader;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import java.io.File;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class OCMockProjectDescriptor
extends LightProjectDescriptor {
    @NotNull
    private final VirtualFile myProjectFile;
    private final OpenProjectTask openProjectOptions;

    public OCMockProjectDescriptor(@NotNull VirtualFile projectFile, @NotNull OpenProjectTask openProjectOptions) {
        this.myProjectFile = projectFile;
        this.openProjectOptions = openProjectOptions;
    }

    @Override
    @NotNull
    public OpenProjectTask getOpenProjectOptions() {
        return this.openProjectOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static OCMockWorkspace createAndRegisterMockWorkspace(@NotNull OCWorkspaceImpl workspace, @NotNull String clientKey, @NotNull VirtualFile projectFile) {
        boolean isProjectFile = FileUtilRt.extensionEquals((String)projectFile.getName(), (String)"yaml");
        VirtualFile projectDir = isProjectFile ? projectFile.getParent() : projectFile;
        OCMockWorkspace mockWorkspace = new OCMockWorkspace(workspace, clientKey, projectDir);
        OCMockProjectDescriptor.registerWorkspaceProvider(mockWorkspace);
        if (isProjectFile) {
            OCMockProjectReader.read(new File(projectFile.getPath()), mockWorkspace);
        } else {
            OCWorkspace.ModifiableModel model = workspace.getModifiableModel(clientKey);
            try {
                OCResolveConfiguration.ModifiableModel configModel = model.addConfiguration("default", "default");
                for (CLanguageKind eachLang : CLanguageKind.values()) {
                    OCMockWorkspace.applyDefaultDefinesAndFeatures((OCLanguageKind)eachLang, configModel.getLanguageCompilerSettings((OCLanguageKind)eachLang));
                }
                model.preCommit();
                WriteAction.run(() -> ((OCWorkspace.ModifiableModel)model).commit());
            }
            finally {
                model.dispose();
            }
        }
        return mockWorkspace;
    }

    private static void registerWorkspaceProvider(@NotNull CidrWorkspace workspace) {
        CidrWorkspaceProvider.EP_NAME.getPoint().registerExtension(p -> p == workspace.getProject() ? workspace : null, (Disposable)workspace.getProject());
    }

    @Override
    public void setUpProject(@NotNull Project project2, @NotNull LightProjectDescriptor.SetupHandler handler) throws Exception {
        super.setUpProject(project2, handler);
        OCWorkspaceImpl workspace = new OCWorkspaceImpl(project2, false);
        OCMockWorkspace mockWorkspace = OCMockProjectDescriptor.createAndRegisterMockWorkspace(workspace, "Legacy", this.myProjectFile);
        ServiceContainerUtil.registerComponentImplementation((ComponentManager)project2, OCWorkspace.class, OCWorkspaceImpl.class);
        ServiceContainerUtil.registerComponentInstance((ComponentManager)project2, OCWorkspace.class, workspace);
        Assert.assertSame((Object)workspace, (Object)OCWorkspace.getInstance((Project)project2));
        ModuleType defaultModuleType = ModuleTypeManager.getInstance().getDefaultModuleType();
        Module module2 = (Module)ArraysKt.single((Object[])ModuleManager.getInstance((Project)project2).getModules());
        module2.setModuleType(defaultModuleType.getId());
        mockWorkspace.initialized();
    }

    @Override
    @Nullable
    public VirtualFile createDirForSources(@NotNull Module module2) {
        return null;
    }

    @Nullable
    public static OCMockWorkspace getMockWorkspace(@NotNull Project project2) {
        return (OCMockWorkspace)((Object)ContainerUtil.findInstance((Iterable)CidrWorkspace.getWorkspaces((Project)project2), OCMockWorkspace.class));
    }
}

