/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.concurrency.JobScheduler;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.annotations.SupportsDumbMode;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.CidrAnnotationFixture;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.daemon.QuickFixResult;
import com.jetbrains.cidr.lang.modulemap.ModuleMapFixture;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCSafeDeleteProcessorDelegateBase;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCodeInsightTestCaseBase<PROJECT_FIXTURE extends CidrProjectFixture<?>, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CODE_INSIGHT_FIXTURE> {
    protected static final String FND = "#import \"foundation.h\"\n";
    @Nullable
    private final CidrTestProjectDescription myTestProjectDescription;
    protected String myTestFilesPath;
    protected String myTestFilesExtension;
    protected CidrAnnotationFixture myAnnotationFixture;
    protected ModuleMapFixture myModuleMapFixture;
    private boolean myRunInDumbMode = false;

    public OCCodeInsightTestCaseBase() {
        this("empty");
    }

    public OCCodeInsightTestCaseBase(@NlsSafe @Nullable String relativeProjectPath) {
        this(relativeProjectPath == null ? null : new CidrTestProjectDescription(relativeProjectPath));
    }

    public OCCodeInsightTestCaseBase(@Nullable CidrTestProjectDescription testProjectDescription) {
        this.myTestProjectDescription = testProjectDescription;
    }

    public OCCodeInsightTestCaseBase(@NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        this("empty", testFilesPath, testFilesExtension);
    }

    public OCCodeInsightTestCaseBase(@NlsSafe @Nullable String projectRelativePath, @NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        this(projectRelativePath);
        this.myTestFilesExtension = testFilesExtension;
        this.myTestFilesPath = this.getLangTestDataPath() + "/" + testFilesPath;
    }

    public String getLangTestDataPath() {
        return CidrTestDataFixture.getLangTestData().getPath();
    }

    protected void initExtensions() {
        SafeDeleteProcessorDelegate[] extensions = (SafeDeleteProcessorDelegate[])Extensions.getRootArea().getExtensionPoint(SafeDeleteProcessorDelegate.EP_NAME).getExtensions();
        if (ContainerUtil.findInstance(Arrays.asList(extensions), OCSafeDeleteProcessorDelegateBase.class) == null) {
            SafeDeleteProcessorDelegate.EP_NAME.getPoint().registerExtension((Object)new OCSafeDeleteProcessorDelegateBase(){}, this.getTestRootDisposable());
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initExtensions();
        if (this.myTestProjectDescription != null) {
            this.myProjectFixture.initProject(this.myTestProjectDescription);
            this.setUpDumbMode();
        }
        RegistryValue regVar = Registry.get((String)"cidr.indent.lexer.only.objc");
        boolean oldValue = regVar.asBoolean();
        regVar.setValue(true);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> regVar.setValue(oldValue));
    }

    protected final void setUpDumbMode() {
        if (this.myRunInDumbMode) {
            ((DumbServiceImpl)DumbService.getInstance((Project)this.getProject())).setDumb(true);
        }
    }

    @Override
    protected boolean shouldRunTest() {
        return super.shouldRunTest() && this.processAnnotations();
    }

    protected boolean processAnnotations() {
        try {
            Class<?> c = this.getClass();
            Method m = c.getMethod(this.getName(), new Class[0]);
            return Stream.concat(Arrays.stream(c.getAnnotations()), Arrays.stream(m.getAnnotations())).allMatch(a -> this.processAnnotation((Annotation)a));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
    }

    protected boolean processAnnotation(Annotation a) {
        if (a.annotationType() == SupportsDumbMode.class) {
            this.myRunInDumbMode = new Random().nextBoolean();
        }
        return true;
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        if (this.myCodeInsightFixture != null) {
            this.myAnnotationFixture = new CidrAnnotationFixture(this.myProjectFixture, this.myCodeInsightFixture, this.getName());
            this.myAnnotationFixture.setUp();
        }
        this.myModuleMapFixture = new ModuleMapFixture(this.myTestDataFixture, this.myProjectFixture, this.myCodeInsightFixture);
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getLangTestData());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myTestProjectDescription != null && this.myProjectFixture.isProjectOpened()) {
                OCLegacyAnnotator.stopEnabling((Project)this.getProject());
            }
            if (this.myAnnotationFixture != null) {
                this.myAnnotationFixture.tearDown();
            }
            if (this.myRunInDumbMode) {
                OCCodeInsightTestCaseBase.assertTrue((String)"Dumb mode wasn't set up properly. Check `setUpDumbMode()` is called after project is initialized", (boolean)DumbService.getInstance((Project)this.getProject()).isDumb());
                this.myRunInDumbMode = false;
                ((DumbServiceImpl)DumbService.getInstance((Project)this.getProject())).setDumb(false);
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    public OCResolveConfiguration getDefaultConfiguration() {
        return this.myProjectFixture.getFirstResolveConfiguration();
    }

    protected CodeStyleSettings getCodeStyleSettings() {
        return this.myCodeInsightFixture.getCodeStyleSettings();
    }

    protected CommonCodeStyleSettings getCommonSettings() {
        return this.myCodeInsightFixture.getOCCommonSettings();
    }

    protected OCCodeStyleSettings getOCSettings() {
        return this.myCodeInsightFixture.getOCSettings();
    }

    protected OCFile configureByText(String text, OCLanguageKind languageKind) {
        return this.myCodeInsightFixture.configureByText(text, languageKind);
    }

    protected OCFile configureByTextOC(String text) {
        return this.myCodeInsightFixture.configureByTextOC(text);
    }

    protected OCFile configureByTextC(String text) {
        return this.myCodeInsightFixture.configureByTextC(text);
    }

    protected OCFile configureByTextOCpp(String text) {
        return this.myCodeInsightFixture.configureByTextOCpp(text);
    }

    protected OCFile configureByTextCpp(String text) {
        return this.myCodeInsightFixture.configureByTextCpp(text);
    }

    protected OCType parseTypeCPP(String type) {
        return this.myCodeInsightFixture.parseTypeCpp(type);
    }

    protected OCType parseTypeObjC(String type) {
        return this.myCodeInsightFixture.parseTypeObjC(type);
    }

    protected OCType parseDeclTypeCPP(CharSequence text) {
        return this.myCodeInsightFixture.parseDeclTypeCpp(text);
    }

    protected void checkResult(@NotNull String text) {
        this.myCodeInsightFixture.checkResult(text);
    }

    protected void checkResultWithoutFormatting(String text) {
        this.myCodeInsightFixture.checkResultWithoutFormatting(text);
    }

    @NotNull
    protected PsiElement findElementAtCaret(OCFile file2) {
        return this.myCodeInsightFixture.findElementAtCaret((PsiFile)file2);
    }

    @NotNull
    protected <T extends PsiElement> T findNodeAtSelection(OCFile file2, Class<T> nodeClass) {
        return this.myCodeInsightFixture.findNodeAtSelection((PsiFile)file2, nodeClass);
    }

    @NotNull
    protected OCExpression findExpressionAtSelection(OCFile file2) {
        return this.myCodeInsightFixture.findExpressionAtSelection(file2);
    }

    protected Editor getEditor() {
        return this.myCodeInsightFixture.getEditor();
    }

    protected PsiFile getFile() {
        return this.myCodeInsightFixture.getFile();
    }

    protected OCFile getOCFile() {
        return this.myCodeInsightFixture.getOCFile();
    }

    protected int getCaretOffset() {
        return this.myCodeInsightFixture.getCaretOffset();
    }

    protected TextRange getSelection() {
        return this.myCodeInsightFixture.getSelection();
    }

    protected void doCheckAnnotations() throws Exception {
        this.myCodeInsightFixture.checkAnnotations(this.getTestName(false));
    }

    protected <T extends PsiElement> T findNode(String check, Class<T> nodeType) {
        return this.myAnnotationFixture.findNode(check, nodeType);
    }

    protected <T extends PsiElement> void assertErrorOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOC(check, nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorOC(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOC(check, nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorLocalOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOC(this.getLocalProgramText(check), nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorLocalOC(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOC(this.getLocalProgramText(check), nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected String getLocalProgramText(String check) {
        if (!((String)check).contains("<selection>")) {
            check = "<selection>" + (String)check + "</selection>";
        }
        return "#import \"foundation.h\"\nvoid fun() {" + (String)check + "}";
    }

    protected <T extends PsiElement> void assertErrorOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOCpp(check, nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorOCpp(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOCpp(check, nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorOCpp(String check, Class<T> nodeType, String message, boolean isRegexp, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertError(check, nodeType, message, isRegexp, (OCLanguageKind)CLanguageKind.OBJ_CPP, quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorLocalOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertErrorOCpp(this.getLocalProgramText(check), nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertErrorLocal(String check, Class<T> nodeType, OCLanguageKind languageKind, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertError(this.getLocalProgramText(check), nodeType, message, false, languageKind, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOC(check, nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningOC(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOC(check, nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningLocalOC(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOC(this.getLocalProgramText(check), nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningLocalOC(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOC(this.getLocalProgramText(check), nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOCpp(check, nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningOCpp(String check, Class<T> nodeType, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOCpp(check, nodeType, "__ANY_MESSAGE", quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningLocalOCpp(String check, Class<T> nodeType, String message, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOCpp(this.getLocalProgramText(check), nodeType, message, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarning(String check, Class<T> nodeType, String message, boolean isRegexp, OCLanguageKind languageKind, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarning(check, nodeType, message, isRegexp, languageKind, quickFixResults);
    }

    protected <T extends PsiElement> void assertError(String check, Class<T> nodeType, String message, boolean isRegexp, OCLanguageKind languageKind, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertError(check, nodeType, message, isRegexp, languageKind, quickFixResults);
    }

    protected <T extends PsiElement> void assertWarningOrErrorOC(String check, Class<T> nodeType, String message, boolean isRegexp, QuickFixResult ... quickFixResults) throws Exception {
        this.myAnnotationFixture.assertWarningOrErrorOC(check, nodeType, message, isRegexp, quickFixResults);
    }

    protected <T extends PsiElement> void assertSelectionOC(String check, Class<T> nodeType) {
        this.myAnnotationFixture.assertSelectionOC(check, nodeType);
    }

    protected <T extends PsiElement> void assertLocalSelectionOC(String check, Class<T> nodeType) {
        this.myAnnotationFixture.assertSelectionOC(this.getLocalProgramText(check), nodeType);
    }

    protected <T extends PsiElement> void assertOKOC(String check, Class<T> nodeType) throws Exception {
        this.myAnnotationFixture.assertOKOC(check, nodeType);
    }

    protected <T extends PsiElement> void assertOKLocalOC(String check, Class<T> nodeType) throws Exception {
        this.myAnnotationFixture.assertOKOC(this.getLocalProgramText(check), nodeType);
    }

    protected <T extends PsiElement> void assertOKOCpp(String check, Class<T> nodeType) throws Exception {
        this.myAnnotationFixture.assertOKOCpp(check, nodeType);
    }

    protected <T extends PsiElement> void assertOKLocalOCpp(String check, Class<T> nodeType) throws Exception {
        this.myAnnotationFixture.assertOKOCpp(this.getLocalProgramText(check), nodeType);
    }

    protected <T extends PsiElement> void assertOKLocal(String check, Class<T> nodeType, OCLanguageKind languageKind) throws Exception {
        this.myAnnotationFixture.assertOK(this.getLocalProgramText(check), nodeType, languageKind);
    }

    protected <T extends PsiElement> void assertOK(String check, Class<T> nodeType, OCLanguageKind languageKind) throws Exception {
        this.myAnnotationFixture.assertOK(check, nodeType, languageKind);
    }

    protected <T extends PsiElement> void assertRefactoringOC(String check, RefactoringActionHandler actionHandler, String result2) {
        this.myAnnotationFixture.assertRefactoringOC(check, actionHandler, result2);
    }

    protected <T extends PsiElement> void assertRefactoringOCpp(String check, RefactoringActionHandler actionHandler, String result2) {
        this.myAnnotationFixture.assertRefactoringOCpp(check, actionHandler, result2);
    }

    protected <T extends PsiElement> void assertRefactoringCUDA(String check, RefactoringActionHandler actionHandler, String result2) {
        this.myAnnotationFixture.assertRefactoringCUDA(check, actionHandler, result2);
    }

    protected <T extends PsiElement> void assertIntentionOC(String check, IntentionAction actionHandler, String result2) {
        this.myAnnotationFixture.assertIntentionOC(check, actionHandler, result2);
    }

    protected <T extends PsiElement> void assertIntentionOCpp(String check, IntentionAction actionHandler, String result2) {
        this.myAnnotationFixture.assertIntentionOCpp(check, actionHandler, result2);
    }

    protected void assertPreview(@NotNull String programText, @NotNull IntentionAction action, @NotNull String expectedPreviewResult, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertPreview(programText, action, expectedPreviewResult, languageKind);
    }

    protected <T extends PsiElement> void assertIntention(String check, IntentionAction actionHandler, String result2, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertAction(check, this.myAnnotationFixture.getActionFromIntention(actionHandler), result2, languageKind);
    }

    protected <T extends PsiElement> void assertIntentionNotAvailableOC(String check, IntentionAction actionHandler) {
        this.myAnnotationFixture.assertIntentionNotAvailableOC(check, actionHandler);
    }

    protected <T extends PsiElement> void assertIntentionNotAvailableOCpp(String check, IntentionAction actionHandler) {
        this.myAnnotationFixture.assertIntentionNotAvailableOCpp(check, actionHandler);
    }

    protected <T extends PsiElement> void assertActionNotAvailableOC(String check, LanguageCodeInsightActionHandler actionHandler) {
        this.myAnnotationFixture.assertActionNotAvailable(check, actionHandler, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    protected <T extends PsiElement> void assertActionNotAvailable(String check, IntentionAction actionHandler, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertActionNotAvailable(check, this.myAnnotationFixture.getActionFromIntention(actionHandler), languageKind);
    }

    protected <T extends PsiElement> void assertActionOC(String check, LanguageCodeInsightActionHandler actionHandler, String result2) {
        this.myAnnotationFixture.assertActionOC(check, actionHandler, result2);
    }

    protected <T extends PsiElement> void assertActionOCpp(String check, LanguageCodeInsightActionHandler actionHandler, String result2) {
        this.myAnnotationFixture.assertActionOCpp(check, actionHandler, result2);
    }

    protected void doTestWithTimeout(long timeOut) {
        this.runWithTimeout(timeOut, () -> {
            try {
                this.doCheckAnnotations();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    protected void runWithTimeout(long timeOut, Runnable testRunnable) {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        JobScheduler.getScheduler().schedule(() -> ((ProgressIndicator)indicator).cancel(), timeOut, TimeUnit.MILLISECONDS);
        ProgressManager.getInstance().runProcess(testRunnable, (ProgressIndicator)indicator);
    }

    protected void doTypingTestExpression(String expressionBefore, char symbol, String expressionAfter, CLanguageKind languageKind) {
        this.doTypingTest(OCCodeInsightTestCaseBase.fileTextByExpression(expressionBefore), symbol, OCCodeInsightTestCaseBase.fileTextByExpression(expressionAfter), languageKind);
    }

    protected void doTypingTestObjCpp(String fileBefore, char symbol, String fileAfter) {
        this.doTypingTest(fileBefore, symbol, fileAfter, CLanguageKind.OBJ_CPP);
    }

    protected void doTypingTest(@NotNull String fileBefore, char symbol, @NotNull String fileAfter, @NotNull CLanguageKind languageKind) {
        this.doActionTest(fileBefore, fileAfter, languageKind, () -> this.myCodeInsightFixture.getFixture().type(symbol));
    }

    protected void doActionTest(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull CLanguageKind languageKind, @NotNull Runnable run) {
        this.myCodeInsightFixture.configureByText(fileBefore, (OCLanguageKind)languageKind);
        run.run();
        this.myCodeInsightFixture.checkResult(fileAfter);
    }

    @NotNull
    protected static String fileTextByExpression(String expressionBefore) {
        return "void testFun() {\n    " + expressionBefore + ";\n}";
    }

    protected <T extends PsiElement> T findElement(String text, Class<T> elementClass, OCLanguageKind languageKind) {
        OCFile file2 = this.myCodeInsightFixture.configureByText(text, languageKind);
        OCExpression expression = this.myCodeInsightFixture.findExpressionAtSelection(file2);
        return (T)((PsiElement)OCCodeInsightTestCaseBase.assertInstanceOf(expression, elementClass));
    }

    protected OCFile configureByExpressionTextOCpp(String text) {
        return this.myCodeInsightFixture.configureByExpressionOCpp(text);
    }

    protected OCFile configureByExpressionTextOC(String text) {
        return this.myCodeInsightFixture.configureByExpressionOC(text);
    }

    protected void assertAction(String @NotNull [] extensions, LanguageCodeInsightActionHandler handler) throws Exception {
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myCodeInsightFixture.getProject());
        ArrayList<SmartPsiElementPointer<OCFile>> sourceFiles = new ArrayList<SmartPsiElementPointer<OCFile>>();
        ArrayList<String> resultFileNames = new ArrayList<String>();
        for (int i2 = extensions.length - 1; i2 >= 0; --i2) {
            String extension = extensions[i2];
            sourceFiles.add(0, (SmartPsiElementPointer<OCFile>)pointerManager.createSmartPsiElementPointer((PsiElement)this.myCodeInsightFixture.configureByFile(this.getTestName(false), "source" + extension)));
            resultFileNames.add(0, "result" + extension);
        }
        this.myAnnotationFixture.assertAction(sourceFiles, resultFileNames, handler);
    }

    protected void enableStatusBarWidgetsForTest() {
        Project project2 = this.getProject();
        StatusBar bar = WindowManager.getInstance().getStatusBar(project2);
        for (StatusBarWidgetProvider widgetProvider : StatusBarWidgetProvider.EP_NAME.getExtensionList()) {
            StatusBarWidget widget = widgetProvider.getWidget(project2);
            if (widget == null) continue;
            bar.addWidget(widget, widgetProvider.getAnchor(), this.getTestRootDisposable());
        }
    }
}

