/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editing;

import com.intellij.psi.PsiElement;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CidrFileBasedChangeTestFixture;
import com.jetbrains.cidr.lang.OCFileBasedResultTestCase;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import java.io.File;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public abstract class OCTypingTestCase
extends OCFileBasedResultTestCase {
    protected CidrFormattingFixture myFormattingFixture;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFormattingFixture.setUp();
        this.getOCSettings().INDENT_NAMESPACE_MEMBERS = 4;
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture(this.myCodeInsightFixture);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFormattingFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    public OCTypingTestCase(OCLanguageKind languageKind, String dataDir) {
        super(dataDir, languageKind);
    }

    @Override
    public String getLangTestDataPath() {
        return new File(super.getLangTestDataPath(), "complete_statement_and_typing/result/").getPath();
    }

    protected String getAssertionBlockPrefix() {
        return "///";
    }

    @Override
    protected CidrFileBasedChangeTestFixture createTestFixture() {
        return new CidrFileBasedChangeTestFixture<String>(this.myCodeInsightFixture, this.myProjectFixture, this.getAssertionBlockPrefix()){

            @Override
            protected void performInWriteAction(CodeInsightTestFixture fixture, String data, String errorPrefix) {
                if (data.equals("<COMPLETE_STATEMENT>")) {
                    fixture.performEditorAction("EditorCompleteStatement");
                } else if (data.equals("<TYPE_ENTER>")) {
                    fixture.type('\n');
                } else if (data.equals("<TYPE_LBRACE>")) {
                    fixture.type('{');
                } else if (data.equals("<TYPE_COLON>")) {
                    fixture.type(':');
                } else if (data.equals("<TYPE_AT>")) {
                    fixture.type('@');
                } else if (data.equals("<TYPE_APO>")) {
                    fixture.type('\'');
                } else if (data.equals("<TYPE_QUOTE>")) {
                    fixture.type('\"');
                } else if (data.equals("<TYPE_HASH>")) {
                    fixture.type('#');
                } else if (data.equals("<TYPE_BACKSPACE>")) {
                    fixture.performEditorAction("EditorBackSpace");
                } else {
                    TestCase.fail((String)"Unknown action");
                }
            }

            @Override
            @NotNull
            protected String readAssertionData(String assertionContents) {
                return assertionContents.trim();
            }
        };
    }

    protected void assertFormatAfterEnter(String before, String after2) throws Exception {
        this.assertFormatAfterTyping("\n", before, after2);
    }

    protected void assertFormatAfterEnterCPP(String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("cpp", "\n", before, after2);
    }

    protected void assertFormatAfterTyping(String typed, String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("m", typed, before, after2);
    }

    protected void assertFormatAfterTypingCPP(String typed, String before, String after2) throws Exception {
        this.assertFormatAfterTypingEx("cpp", typed, before, after2);
    }

    public void assertFormatAfterTypingEx(String fileExtWithoutDot, String typed, String before, String after2) throws Exception {
        this.myCodeInsightFixture.configureByText(before, "test." + fileExtWithoutDot);
        this.myCodeInsightFixture.getFixture().type(typed);
        try {
            this.myCodeInsightFixture.checkResult(after2);
        }
        catch (Throwable e) {
            try {
                OCTypingTestCase.printPsiStructure((PsiElement)this.getFile());
            }
            catch (Throwable suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e instanceof Exception ? (Exception)e : new RuntimeException(e);
        }
    }

    public static void execIndentProcessorAsInApplication(@NotNull ThrowableRunnable<Exception> doit) throws Exception {
        boolean canUseFormatterForIndent = OCLineIndentProvider.setCanUseFormatterForIndent((boolean)true);
        try {
            doit.run();
        }
        finally {
            OCLineIndentProvider.setCanUseFormatterForIndent((boolean)canUseFormatterForIndent);
        }
    }
}

