/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.codeinsight;

import com.intellij.ide.DataManager;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import java.awt.Component;
import junit.framework.TestCase;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class CidrScratchTestUtils {
    public static void assertScratchIsSource(@NotNull FileType type, @NotNull CodeInsightTestFixture fixture) {
        Project project2 = fixture.getProject();
        PsiFile file2 = fixture.configureByText("foo." + type.getDefaultExtension(), " ");
        TestCase.assertTrue((boolean)FileSymbolTableHelper.isSourceFile((PsiFile)file2));
        Editor editor = fixture.getEditor();
        editor.getSelectionModel().setSelection(0, editor.getDocument().getTextLength());
        AnAction action = ActionManager.getInstance().getAction("NewScratchFile");
        DataContext context2 = DataManager.getInstance().getDataContext((Component)editor.getComponent());
        action.actionPerformed(AnActionEvent.createFromDataContext((String)"EditorTab", null, (DataContext)context2));
        VirtualFile scratchFile = StreamEx.of((Object[])FileEditorManager.getInstance((Project)project2).getAllEditors()).map(e -> e.getFile()).findFirst(ScratchUtil::isScratch).orElse(null);
        TestCase.assertNotNull((Object)scratchFile);
        TestCase.assertTrue((boolean)FileSymbolTableHelper.isSourceFile((VirtualFile)scratchFile, (Project)project2));
    }
}

