/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.util.Key;
import com.intellij.testFramework.UsefulTestCase;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ProcessOutputListener
extends ProcessAdapter {
    final StringBuilder allOutput = new StringBuilder();
    final Map<Key, StringBuilder> output = new HashMap<Key, StringBuilder>();

    public synchronized void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key type) {
        this.allOutput.append(event.getText());
        StringBuilder buffer = this.output.get(type);
        if (buffer == null) {
            buffer = new StringBuilder();
            this.output.put(type, buffer);
        }
        buffer.append(event.getText());
    }

    public synchronized void assertTypes(Key ... types) {
        UsefulTestCase.assertSameElements(this.output.keySet(), types);
    }

    public synchronized void assertOutput(Key type, @Nullable String expected) {
        StringBuilder output = this.output.get(type);
        Assert.assertEquals((Object)expected, (Object)(output == null ? null : output.toString()));
    }

    public synchronized void assertOutputMatches(Key type, @NotNull String expectedPattern) {
        StringBuilder output = this.output.get(type);
        Assert.assertNotNull((Object)output);
        String string = output.toString();
        Assert.assertTrue((String)("Text: " + string + "\nDoesn't match pattern: " + expectedPattern), (boolean)Pattern.compile(expectedPattern, 32).matcher(string).matches());
    }

    public synchronized String getAllOutput() {
        return this.allOutput.toString();
    }
}

