/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrPathConsoleFilter;
import com.jetbrains.cidr.execution.TestHyperlinkInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.assertj.core.api.SoftAssertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public abstract class CidrPathConsoleFilterTestCase
extends CidrTestCase<OCMockProjectFixture, CidrExecutionFixture<OCMockProjectFixture>, CidrDebuggingFixture<CidrExecutionFixture<OCMockProjectFixture>>, CidrCodeInsightFixture> {
    private static final char NO_END_MARKER = '\u0000';
    @Language(value="RegExp")
    @NotNull
    private static final String FILE_GROUP = "file";
    @Language(value="RegExp")
    @NotNull
    private static final String LINE_GROUP = "line";
    @Language(value="RegExp")
    @NotNull
    private static final String COLUMN_GROUP = "column";
    @NotNull
    private static final @NotNull Map<char @NotNull [], Pattern> PATTERNS = new ConcurrentHashMap<char[], Pattern>();
    @NotNull
    private static final @NotNull List<@NotNull @NonNls String> MSVC_PATTERNS = Arrays.asList("%1$s%2$s(%3$d)%5$s: warning C4189: 'j': local variable is initialized but not referenced", "%1$s%2$s(%3$d)%5$s: warning C4255: 'main': no function prototype given: converting '()' to '(void)'", "%1$s%2$s(%3$d)%5$s: warning C4668: 'UNDEFINED_MACRO' is not defined as a preprocessor macro, replacing with '0' for '#if/#elif'", "%1$s%2$s(%3$d)%5$s: warning: \"This is a warning.\" [-W#warnings]", "%1$s%2$s(%3$d)%5$s: warning: This is a message. [-W#pragma-messages]", "%1$s%2$s(%3$d)%5$s: warning: Compiling %6$s [-W#pragma-messages]");
    @NotNull
    private static final @NotNull List<@NotNull @NonNls String> VLD_PATTERNS = Arrays.asList("%1$s%2$s (%3$d)%4$s: foo.exe!main() + 0xA bytes", "%1$s%2$s (%3$d)%4$s: kernel32.dll!__BaseThreadInitThunk() + 0x14 bytes");

    @Override
    protected final boolean runInDispatchThread() {
        return true;
    }

    @Override
    @NotNull
    protected final CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(CidrTestDataFixture.getCommonTestData());
    }

    @Override
    @Nullable
    protected OCMockProjectFixture createProjectFixture() {
        return new OCMockProjectFixture(this.myTestDataFixture);
    }

    @Override
    protected CidrProjectFixture.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixture.CleanProjectOption.CLEAN_FOR_TESTCASE;
    }

    @Override
    protected final void setUpFixtures() throws Exception {
        super.setUpFixtures();
        ((OCMockProjectFixture)this.myProjectFixture).initProject("console_path_filter/Paths.yaml");
    }

    @Test
    public final void testNoMatch() {
        this.assertMatch(null);
        this.assertMatch("");
        this.assertMatch("/a/file/path");
        this.assertMatch("/a/file/path:");
        this.assertMatch("/a/file/path()");
        this.assertMatch("bunch of words");
        this.assertMatch(":234");
        this.assertMatch("()");
        this.assertMatch("file:a234");
        this.assertMatch("file::234");
        if (SystemInfo.isWindows) {
            this.assertMatch("C:/a/file/path");
            this.assertMatch("C:\\a\\file\\path");
            this.assertMatch("C:/a/file/path:");
            this.assertMatch("C:\\a\\file\\path:");
            this.assertMatch("c:\\a\\file\\path:");
        }
    }

    @Test
    public final void testHangup() throws Exception {
        this.assertMatch(this.fileString("OC-8180_short_match.txt"));
        this.assertMatch(this.fileString("OC-8180_long_match.txt"));
        String filler = "abc".repeat(1000);
        CidrPathConsoleFilterTestCase.assertFilter(this.stringCapturingFilter(0L), CidrPathConsoleFilterTestCase.parseTestInfo("^file:23$ " + filler + "  ^another:34$", '^', '$'));
        CidrPathConsoleFilterTestCase.assertFilter(this.stringCapturingFilter(350L), CidrPathConsoleFilterTestCase.parseTestInfo("^file:23$ " + filler + "  another:34", '^', '$'));
    }

    @Test
    public final void testUnicode() {
        this.assertMatch("^/\u0432\u0447\u0435\u0440\u0430/\u0431\u044b\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0438\u0435/\u043d\u043e \u043f\u043e.\u043f\u044f\u0442\u044c:13$");
        this.assertMatch("^\u0432\u0447\u0435\u0440\u0430/\u0431\u044b\u043b\u0438 \u0431\u043e\u043b\u044c\u0448\u0438\u0435/\u043d\u043e \u043f\u043e.\u043f\u044f\u0442\u044c:13$");
        this.assertMatch("^\u043f\u043e.\u043f\u044f\u0442\u044c:13$");
    }

    @Test
    public final void testMatchAbsolute() {
        this.assertMatch("^/usr/bin/env:123$");
        this.assertMatch("JUNK ^/usr/bin/env:123$");
        this.assertMatch("JUNK ^/my hovercraft/is\tfull/of eels:13$");
        this.assertMatch("JUNK ^/my_hovercraft/is-full/of.eels:13$ JUNK");
        this.assertMatch("hello world ^/private/var/folders/8A/8AZW7cfnG4iQVqwgY-SIGk+++TI/-Tmp-/foo2407525662524492181bar/Paths/Paths/main.m:5$ JUNK");
        if (SystemInfo.isWindows) {
            this.assertMatch("JUNK ^C:/Windows/system32/cmd.exe:123$");
            this.assertMatch("JUNK ^C:\\Windows\\system32\\cmd.exe:123$");
            this.assertMatch("JUNK ^C:/Windows\\system32/cmd.exe:123$");
            this.assertMatch("JUNK ^c:\\Windows\\system32\\cmd.exe:123$");
        }
    }

    @Test
    public final void testMatchRelative() {
        this.assertMatch("^main.m:23$");
        this.assertMatch("^./main.m:23$");
        this.assertMatch("05-02-2007 ^22:15:23$");
        this.assertMatch("^relative_path/main.m:42$");
        this.assertMatch("^./relative_path/main.m:42$");
        this.assertMatch("relative ^path/main.m:28$");
        this.assertMatch("^./relative path/main.m:28$");
        this.assertMatch("relative\t^path/main.m:28$");
        this.assertMatch("^./relative\tpath/main.m:28$");
        this.assertMatch("JUNK relative\t^path/with spaces/main.m:28$ JUNK");
        this.assertMatch("JUNK ^./relative\tpath/with spaces/main.m:28$ JUNK");
        if (SystemInfo.isWindows) {
            this.assertMatch("^relative_path\\main.m:42$");
        }
    }

    @Test
    public final void testMultipleSlashes() {
        this.assertMatch("^sdf//file:234$");
        this.assertMatch("^//file//path:234$");
        if (SystemInfo.isWindows) {
            this.assertMatch("^sdf\\\\file:234$");
            this.assertMatch("^C:\\\\file\\\\path:234$");
        }
    }

    @Test
    public final void testMatchSpacesBeforeColon() {
        this.assertMatch("JUNK /usr with/bin space/env :13");
        this.assertMatch("JUNK /usr with/bin space/env\t:13");
        this.assertMatch("relative_path/main.m :42");
        this.assertMatch("relative_path/main.m\t:42");
        this.assertMatch("main.m :42");
        this.assertMatch("main.m\t:42");
    }

    @Test
    public final void testMatchSpacesAfterColon() {
        this.assertMatch("JUNK /usr with/bin space/env: 13");
        this.assertMatch("JUNK /usr with/bin space/env:\t13");
        this.assertMatch("relative_path/main.m: 42");
        this.assertMatch("relative_path/main.m:\t42");
        this.assertMatch("main.m: 42");
        this.assertMatch("main.m:\t42");
    }

    @Test
    public final void testMatchLineAndColumnNumber() {
        this.assertMatch("relative_path/main.m:42asd");
        this.assertMatch("relative_path/main.m(42asd)");
        this.assertMatch("relative_path/main.m:0x123");
        this.assertMatch("relative_path/main.m(0x123)");
        this.assertMatch("relative_path/main.m(a123)");
        this.assertMatch("relative_path/main.m(a123)");
        if (SystemInfo.isWindows) {
            this.assertMatch("relative_path/main.^m:abc:10$");
        } else {
            this.assertMatch("relative_path/main.m:^abc:10$");
        }
        this.assertMatch("^relative_path/main.m:10$");
        this.assertMatch("^relative_path/main.m(10)$");
        this.assertMatch("^relative_path/main.m:10:20$");
        this.assertMatch("^relative_path/main.m:10$;");
        this.assertMatch("^relative_path/main.m(10)$;");
        this.assertMatch("^relative_path/main.m:10:20$;");
        this.assertMatch("^relative_path/main.m:10$:");
        this.assertMatch("^relative_path/main.m(10)$:");
        this.assertMatch("^relative_path/main.m:10:20$:");
        this.assertMatches((Pair<String, Result[]>)Pair.create((Object)"relative_path/main.m:10:20:30", (Object)new Result[]{new Result(0, 26, new TestHyperlinkInfo("relative_path/main.m", 9, 19)), new Result(24, 29, new TestHyperlinkInfo("20", 29, 0))}));
        this.assertMatch("^relative_path/main.m(^10)$:20$");
        this.assertMatch("^relative_path/main.m:99999$");
        this.assertMatch("^relative_path/main.m(99999)$");
        this.assertMatch("relative_path/main.m:100000:");
        this.assertMatch("relative_path/main.m(100000)");
    }

    @Test
    public final void testMatchMultiple() {
        this.assertMatch("and now ^for/something:12$:comp[let]ely ^/different .../the larch:123$,^nudge-nudge:654$ wink-wink and now ^for/something(12)$:comp{let}ely ^/different .../the larch(123)$,^nudge-nudge(654)$ wink-wink");
    }

    @Test
    public final void testMatchPunctuation() {
        this.assertMatch("asd ^path:42$ 123");
        this.assertMatch("asd\t^path:42$\t123");
        if (SystemInfo.isWindows) {
            this.assertMatch("as^d:path:42:123$");
        } else {
            this.assertMatch("asd:^path:42:123$");
        }
        this.assertMatch("asd;^path:42$;123");
        this.assertMatch("asd!^path:42$!123");
        this.assertMatch("asd<^path:42$>123");
        this.assertMatch("asd>^path:42$<123");
        this.assertMatch("asd=^path:42$=123");
        this.assertMatch("asd\"^path:42$\"123");
        if (!SystemInfo.isWindows) {
            this.assertMatch("asd\\^path:42$\\123");
        }
        this.assertMatch("asd'^path:42$'123");
        this.assertMatch("asd`^path:42$`123");
        this.assertMatch("asd?^path:42$?123");
        this.assertMatch("asd#^path:42$#123");
        this.assertMatch("asd$^path:42#$123", '^', '#');
        this.assertMatch("asd%^path:42$%123");
        this.assertMatch("asd&^path:42$&123");
        this.assertMatch("asd*^path:42$*123");
        this.assertMatch("asd,^path:42$,123");
        this.assertMatch("asd^_path:42$^123", '_', '$');
        this.assertMatch("^asd~path:42$~123");
        this.assertMatch("^asd.path:42$.123");
        this.assertMatch("^asd_path:42$_123");
        this.assertMatch("^asd-path:42$-123");
        this.assertMatch("^asd+path:42$+123");
        this.assertMatch("^asd(path:42$)123");
        this.assertMatch("^asd(path(42)$)123");
        this.assertMatch("^asd(path[42]:42$)123");
        this.assertMatch("^asd(path{42}:42$)123");
        this.assertMatch("^asd)path:42$(123");
        this.assertMatch("^asd|path:42$|123");
        this.assertMatch("^asd@path:42$@123");
        this.assertMatch("(^asd(path(42)$)123)");
        this.assertMatch("[^asd(path[42]:42$)123]");
        this.assertMatch("{^asd(path{42}:42$)123}");
        this.assertMatch(")^asd(path(42)$)123(");
        this.assertMatch("]^asd(path[42]:42$)123{");
        this.assertMatch("}^asd(path{42}:42$)123[");
    }

    @Test
    public final void testLinkFilename() throws Exception {
        this.assertLink("^main.m:5$", this.projectFile(this.getTestProjectRoot().isCaseSensitive() ? "Paths/main.m" : "Main.m"));
        this.assertLink("^Paths/main.m:5$", this.projectFile("Paths/main.m"));
        this.assertLink("^Main.m:45$", this.projectFile("Main.m"));
        this.assertLink("with space:25", new String[0]);
        this.assertLink("^with@.at:15$", this.projectFile("Paths/dir/DirWith@At/with@.at"));
        this.assertLink("^inner.c:15$", this.projectFile("Paths/dir/inner.c"));
        this.assertLink("^Paren(42)thesis:55$", this.projectFile("Paths/dir/Dir (42) with parenthesis/Paren(42)thesis"));
        this.assertLink("^em{33}brace:15$", this.projectFile("Paths/dir/Dir (42) with parenthesis/With {999} braces/em{33}brace"));
        this.assertLink("Parenthesis (42) with space:25", new String[0]);
        this.assertLink("^PathsLib.m:35$", this.projectFile("PathsLib/PathsLib/PathsLib.m"));
    }

    @Test
    public final void testLinkAbsolutePath() throws Exception {
        this.assertLinkAbsoluteFile("Paths/main.m");
        this.assertLinkAbsoluteFile("Paths/with space");
        this.assertLinkAbsoluteFile("Paths/dir/DirWith@At/with@.at");
        this.assertLinkAbsoluteFile("Paths/dir/inner.c");
        this.assertLinkAbsoluteFile("Paths/dir/Dir (42) with parenthesis/Paren(42)thesis");
        this.assertLinkAbsoluteFile("Paths/dir/Parenthesis (42) with space");
        this.assertLinkAbsoluteFile("Paths/dir/Dir (42) with parenthesis/With {999} braces/em{33}brace");
        this.assertLinkAbsoluteFile("PathsLib/PathsLib/PathsLib.m");
    }

    @Test
    public final void testLinkHomePath() throws Exception {
        if (SystemInfo.isWindows) {
            return;
        }
        String home = System.getProperty("user.home");
        String homeFileName = ".bash_history";
        File file2 = new File(home, homeFileName);
        FileUtil.createIfDoesntExist((File)file2);
        this.assertLink("^~/" + homeFileName + ":3:30$", file2.getCanonicalPath());
    }

    @Test
    public final void testLinkRelativePath() throws Exception {
        this.assertLink("^Paths/main.m:5$", this.projectFile("Paths/main.m"));
        this.assertLink("^./Paths/main.m:5$", this.projectFile("Paths/main.m"));
        this.assertLink("^Paths/with space:15$", this.projectFile("Paths/with space"));
        this.assertLink("^Paths/dir/DirWith@At/with@.at:15$", this.projectFile("Paths/dir/DirWith@At/with@.at"));
        this.assertLink("^Paths/dir/inner.c:25$", this.projectFile("Paths/dir/inner.c"));
        this.assertLink("^./Paths/dir/inner.c:25$", this.projectFile("Paths/dir/inner.c"));
        this.assertLink("^Paths/dir/Dir (42) with parenthesis/Paren(42)thesis:55$", this.projectFile("Paths/dir/Dir (42) with parenthesis/Paren(42)thesis"));
        this.assertLink("^Paths/dir/Parenthesis (42) with space:25$", this.projectFile("Paths/dir/Parenthesis (42) with space"));
        this.assertLink("^Paths/dir/Dir (42) with parenthesis/With {999} braces/em{33}brace:15$", this.projectFile("Paths/dir/Dir (42) with parenthesis/With {999} braces/em{33}brace"));
        this.assertLink("^PathsLib/PathsLib/PathsLib.m:35$", this.projectFile("PathsLib/PathsLib/PathsLib.m"));
        this.assertLink("^./PathsLib/PathsLib/PathsLib.m:35$", this.projectFile("PathsLib/PathsLib/PathsLib.m"));
        if (SystemInfo.isWindows) {
            this.assertLink("^Paths\\main.m:5$", this.projectFile("Paths/main.m"));
            this.assertLink("^Paths/main.m:5$", this.projectFile("Paths/main.m"));
            this.assertLink("^./Paths/main.m:5$", this.projectFile("Paths/main.m"));
        }
        this.assertLink("^Paths/dir/../main.m:15$", this.projectFile("Paths/main.m"));
        this.assertLink("^Paths/dir/../../Paths/../Paths/main.m:15$", this.projectFile("Paths/main.m"));
        this.assertLink("^../console_path_filter/Paths/dir/../main.m:15$", this.projectFile("Paths/main.m"));
        this.assertLink("^../../../../Paths/dir/../main.m:15$", this.projectFile("Paths/main.m"));
        this.assertLink("^./../Paths/main.m:15$", this.projectFile("Paths/main.m"));
        if (SystemInfo.isWindows) {
            this.assertLink("^Paths\\dir\\..\\main.m:15$", this.projectFile("Paths/main.m"));
            this.assertLink("^..\\..\\..\\..\\Paths\\dir\\..\\main.m:15$", this.projectFile("Paths/main.m"));
            this.assertLink("^.\\..\\Paths\\main.m:15$", this.projectFile("Paths/main.m"));
        }
    }

    @Test
    public final void testLinkMsvcNewDiagnostics() {
        SoftAssertions.assertSoftly(softly -> {
            try {
                @NonNls String file2 = this.projectFile("Paths/main.m");
                int line = 42;
                int column = 9999;
                ((Stream)Stream.concat(MSVC_PATTERNS.stream(), Stream.of("%1$s%2$s(%3$d)%5$s: warning: Last modified on Wed Dec 22 15:35:24 2021 [-W#pragma-messages]")).sequential()).flatMap(pattern -> Stream.of(pattern, pattern.replace("%3$d", "%3$d,%4$d"))).map(pattern -> String.format(pattern, Character.valueOf('^'), file2, 42, 9999, Character.valueOf('$'), file2)).flatMap(compilerMessage -> Stream.of(compilerMessage, compilerMessage.replace(File.separatorChar, '/'))).distinct().forEachOrdered(compilerMessage -> {
                    try {
                        this.assertLink((String)compilerMessage, file2);
                    }
                    catch (AssertionError ae) {
                        softly.fail("%n%s in compiler message: %s", new Object[]{((Throwable)((Object)ae)).getMessage(), compilerMessage});
                    }
                });
            }
            catch (IOException ioe) {
                softly.fail(ioe.toString(), (Throwable)ioe);
            }
        });
    }

    @Test
    public final void testMatchMsvcNewDiagnostics() {
        SoftAssertions.assertSoftly(softly -> {
            try {
                @NonNls String file2 = this.projectFile("Paths/main.m");
                int line = 42;
                int column = 9999;
                MSVC_PATTERNS.stream().flatMap(pattern -> Stream.of(pattern, pattern.replace("%3$d", "%3$d,%4$d"))).map(pattern -> String.format(pattern, Character.valueOf('^'), file2, 42, 9999, Character.valueOf('$'), file2)).flatMap(compilerMessage -> Stream.of(compilerMessage, compilerMessage.replace(File.separatorChar, '/'))).distinct().forEachOrdered(compilerMessage -> {
                    try {
                        this.assertMatch((String)compilerMessage);
                    }
                    catch (AssertionError ae) {
                        softly.fail("%n%s in compiler message: %s", new Object[]{((Throwable)((Object)ae)).getMessage(), compilerMessage});
                    }
                });
            }
            catch (IOException ioe) {
                softly.fail(ioe.toString(), (Throwable)ioe);
            }
        });
    }

    @Test
    public final void testLinkVisualLeakDetector() {
        SoftAssertions.assertSoftly(softly -> {
            try {
                @NonNls String file2 = this.projectFile("Paths/main.m");
                int line = 42;
                VLD_PATTERNS.stream().map(pattern -> String.format(pattern, Character.valueOf('^'), file2, 42, Character.valueOf('$'), file2)).flatMap(compilerMessage -> Stream.of(compilerMessage, compilerMessage.replace(File.separatorChar, '/'))).distinct().forEachOrdered(compilerMessage -> {
                    try {
                        this.assertLink((String)compilerMessage, file2);
                    }
                    catch (AssertionError ae) {
                        softly.fail("%n%s in compiler message: %s", new Object[]{((Throwable)((Object)ae)).getMessage(), compilerMessage});
                    }
                });
            }
            catch (IOException ioe) {
                softly.fail(ioe.toString(), (Throwable)ioe);
            }
        });
    }

    @Test
    public final void testMatchVisualLeakDetector() {
        SoftAssertions.assertSoftly(softly -> {
            try {
                @NonNls String file2 = this.projectFile("Paths/main.m");
                int line = 42;
                VLD_PATTERNS.stream().map(pattern -> String.format(pattern, Character.valueOf('^'), file2, 42, Character.valueOf('$'), file2)).flatMap(compilerMessage -> Stream.of(compilerMessage, compilerMessage.replace(File.separatorChar, '/'))).distinct().forEachOrdered(compilerMessage -> {
                    try {
                        this.assertMatch((String)compilerMessage);
                    }
                    catch (AssertionError ae) {
                        softly.fail("%n%s in compiler message: %s", new Object[]{((Throwable)((Object)ae)).getMessage(), compilerMessage});
                    }
                });
            }
            catch (IOException ioe) {
                softly.fail(ioe.toString(), (Throwable)ioe);
            }
        });
    }

    @Test
    public final void testInternalTestCodeIsCorrect() {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)CidrPathConsoleFilterTestCase.getPathAndNumberColon("regular.c:42")).isEqualTo((Object)new TestHyperlinkInfo("regular.c", 41, 0));
            softly.assertThat((Object)CidrPathConsoleFilterTestCase.getPathAndNumberColon("regular.c:43:44")).isEqualTo((Object)new TestHyperlinkInfo("regular.c", 42, 43));
            softly.assertThat((Object)CidrPathConsoleFilterTestCase.getPathAndNumberParenthesis("msvc.c(42)")).isEqualTo((Object)new TestHyperlinkInfo("msvc.c", 41, 0));
            softly.assertThat((Object)CidrPathConsoleFilterTestCase.getPathAndNumberParenthesis("msvc.c(43,44)")).isEqualTo((Object)new TestHyperlinkInfo("msvc.c", 42, 43));
        });
    }

    @Test
    public final void testFileUpdates() throws Exception {
        String fileName = "test_new_file.c";
        CidrCodeInsightFixture codeInsightFixture = new CidrCodeInsightFixture(this.myProjectFixture, OCCodeInsightTestCase.createProjectAdapter((OCMockProjectFixture)this.myProjectFixture));
        codeInsightFixture.setUp();
        try {
            this.assertLink("test_new_file.c:5", new String[0]);
            codeInsightFixture.configureByText("void f(){}", "test_new_file.c");
            this.assertLink("^test_new_file.c:5$", this.projectFile("test_new_file.c"));
            ApplicationManager.getApplication().runWriteAction(() -> {
                codeInsightFixture.deleteCreatedFiles();
                this.assertLink("test_new_file.c:5", new String[0]);
            });
        }
        finally {
            codeInsightFixture.tearDown();
        }
    }

    private String fileString(String filename) throws IOException {
        return FileUtil.loadFile((File)new File(this.projectFile(filename)));
    }

    @NotNull
    @NlsSafe
    protected final String projectFile(String filename) throws IOException {
        File file2 = ((OCMockProjectFixture)this.myProjectFixture).findProjectSubIOFile(filename);
        CidrPathConsoleFilterTestCase.assertTrue((String)("can't find project file: '" + filename + " (" + file2.getPath() + ")'"), (boolean)file2.exists());
        return file2.getCanonicalPath();
    }

    protected final void assertLink(@NotNull @NonNls String markedDownLine, String ... expectedFileNames) {
        this.assertLink(markedDownLine, '^', '$', expectedFileNames);
    }

    private void assertLink(@NotNull @NonNls String markedDownLine, char startMarkerChar, char endMarkerChar, String ... expectedFileNames) {
        CidrPathConsoleFilter filter = new CidrPathConsoleFilter(this.getProject(), this.getCidrToolEnvironment(), ((OCMockProjectFixture)this.myProjectFixture).getProjectIODir()){

            @NotNull
            protected HyperlinkInfo createHyperlinkInfo(@NotNull VirtualFile file2, int line, int column) {
                return new TestHyperlinkInfo(file2, line, column);
            }
        };
        Pair<String, Result[]> result2 = CidrPathConsoleFilterTestCase.parseTestInfo(markedDownLine, startMarkerChar, endMarkerChar);
        for (int i2 = 0; i2 < ((Result[])result2.second).length; ++i2) {
            Result r = ((Result[])result2.second)[i2];
            r.myInfo.setFilePath(expectedFileNames[i2]);
        }
        CidrPathConsoleFilterTestCase.assertFilter(filter, result2);
    }

    private void assertLinkAbsoluteFile(@NotNull String fileName) throws Exception {
        String localPath = this.projectFile(fileName);
        String envPath = this.getCidrToolEnvironment().toEnvPath(localPath);
        this.assertLink("^" + localPath + ":15$", localPath);
        this.assertLink("^" + envPath + ":15$", localPath);
        if (SystemInfo.isWindows) {
            localPath = localPath.replace('\\', '/');
            this.assertLink("^" + localPath + ":15$", localPath);
            this.assertLink("^" + envPath + ":15$", localPath);
        }
    }

    protected final void assertMatch(@Nullable @NonNls String markedDownLine) {
        this.assertMatch(markedDownLine, '^', '$');
    }

    private void assertMatch(@Nullable String markedDownLine, char startMarkerChar, char endMarkerChar) {
        this.assertMatches(CidrPathConsoleFilterTestCase.parseTestInfo(markedDownLine, startMarkerChar, endMarkerChar));
    }

    private void assertMatches(Pair<String, Result[]> result2) {
        CidrPathConsoleFilter filter = this.stringCapturingFilter(0L);
        CidrPathConsoleFilterTestCase.assertFilter(filter, result2);
    }

    private CidrPathConsoleFilter stringCapturingFilter(final long processingDelayMillis) {
        return new CidrPathConsoleFilter(this.getProject(), this.getCidrToolEnvironment(), ((OCMockProjectFixture)this.myProjectFixture).getProjectIODir()){

            @NotNull
            protected HyperlinkInfo processMatch(@NotNull String matchedPath, int line, int column) {
                if (processingDelayMillis > 0L) {
                    try {
                        Thread.sleep(processingDelayMillis);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"test interrupted");
                    }
                }
                return new TestHyperlinkInfo(matchedPath, line, column);
            }
        };
    }

    private static void assertFilter(CidrPathConsoleFilter filter, Pair<String, Result[]> result2) {
        CidrPathConsoleFilterTestCase.assertFilter(filter, 0, (String)result2.first, (Result[])result2.second);
        CidrPathConsoleFilterTestCase.assertFilter(filter, 102, (String)result2.first, (Result[])result2.second);
    }

    private static void assertFilter(CidrPathConsoleFilter filter, int offset, @Nullable String line, Result[] expectedItems) {
        int totalLength;
        String l = (String)ObjectUtils.notNull((Object)line, (Object)"");
        Filter.Result result2 = (Filter.Result)ReadAction.compute(() -> CidrPathConsoleFilterTestCase.lambda$assertFilter$20(filter, l, totalLength = offset + l.length()));
        List items = result2 == null ? Collections.emptyList() : result2.getResultItems();
        String lineInfo = "[for line '" + (line == null ? "null" : line) + "', offset " + offset + "]";
        CidrPathConsoleFilterTestCase.assertNotNull((String)lineInfo, (Object)items);
        CidrPathConsoleFilterTestCase.assertEquals((String)lineInfo, (int)expectedItems.length, (int)items.size());
        for (int i2 = 0; i2 < expectedItems.length; ++i2) {
            Result expectedItem = expectedItems[i2];
            Filter.ResultItem item = (Filter.ResultItem)items.get(i2);
            TestHyperlinkInfo info = (TestHyperlinkInfo)item.getHyperlinkInfo();
            CidrPathConsoleFilterTestCase.assertEquals((String)("Unexpected path for " + lineInfo), (String)FileUtil.toSystemIndependentName((String)expectedItem.myInfo.getFilePath()), (String)FileUtil.toSystemIndependentName((String)info.getFilePath()));
            CidrPathConsoleFilterTestCase.assertEquals((String)("Unexpected line for " + lineInfo), (int)expectedItem.myInfo.getLine(), (int)info.getLine());
            CidrPathConsoleFilterTestCase.assertEquals((String)("Unexpected column for " + lineInfo), (int)expectedItem.myInfo.getColumn(), (int)info.getColumn());
            CidrPathConsoleFilterTestCase.assertEquals((String)("Unexpected highlighting start offset for " + lineInfo), (int)(expectedItem.myStart + offset), (int)item.getHighlightStartOffset());
            CidrPathConsoleFilterTestCase.assertEquals((String)("Unexpected highlighting end offset for " + lineInfo), (int)(expectedItem.myEnd + offset), (int)item.getHighlightEndOffset());
        }
    }

    @NotNull
    private static Pair<String, Result[]> parseTestInfo(@Nullable @NonNls String markedDownLine, char startMarkerChar, char endMarkerChar) {
        if (markedDownLine == null) {
            return new Pair(null, (Object)new Result[0]);
        }
        String startMarker = String.valueOf(startMarkerChar);
        String endMarker = String.valueOf(endMarkerChar);
        @NonNls String resultString = markedDownLine.replaceAll(Pattern.quote(startMarker), "\u0000" + Matcher.quoteReplacement(startMarker) + "\u0000");
        resultString = resultString.replaceAll(Pattern.quote(endMarker), "\u0000" + Matcher.quoteReplacement(endMarker) + "\u0000");
        ArrayList<String> fragments = new ArrayList<String>(Arrays.asList(resultString.split("\u0000")));
        int totalLength = 0;
        ArrayList<Pair> itemsInProgress = new ArrayList<Pair>();
        ArrayList<Result> items = new ArrayList<Result>();
        StringBuilder lineBuilder = new StringBuilder();
        while (fragments.size() > 0) {
            String fragment = (String)fragments.remove(0);
            if (fragment.equals(startMarker)) {
                itemsInProgress.add(Pair.create((Object)new StringBuilder(), (Object)new Result(totalLength, 0, new TestHyperlinkInfo())));
                continue;
            }
            if (fragment.equals(endMarker)) {
                Pair itemInfo = (Pair)itemsInProgress.remove(0);
                @NonNls String itemString = ((StringBuilder)itemInfo.first).toString();
                TestHyperlinkInfo pathAndNumber = CidrPathConsoleFilterTestCase.getPathAndNumberColon(itemString);
                if (pathAndNumber == null && (pathAndNumber = CidrPathConsoleFilterTestCase.getPathAndNumberParenthesis(itemString)) == null) {
                    Assert.assertNotNull((String)("Incorrect test pattern: " + itemString), (Object)pathAndNumber);
                }
                Result item = (Result)itemInfo.second;
                item.myInfo = pathAndNumber;
                item.myEnd = totalLength;
                items.add(item);
                continue;
            }
            for (Pair itemInfo : itemsInProgress) {
                ((StringBuilder)itemInfo.first).append(fragment);
            }
            lineBuilder.append(fragment);
            totalLength += fragment.length();
        }
        CidrPathConsoleFilterTestCase.assertEmpty(itemsInProgress);
        return Pair.create((Object)lineBuilder.toString(), (Object)items.toArray(new Result[0]));
    }

    @NotNull
    private static Pattern pathLineColumnPattern(char startMarker, char lineColumnSeparator, char endMarker) {
        char @NotNull [] key = new char[]{startMarker, lineColumnSeparator, endMarker};
        return PATTERNS.computeIfAbsent(key, k -> CidrPathConsoleFilterTestCase.pathLineColumnPattern0(k[0], k[1], k[2]));
    }

    @NotNull
    private static Pattern pathLineColumnPattern0(char startMarker, char lineColumnSeparator, char endMarker) {
        @NonNls String regex = endMarker == '\u0000' ? "^(?<file>.+?)\\Q" + startMarker + "\\E(?<line>\\d+)(?:\\Q" + lineColumnSeparator + "\\E(?<column>\\d+))?$" : "^(?<file>.+?) ?\\Q" + startMarker + "\\E(?<line>\\d+)(?:\\Q" + lineColumnSeparator + "\\E(?<column>\\d+))?\\Q" + endMarker + "\\E$";
        return Pattern.compile(regex);
    }

    @Nullable
    private static TestHyperlinkInfo getPathAndNumberColon(@NotNull CharSequence line) {
        return CidrPathConsoleFilterTestCase.getPathAndNumber(line, ':');
    }

    @Nullable
    private static TestHyperlinkInfo getPathAndNumberParenthesis(@NotNull CharSequence line) {
        return CidrPathConsoleFilterTestCase.getPathAndNumber(line, '(', ',', ')');
    }

    @Nullable
    private static TestHyperlinkInfo getPathAndNumber(@NotNull CharSequence line, char startMarker) {
        return CidrPathConsoleFilterTestCase.getPathAndNumber(line, startMarker, startMarker);
    }

    @Nullable
    private static TestHyperlinkInfo getPathAndNumber(@NotNull CharSequence line, char startMarker, char lineColumnSeparator) {
        return CidrPathConsoleFilterTestCase.getPathAndNumber(line, startMarker, lineColumnSeparator, '\u0000');
    }

    @Nullable
    private static TestHyperlinkInfo getPathAndNumber(@NotNull CharSequence line, char startMarker, char lineColumnSeparator, char endMarker) {
        Pattern pattern = CidrPathConsoleFilterTestCase.pathLineColumnPattern(startMarker, lineColumnSeparator, endMarker);
        Matcher matcher = pattern.matcher(line);
        if (matcher.matches()) {
            String file2 = matcher.group(FILE_GROUP);
            int lineNumber = Integer.parseInt(matcher.group(LINE_GROUP)) - 1;
            String columnNumberRaw = matcher.group(COLUMN_GROUP);
            int columnNumber = columnNumberRaw == null ? 0 : Integer.parseInt(columnNumberRaw) - 1;
            return new TestHyperlinkInfo(file2, lineNumber, columnNumber);
        }
        return null;
    }

    @NotNull
    protected abstract CidrToolEnvironment getCidrToolEnvironment();

    private static /* synthetic */ Filter.Result lambda$assertFilter$20(CidrPathConsoleFilter filter, String l, int totalLength) throws RuntimeException {
        return filter.applyFilter(l, totalLength);
    }

    private static final class Result {
        private TestHyperlinkInfo myInfo;
        private final int myStart;
        private int myEnd;

        private Result(int hlStart, int hlEnd, TestHyperlinkInfo info) {
            this.myInfo = info;
            this.myStart = hlStart;
            this.myEnd = hlEnd;
        }
    }
}

