/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.ProcessOutputListener;
import com.jetbrains.cidr.execution.TimeoutAssertionFailedError;
import com.jetbrains.cidr.execution.testing.CidrBeforeTestRunTaskProvider;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrExecutionFixture<PROJECT_FIXTURE_TYPE extends CidrProjectFixture>
extends Assert {
    @NotNull
    protected List<CheckedFutureResult> myResultsToCheck = new ArrayList<CheckedFutureResult>();
    @NotNull
    protected final PROJECT_FIXTURE_TYPE myProjectFixture;
    protected ProcessHandler myProcessHandler;
    protected ExecutionConsole myConsole;
    protected ExecutionResult myExecutionResult;
    @NotNull
    protected ConfigurationTypeBase myConfigurationType;
    @Nullable
    protected String myTargetName;
    @Nullable
    protected String myConfigurationName;
    private ExecutionTarget myExecutionTarget;
    private CommandLineState myState;
    private final Disposable myDisposable = Disposer.newDisposable();
    public static final int TIMEOUT = 30000;
    public Starter<ExecutionResult> RUN_STARTER = new Starter<ExecutionResult>(){

        @Override
        public Executor executor() {
            return DefaultRunExecutor.getRunExecutorInstance();
        }

        @Override
        public ExecutionResult start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
            final ExecutionResult result2 = state.execute(executor, (ProgramRunner)runner);
            Disposer.register((Disposable)CidrExecutionFixture.this.myDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ExecutionConsole console = result2.getExecutionConsole();
                    if (!Disposer.isDisposed((Disposable)console)) {
                        UIUtil.invokeAndWaitIfNeeded(() -> Disposer.dispose((Disposable)console));
                    }
                }
            });
            return result2;
        }
    };
    public Starter<XDebugSession> DEBUG_STARTER = new Starter<XDebugSession>(){

        @Override
        public Executor executor() {
            return DefaultDebugExecutor.getDebugExecutorInstance();
        }

        @Override
        public XDebugSession start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
            return runner.startDebugSession((CidrCommandLineState)state, env, false, listeners);
        }
    };
    public Starter<XDebugSession> DEBUG_STARTER_MUTED_BREAKS = new Starter<XDebugSession>(){

        @Override
        public Executor executor() {
            return DefaultDebugExecutor.getDebugExecutorInstance();
        }

        @Override
        public XDebugSession start(Executor executor, CidrRunner runner, CommandLineState state, ExecutionEnvironment env, XDebugSessionListener ... listeners) throws com.intellij.execution.ExecutionException {
            return runner.startDebugSession((CidrCommandLineState)state, env, true, listeners);
        }
    };

    protected CidrExecutionFixture(@NotNull PROJECT_FIXTURE_TYPE fixture, @NotNull ConfigurationTypeBase configurationType) {
        this(fixture, configurationType, null, null);
    }

    protected CidrExecutionFixture(@NotNull PROJECT_FIXTURE_TYPE fixture, @NotNull ConfigurationTypeBase configurationType, @Nullable String targetName, @Nullable String configurationName2) {
        this.myProjectFixture = fixture;
        this.myConfigurationType = configurationType;
        this.myTargetName = targetName;
        this.myConfigurationName = configurationName2;
    }

    public void initTargetAndConfiguration(String targetName, String configurationName2) {
        this.myTargetName = targetName;
        this.myConfigurationName = configurationName2;
    }

    public void setConfigurationType(@NotNull ConfigurationTypeBase configurationType) {
        this.myConfigurationType = configurationType;
    }

    public abstract void buildIfNeeded() throws Exception;

    public ExecutionConsole getConsole() {
        return this.myConsole;
    }

    @NotNull
    public ConfigurationTypeBase getConfigurationType() {
        return this.myConfigurationType;
    }

    @NotNull
    public PROJECT_FIXTURE_TYPE getProjectFixture() {
        return this.myProjectFixture;
    }

    public CommandLineState getState() {
        return this.myState;
    }

    public <T> T startRunDebug(@NotNull CidrRunProfile runConfiguration, @Nullable ExecutionTarget executionTarget, boolean build2, @NotNull Starter<T> starter, XDebugSessionListener ... listeners) throws Exception {
        return this.startRunDebug(runConfiguration, null, executionTarget, build2, starter, listeners);
    }

    public <T> T startRunDebug(@NotNull CidrRunProfile runConfiguration, @Nullable RunnerSettings settings, @Nullable ExecutionTarget executionTarget, boolean build2, @NotNull Starter<T> starter, XDebugSessionListener ... listeners) throws Exception {
        if (build2 && runConfiguration instanceof CidrRunConfiguration) {
            ((CidrProjectFixture)this.myProjectFixture).buildIfNeeded((CidrRunConfiguration)runConfiguration, executionTarget);
        }
        Executor executor = starter.executor();
        CidrRunner runner = (CidrRunner)ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
        CidrExecutionFixture.assertNotNull((Object)runner);
        CidrExecutionFixture.assertTrue((boolean)runner.canRun(executor.getId(), (RunProfile)runConfiguration));
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(((CidrProjectFixture)this.myProjectFixture).getProject(), executor).runner((ProgramRunner)runner).runnerSettings(settings).target(executionTarget).runProfile((RunProfile)runConfiguration).build();
        CommandLineState state = runConfiguration.getState(executor, env);
        CidrExecutionFixture.assertNotNull((Object)state);
        if (state instanceof CidrTestCommandLineState) {
            for (BeforeRunTask task : ((CidrTestCommandLineState)state).getConfiguration().getBeforeRunTasks()) {
                if (task.getProviderId() != CidrBeforeTestRunTaskProvider.ID || !task.isEnabled()) continue;
                ((CidrTestCommandLineState)state).prepareTestExecutionEnvironment((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
        }
        CidrExecutionFixture.assertConfigurationSettings(runConfiguration);
        this.myExecutionTarget = executionTarget;
        this.myState = state;
        return (T)WriteAction.computeAndWait(() -> starter.start(executor, runner, state, env, listeners));
    }

    private static void assertConfigurationSettings(@NotNull CidrRunProfile runConfiguration) throws RuntimeConfigurationException {
        if (runConfiguration instanceof RunConfigurationBase) {
            ((RunConfigurationBase)runConfiguration).checkSettingsBeforeRun();
        } else if (runConfiguration instanceof RunConfiguration) {
            ((RunConfiguration)runConfiguration).checkConfiguration();
        }
    }

    public void startRunSession() throws Exception {
        this.startRunSession((String)null);
    }

    public void startRunSession(@Nullable String parameters) throws Exception {
        this.startRunSession(parameters, null);
    }

    public void startRunSession(@Nullable ProcessListener listener2) throws Exception {
        this.startRunSession(null, listener2);
    }

    public void startRunSession(@Nullable String parameters, @Nullable ProcessListener listener2) throws Exception {
        this.startRunSession(this.getBuildConfigurationData(), (Consumer<CidrRunConfiguration>)((Consumer)config -> config.setProgramParameters(parameters)), listener2);
    }

    public void startRunSession(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable ProcessListener listener2) throws Exception {
        this.initRunSession(listener2, this.startRun(buildTargetAndConfigurationData, configurator));
    }

    protected ExecutionResult startRun(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        RunnerAndConfigurationSettings settings = this.createRunConfiguration(buildTargetAndConfigurationData, configurator);
        return this.startRunDebug((CidrRunProfile)((CidrRunConfiguration)settings.getConfiguration()), null, true, this.RUN_STARTER, new XDebugSessionListener[0]);
    }

    @NotNull
    public abstract String getTestExecutablePath(@NotNull String var1) throws Exception;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.disposeSession();
        Disposer.dispose((Disposable)this.myDisposable);
        for (CheckedFutureResult each : this.myResultsToCheck) {
            each.tryGet();
        }
    }

    public void disposeSession() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.destroyProcess();
            CidrExecutionFixture.waitFor(this.myProcessHandler);
        }
        if (this.myConsole != null) {
            WriteAction.runAndWait(() -> {
                Disposer.dispose((Disposable)this.myConsole);
                this.myConsole = null;
            });
        }
    }

    public String runAndWait(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Long timeoutMs) throws Exception {
        ProcessOutputListener listener2 = new ProcessOutputListener();
        this.startRunSession(buildTargetAndConfigurationData, configurator, (ProcessListener)listener2);
        long timeout = timeoutMs == null ? 30000L : timeoutMs;
        boolean result2 = CidrExecutionFixture.waitFor(this.myProcessHandler, timeout);
        if (!result2) {
            throw new TimeoutAssertionFailedError("Execution timed out (" + timeout + " ms)");
        }
        return listener2.getAllOutput().replace("\r", "");
    }

    public String runAndWait(@Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.runAndWait(this.getBuildConfigurationData(), configurator, null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName2, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.runAndWait(targetName, configurationName2, configurator, null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName2, @Nullable Consumer<CidrRunConfiguration> configurator, @Nullable Long timeoutMs) throws Exception {
        return this.runAndWait(this.createBuildConfigurationData(targetName, configurationName2), configurator, timeoutMs);
    }

    public String runAndWait() throws Exception {
        return this.runAndWait(null);
    }

    public String runAndWait(@Nullable String targetName, @Nullable String configurationName2) throws Exception {
        return this.runAndWait(targetName, configurationName2, null);
    }

    protected void initRunSession(ProcessListener listener2, ExecutionResult result2) {
        this.disposeSession();
        this.myConsole = result2.getExecutionConsole();
        this.myProcessHandler = result2.getProcessHandler();
        this.myExecutionResult = result2;
        if (listener2 != null) {
            this.myProcessHandler.addProcessListener(listener2);
        }
        this.myProcessHandler.startNotify();
    }

    public boolean waitForProcessHandler() {
        return CidrExecutionFixture.waitFor(this.myProcessHandler);
    }

    public static <T> T waitFor(BlockingQueue<T> q) throws InterruptedException {
        return CidrExecutionFixture.waitFor(q, 30000L);
    }

    public static <T> T waitFor(BlockingQueue<T> q, long timeout) throws InterruptedException {
        return q.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(ProcessHandler p) {
        return CidrExecutionFixture.waitFor(p, 30000L);
    }

    public static boolean waitFor(ProcessHandler p, long timeout) {
        return p.waitFor(timeout);
    }

    public static boolean waitFor(Semaphore s) throws InterruptedException {
        return CidrExecutionFixture.waitFor(s, 30000L);
    }

    public static boolean waitFor(Semaphore s, long timeout) throws InterruptedException {
        return s.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(CountDownLatch latch) throws InterruptedException {
        return CidrExecutionFixture.waitFor(latch, 30000L);
    }

    public static boolean waitFor(CountDownLatch latch, long timeout) throws InterruptedException {
        return latch.await(timeout, TimeUnit.MILLISECONDS);
    }

    public static <T> T waitFor(FutureResult<T> f) throws InterruptedException {
        return CidrExecutionFixture.waitFor(f, 30000L);
    }

    public static <T> T waitFor(FutureResult<T> f, long timeout) throws InterruptedException {
        try {
            Object result2 = f.get(timeout, TimeUnit.MILLISECONDS);
            f.reset();
            return (T)result2;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getProcessInput() {
        return this.myProcessHandler.getProcessInput();
    }

    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static void assertOutput(@RegExp String expectedRegex, String output) {
        String regex = ".*?\n" + expectedRegex + "\nProcess finished with exit code 0\n";
        CidrExecutionFixture.assertTrue((String)(output + "\ndoes not match regex:\n" + regex), (boolean)output.matches(regex));
    }

    public void assertApplicationStopped(int pid, boolean appStopped) {
        boolean found2 = ProcessHandle.of(pid).isPresent();
        if (appStopped) {
            CidrExecutionFixture.assertFalse((String)"Process should be stopped", (boolean)found2);
        } else {
            CidrExecutionFixture.assertTrue((String)("Process " + pid + " should be running"), (boolean)found2);
        }
    }

    @NotNull
    public BuildTargetAndConfigurationData getBuildConfigurationData() {
        return this.createBuildConfigurationData(this.myTargetName, this.myConfigurationName);
    }

    @NotNull
    public BuildTargetAndConfigurationData createBuildConfigurationData(@Nullable String targetName, @Nullable String configName) {
        return new BuildTargetAndConfigurationData(((CidrProjectFixture)this.myProjectFixture).getProjectName(), targetName, configName);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.createRunConfiguration(this.myConfigurationType, buildTargetAndConfigurationData, configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(ConfigurationTypeBase type, Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.createRunConfiguration(type, this.myTargetName, this.myConfigurationName, configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @Nullable String targetName, @Nullable String configName, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.createRunConfiguration(type, this.createBuildConfigurationData(targetName, configName), configurator);
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @NotNull BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return ((CidrProjectFixture)this.myProjectFixture).createRunConfiguration("__test__", type, buildTargetAndConfigurationData, true, true, configurator);
    }

    public <T> CheckedFutureResult<T> createCheckedResult() {
        return new CheckedFutureResult();
    }

    public void startRerunSession() {
        CidrRerunFailedTestsAction action = (CidrRerunFailedTestsAction)((DefaultExecutionResult)this.myExecutionResult).getRestartActions()[0];
        ExecutionResult result2 = this.restartRunDebug(action, this.RUN_STARTER);
        this.myConsole = result2.getExecutionConsole();
        this.myProcessHandler = result2.getProcessHandler();
        this.myExecutionResult = result2;
        this.myProcessHandler.startNotify();
    }

    protected <T> T restartRunDebug(@NotNull CidrRerunFailedTestsAction rerunAction, @NotNull Starter<T> starter) {
        EdtTestUtil.runInEdtAndWait(PlatformTestUtil::dispatchAllEventsInIdeEventQueue);
        try {
            return (T)WriteAction.computeAndWait(() -> {
                CidrRunProfile profile = (CidrRunProfile)rerunAction.getRunProfile(null);
                CidrExecutionFixture.assertNotNull((Object)profile);
                return this.startRunDebug(profile, this.myExecutionTarget, false, starter, new XDebugSessionListener[0]);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Starter<T> {
        public Executor executor();

        public T start(Executor var1, CidrRunner var2, CommandLineState var3, ExecutionEnvironment var4, XDebugSessionListener ... var5) throws com.intellij.execution.ExecutionException;
    }

    public class CheckedFutureResult<T>
    extends FutureResult<T> {
        public CheckedFutureResult() {
            CidrExecutionFixture.this.myResultsToCheck.add(this);
        }

        public synchronized void set(@Nullable T result2) {
            this.checkNotSet();
            super.set(result2);
        }

        public synchronized void setException(@NotNull Throwable e) {
            this.checkNotSet();
            super.setException(e);
        }

        private void checkNotSet() {
            try {
                Object alreadySet;
                try {
                    alreadySet = this.tryGet();
                }
                catch (ExecutionException e) {
                    throw new AssertionError((Object)("result is already set to exception" + e));
                }
                if (alreadySet != null) {
                    throw new AssertionError((Object)("result is already set: " + alreadySet));
                }
            }
            catch (AssertionError error2) {
                this.reset();
                this.setException((Throwable)((Object)error2));
                throw error2;
            }
        }
    }
}

