/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.function.Supplier;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextConfigurationTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrCodeInsightFixture> {
    protected CidrContextRunConfigurationFixture myFrameworkFixture;

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFrameworkFixture = new CidrContextRunConfigurationFixture(this);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
    }

    @Nullable
    protected RunnerAndConfigurationSettings createContextConfiguration(@NotNull PsiElement element, @NotNull Class<? extends RunConfigurationProducer> runConfigurationProducerClass, @Nullable SimpleDataContext.Builder contextBuilder) {
        ConfigurationContext context2 = this.createContext(element, contextBuilder == null ? SimpleDataContext.builder() : contextBuilder);
        return CidrContextConfigurationTestCase.createContextConfiguration(context2, runConfigurationProducerClass);
    }

    @Nullable
    protected static RunnerAndConfigurationSettings createContextConfiguration(@NotNull ConfigurationContext context2, @NotNull Class<? extends RunConfigurationProducer> runConfigurationProducerClass) {
        RunConfigurationProducer producer = RunConfigurationProducer.getInstance(runConfigurationProducerClass);
        ConfigurationFromContext fromContext = producer.findOrCreateConfigurationFromContext(context2);
        return fromContext == null ? null : fromContext.getConfigurationSettings();
    }

    @NotNull
    protected ConfigurationContext createContext(@NotNull PsiElement element, @NotNull SimpleDataContext.Builder contextBuilder) {
        DataContext dataContext = contextBuilder.add(CommonDataKeys.PROJECT, (Object)this.getProject()).add(PlatformCoreDataKeys.MODULE, (Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)element)).add(Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)element)).build();
        return ConfigurationContext.getFromContext((DataContext)dataContext, (String)"unknown");
    }

    public static void assertValidity(@NotNull CidrRunConfiguration config, @Nullable String expectedError) throws RuntimeConfigurationException {
        block3: {
            try {
                config.checkConfiguration();
                if (expectedError != null) {
                    CidrContextConfigurationTestCase.fail((String)("Error expected: " + expectedError));
                }
            }
            catch (RuntimeConfigurationException e) {
                if (expectedError != null && e.getMessage().equals(expectedError)) break block3;
                throw e;
            }
        }
    }

    public void assertReusingExistingConfiguration(PsiElement element) {
        RunnerAndConfigurationSettings settings = this.createContextConfiguration(element);
        RunManagerImpl.getInstanceImpl((Project)this.getProject()).addConfiguration(settings);
        try {
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(element));
            if (element instanceof LeafElement) {
                element = element.getParent();
            }
            CidrContextConfigurationTestCase.assertSame((Object)settings, (Object)this.createContextConfiguration(PsiTreeUtil.findChildOfType((PsiElement)element, PsiWhiteSpace.class)));
        }
        finally {
            RunManagerImpl.getInstanceImpl((Project)this.getProject()).removeConfiguration(settings);
        }
    }

    public void assertCreatingFromMultipleTestResults(String pattern, PsiElement psiElement, final SMTestLocator locator, final String ... paths) {
        SMTRunnerTestTreeView testTreeView = new SMTRunnerTestTreeView(){

            public TreePath @Nullable [] getSelectionPaths() {
                TreePath[] res = new TreePath[paths.length];
                for (int i2 = 0; i2 < res.length; ++i2) {
                    res[i2] = new TreePath(i2);
                }
                return res;
            }

            @NotNull
            public SMTestProxy getSelectedTest(@NotNull TreePath selectionPath) {
                Integer i2 = (Integer)selectionPath.getLastPathComponent();
                SMTestProxy test = new SMTestProxy("test" + i2, false, paths[i2]);
                test.setLocator(locator);
                return test;
            }
        };
        SimpleDataContext.Builder contextBuilder = SimpleDataContext.builder().add(SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW, (Object)testTreeView);
        CidrTestRunConfiguration config = (CidrTestRunConfiguration)this.createContextConfiguration(psiElement, contextBuilder).getConfiguration();
        CidrContextConfigurationTestCase.assertEquals((Object)CidrTestRunConfigurationData.Mode.PATTERN, (Object)config.getTestData().getTestMode());
        CidrContextConfigurationTestCase.assertEquals((String)pattern, (String)config.getTestData().getTestPattern());
    }

    protected static void assertTargetForRunConfiguration(@NotNull CidrRunConfiguration configuration, @Nullable String expectedTargetName) {
        BuildTargetAndConfigurationData buildConfig = configuration.getTargetAndConfigurationData();
        CidrContextConfigurationTestCase.assertNotNull((Object)buildConfig);
        CidrContextConfigurationTestCase.assertEquals((String)expectedTargetName, (String)buildConfig.target.targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isCanceledWhileProcessed(boolean needFastRespond, boolean areSymbolsLoaded, @NotNull Computable<Void> computable) {
        Boolean symbolsLoadedInTests = FileSymbolTablesCache.getForceSymbolsLoadedInTests();
        EmptyProgressIndicator progress = new EmptyProgressIndicator();
        try {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)areSymbolsLoaded);
            Supplier<Void> producer = () -> CidrContextConfigurationTestCase.lambda$isCanceledWhileProcessed$0(computable, (ProgressIndicator)progress);
            if (needFastRespond) {
                OCTestExecution.executeWithCachedValuesFast(producer);
            } else {
                OCTestExecution.executeWithRealValuesSlow(producer);
            }
        }
        finally {
            FileSymbolTablesCache.forceSymbolsLoadedInTests((Boolean)symbolsLoadedInTests);
        }
        return progress.isCanceled();
    }

    public static void checkConfig(@NotNull CidrTestRunConfiguration config, @Nullable String expectedPattern, @Nullable String expectedSuite, @Nullable String expectedTest, @NotNull CidrTestRunConfigurationData.Mode expectedMode, @NotNull String expectedConfName) {
        CidrContextConfigurationTestCase.assertEquals((String)expectedPattern, (String)config.getTestData().getTestPattern());
        CidrContextConfigurationTestCase.assertEquals((String)expectedSuite, (String)config.getTestData().getTestSuite());
        CidrContextConfigurationTestCase.assertEquals((String)expectedTest, (String)config.getTestData().getTestName());
        CidrContextConfigurationTestCase.assertEquals((Object)expectedMode, (Object)config.getTestData().getTestMode());
        CidrContextConfigurationTestCase.assertEquals((String)expectedConfName, (String)config.getName());
    }

    @NotNull
    public PROJECT_FIXTURE getProjectFixture() {
        return (PROJECT_FIXTURE)this.myProjectFixture;
    }

    public RunnerAndConfigurationSettings createContextConfiguration(PsiElement element) {
        return this.createContextConfiguration(element, null);
    }

    public abstract RunnerAndConfigurationSettings createContextConfiguration(PsiElement var1, @Nullable SimpleDataContext.Builder var2);

    private static /* synthetic */ Void lambda$isCanceledWhileProcessed$0(Computable computable, ProgressIndicator progress) {
        return (Void)ProgressManager.getInstance().runProcess(computable, progress);
    }
}

