/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrRefactoringFixture;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.lang.reflect.Field;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.jetbrains.annotations.NotNull;

public class CidrFormattingFixture {
    CidrCodeInsightFixture myCodeInsightFixture;
    private boolean smartIndentOnEnter;
    private int reformatOnPaste;

    public CidrFormattingFixture(@NotNull CidrCodeInsightFixture codeInsightFixture) {
        this.myCodeInsightFixture = codeInsightFixture;
    }

    public static void clearFields(Class c, Object o) throws IllegalAccessException {
        for (Field each : c.getDeclaredFields()) {
            each.setAccessible(true);
            Class<?> type = each.getType();
            if ((each.getModifiers() & 8) != 0) continue;
            if (type == Integer.TYPE) {
                String name = each.getName();
                each.setInt(o, name.endsWith("BRACE_STYLE") || name.endsWith("BRACE_PLACEMENT") ? 1 : 0);
            }
            if (type != Boolean.TYPE) continue;
            each.setBoolean(o, false);
        }
    }

    public void setUp() throws Exception {
        this.initOCFormatterSettings();
        this.smartIndentOnEnter = CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER;
        CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER = true;
        this.reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE;
        CodeInsightSettings.getInstance().REFORMAT_ON_PASTE = 3;
    }

    public void tearDown() {
        this.myCodeInsightFixture.getCodeStyleSettings().clearCodeStyleSettings();
        CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER = this.smartIndentOnEnter;
        CodeInsightSettings.getInstance().REFORMAT_ON_PASTE = this.reformatOnPaste;
    }

    public void initOCFormatterSettings() throws Exception {
        CidrFormattingFixture.initOCFormatterSettings(this.myCodeInsightFixture);
    }

    public static void initOCFormatterSettings(CidrCodeInsightFixture insightFixture) throws Exception {
        CodeStyleSettings rs = insightFixture.getCodeStyleSettings();
        CommonCodeStyleSettings cs = insightFixture.getOCCommonSettings();
        OCCodeStyleSettings ocs = insightFixture.getOCSettings();
        CommonCodeStyleSettings.IndentOptions indentOptions = insightFixture.getOCCommonSettings().getIndentOptions();
        assert (indentOptions != null);
        CidrFormattingFixture.clearFields(CodeStyleSettings.class, rs);
        CidrFormattingFixture.clearFields(CommonCodeStyleSettings.class, cs);
        CidrFormattingFixture.clearFields(OCCodeStyleSettings.class, ocs);
        CidrFormattingFixture.clearFields(CommonCodeStyleSettings.IndentOptions.class, indentOptions);
        rs.setDefaultRightMargin(200);
        cs.RIGHT_MARGIN = -1;
        ocs.INDENT_CLASS_MEMBERS = 4;
        ocs.INDENT_C_STRUCT_MEMBERS = 4;
        ocs.INDENT_INSIDE_CODE_BLOCK = 4;
        indentOptions.INDENT_SIZE = 4;
        indentOptions.CONTINUATION_INDENT_SIZE = 8;
        indentOptions.TAB_SIZE = 4;
    }

    public void keepAllStatementsInline() {
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_CLASSES_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCCommonSettings().KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCSettings().KEEP_NESTED_NAMESPACES_IN_ONE_LINE = true;
        this.myCodeInsightFixture.getOCSettings().KEEP_STRUCTURES_IN_ONE_LINE = true;
    }

    public void wrapBodyIntoBraces() {
        this.myCodeInsightFixture.getOCCommonSettings().FOR_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().WHILE_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().DOWHILE_BRACE_FORCE = 3;
        this.myCodeInsightFixture.getOCCommonSettings().IF_BRACE_FORCE = 3;
    }

    public void assertFormatAfterRenameOC(String before, String newName, String after2) {
        this.myCodeInsightFixture.configureByTextOC(StringGroovyMethods.stripMargin((CharSequence)before));
        CidrRefactoringFixture.performRename(this.myCodeInsightFixture.getEditor(), newName);
        this.myCodeInsightFixture.checkResult(StringGroovyMethods.stripMargin((CharSequence)after2));
    }

    public void assertFormatAfterIntroduceVarOC(String before, String after2) {
        this.assertFormattingAfterIntroduceVar(before, after2, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertFormatAfterIntroduceVarCpp(String before, String after2) {
        this.assertFormattingAfterIntroduceVar(before, after2, (OCLanguageKind)CLanguageKind.CPP);
    }

    private void assertFormattingAfterIntroduceVar(String before, String after2, OCLanguageKind language) {
        this.myCodeInsightFixture.configureByText(StringGroovyMethods.stripMargin((CharSequence)before), language);
        this.invoke(CidrRefactoringFixture.getActionFromRefactoringActionHandler(CidrRefactoringFixture.ourVariableIntroducer));
        this.myCodeInsightFixture.checkResult(StringGroovyMethods.stripMargin((CharSequence)after2));
    }

    private void invoke(LanguageCodeInsightActionHandler handler) {
        handler.invoke(this.myCodeInsightFixture.getProject(), this.myCodeInsightFixture.getEditor(), this.myCodeInsightFixture.getFile());
    }

    public void assertFormatAfterIntroduceParamOC(String before, String after2) {
        this.myCodeInsightFixture.configureByTextOC(StringGroovyMethods.stripMargin((CharSequence)before));
        this.invoke(CidrRefactoringFixture.getActionFromRefactoringActionHandler(CidrRefactoringFixture.ourParamIntroducer));
        this.myCodeInsightFixture.checkResult(StringGroovyMethods.stripMargin((CharSequence)after2));
    }

    public void assertFormatAfterCompletionOC(String before, String after2) {
        this.myCodeInsightFixture.configureByTextOC(StringGroovyMethods.stripMargin((CharSequence)before));
        this.myCodeInsightFixture.complete(CompletionType.SMART, 1);
        this.myCodeInsightFixture.checkResult(StringGroovyMethods.stripMargin((CharSequence)after2));
    }

    public void assertFormatAfterExtractMethodOC(String before, String after2) {
        this.assertFormatAfterExtractMethod(before, after2, (OCLanguageKind)CLanguageKind.OBJ_C);
    }

    public void assertFormatAfterExtractMethodCpp(String before, String after2) {
        this.assertFormatAfterExtractMethod(before, after2, (OCLanguageKind)CLanguageKind.CPP);
    }

    public void assertFormatAfterExtractMethod(String before, String after2, OCLanguageKind languageKind) {
        this.myCodeInsightFixture.configureByText(StringGroovyMethods.stripMargin((CharSequence)before), languageKind);
        CidrRefactoringFixture.ourExtractMethodHandler.invoke(this.myCodeInsightFixture.getProject(), this.myCodeInsightFixture.getEditor(), (PsiFile)this.myCodeInsightFixture.getOCFile(), ((EditorEx)this.myCodeInsightFixture.getEditor()).getDataContext());
        this.myCodeInsightFixture.checkResult(StringGroovyMethods.stripMargin((CharSequence)after2));
    }
}

