/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.impl.DirectorySpecBase;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/util/io/impl/ZipSpec;", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "level", "", "(I)V", "getLevel", "()I", "generate", "", "target", "Ljava/io/File;", "generateInTempDir", "Ljava/nio/file/Path;", "intellij.platform.testFramework"})
public final class ZipSpec
extends DirectorySpecBase {
    private final int level;

    public ZipSpec(int level) {
        super(null, null);
        this.level = level;
    }

    public /* synthetic */ ZipSpec(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        this(n);
    }

    public final int getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull File target) {
        File contentDir = FileUtil.createTempDirectory((String)"zip-content", null, (boolean)false);
        try {
            this.generateInDirectory(contentDir);
            FileUtil.createParentDirs((File)target);
            Closeable closeable = (Closeable)new Compressor.Zip(target).withLevel(this.level);
            Throwable throwable = null;
            try {
                Compressor.Zip it = (Compressor.Zip)closeable;
                boolean bl = false;
                it.addDirectory(contentDir);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            FileUtil.delete((File)contentDir);
        }
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File target = FileUtil.createTempFile((String)"zip-by-spec", (String)".zip", (boolean)true);
        this.generate(target);
        return target.toPath();
    }

    public ZipSpec() {
        this(0, 1, null);
    }
}

