/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/io/impl/DirectorySpecBase;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "originalFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "children", "Ljava/util/LinkedHashMap;", "", "getChildren", "()Ljava/util/LinkedHashMap;", "getOriginalFile", "()Ljava/nio/file/Path;", "addChild", "", "name", "spec", "generateInDirectory", "target", "Ljava/io/File;", "generateInTempDir", "", "mergeWith", "other", "Lcom/intellij/util/io/DirectoryContentSpec;", "Lcom/intellij/util/io/impl/DirectorySpec;", "Lcom/intellij/util/io/impl/ZipSpec;", "intellij.platform.testFramework"})
public abstract class DirectorySpecBase
extends DirectoryContentSpecImpl {
    @Nullable
    private final Path originalFile;
    @NotNull
    private final LinkedHashMap<String, DirectoryContentSpecImpl> children;

    private DirectorySpecBase(Path originalFile) {
        super(null);
        this.originalFile = originalFile;
        this.children = new LinkedHashMap();
    }

    @Override
    @Nullable
    public Path getOriginalFile() {
        return this.originalFile;
    }

    @NotNull
    protected final LinkedHashMap<String, DirectoryContentSpecImpl> getChildren() {
        return this.children;
    }

    public final void addChild(@NotNull String name, @NotNull DirectoryContentSpecImpl spec) {
        if (((Map)this.children).containsKey(name)) {
            DirectoryContentSpecImpl existing = this.children.get(name);
            if (spec instanceof DirectorySpecBase && existing instanceof DirectorySpecBase) {
                ((Map)((DirectorySpecBase)existing).children).putAll((Map)((DirectorySpecBase)spec).children);
                return;
            }
            throw new IllegalArgumentException("'" + name + "' already exists");
        }
        ((Map)this.children).put(name, spec);
    }

    protected final void generateInDirectory(@NotNull File target) {
        for (Map.Entry entry : ((Map)this.children).entrySet()) {
            String name = (String)entry.getKey();
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)entry.getValue();
            child.generate(new File(target, name));
        }
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File target = FileUtil.createTempDirectory((String)"directory-by-spec", null, (boolean)true);
        this.generate(target);
        return target.toPath();
    }

    @NotNull
    public final Map<String, DirectoryContentSpecImpl> getChildren() {
        return Collections.unmodifiableMap((Map)this.children);
    }

    @Override
    @NotNull
    public DirectoryContentSpecImpl mergeWith(@NotNull DirectoryContentSpec other) {
        DirectorySpecBase directorySpecBase;
        if (!Intrinsics.areEqual(other.getClass(), this.getClass())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.util.io.impl.DirectorySpecBase");
        DirectorySpecBase cfr_ignored_0 = (DirectorySpecBase)other;
        DirectorySpecBase directorySpecBase2 = (DirectorySpecBase)other;
        if (directorySpecBase2 instanceof DirectorySpec) {
            directorySpecBase = new DirectorySpec(null, 1, null);
        } else if (directorySpecBase2 instanceof ZipSpec) {
            directorySpecBase = new ZipSpec(0, 1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DirectorySpecBase result2 = directorySpecBase;
        result2.children.putAll((Map<String, DirectoryContentSpecImpl>)this.children);
        for (Map.Entry entry : ((Map)((DirectorySpecBase)other).children).entrySet()) {
            String name = (String)entry.getKey();
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)entry.getValue();
            DirectoryContentSpecImpl oldChild = this.children.get(name);
            Map map = result2.children;
            DirectoryContentSpecImpl directoryContentSpecImpl = oldChild;
            if (directoryContentSpecImpl == null || (directoryContentSpecImpl = directoryContentSpecImpl.mergeWith(child)) == null) {
                directoryContentSpecImpl = child;
            }
            DirectoryContentSpecImpl directoryContentSpecImpl2 = directoryContentSpecImpl;
            map.put(name, directoryContentSpecImpl2);
        }
        return result2;
    }

    public /* synthetic */ DirectorySpecBase(Path originalFile, DefaultConstructorMarker $constructor_marker) {
        this(originalFile);
    }
}

