/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.TestFileSystemItem;
import org.jetbrains.annotations.NotNull;

public final class TestFileSystemBuilder {
    private final TestFileSystemItem myItem;
    private final TestFileSystemBuilder myParent;

    private TestFileSystemBuilder(TestFileSystemItem item, TestFileSystemBuilder parent) {
        this.myItem = item;
        this.myParent = parent;
    }

    @NotNull
    public TestFileSystemItem build() {
        TestFileSystemBuilder builder = this;
        while (builder.myParent != null) {
            builder = builder.myParent;
        }
        return builder.myItem;
    }

    @NotNull
    public TestFileSystemBuilder dir(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, false, true);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    @NotNull
    public TestFileSystemBuilder archive(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, true, false);
        this.myItem.addChild(item);
        return new TestFileSystemBuilder(item, this);
    }

    @NotNull
    public TestFileSystemBuilder file(String name) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false));
        return this;
    }

    @NotNull
    public TestFileSystemBuilder file(String name, String content) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false, content));
        return this;
    }

    public TestFileSystemBuilder end() {
        return this.myParent;
    }

    @NotNull
    public static TestFileSystemBuilder fs() {
        return new TestFileSystemBuilder(new TestFileSystemItem("root", false, true), null);
    }
}

