/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.nio.charset.MalformedInputException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001aB\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a,\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a&\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a0\u0010\u0007\u001a\u00020\f*\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a8\u0006\u0014"}, d2={"appendIndentString", "", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDirectoryTree", "dir", "Ljava/nio/file/Path;", "excluded", "", "", "printContent", "", "printRootName", "printFile", "file", "sortedFileList", "", "intellij.platform.testFramework"})
public final class FileTreePrinterKt {
    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent, boolean printRootName) {
        StringBuilder sb = new StringBuilder();
        FileTreePrinterKt.getDirectoryTree($this$getDirectoryTree, 0, sb, excluded, printContent, printRootName);
        return sb.toString();
    }

    public static /* synthetic */ String getDirectoryTree$default(Path path, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return FileTreePrinterKt.getDirectoryTree(path, set, bl, bl2);
    }

    private static final void getDirectoryTree(Path dir, int indent, StringBuilder sb, Set<String> excluded, boolean printContent, boolean printRootName) {
        List list = UtilKt.nullize(FileTreePrinterKt.sortedFileList(dir, excluded));
        if (list == null) {
            return;
        }
        List fileList = list;
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        if (printRootName) {
            sb.append(((Object)dir.getFileName()).toString());
        }
        sb.append("/");
        sb.append("\n");
        for (Path file2 : fileList) {
            if (PathKt.isDirectory((Path)file2)) {
                FileTreePrinterKt.getDirectoryTree(file2, indent + 1, sb, excluded, printContent, printRootName);
                continue;
            }
            FileTreePrinterKt.printFile(file2, indent + 1, sb, printContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Path> sortedFileList(Path dir, Set<String> excluded) {
        List list;
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)closeable;
                boolean bl = false;
                Sequence sequence = CollectionsKt.asSequence((Iterable)stream);
                if (!((Collection)excluded).isEmpty()) {
                    sequence = SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<Path, Boolean>(excluded){
                        final /* synthetic */ Set<String> $excluded;
                        {
                            this.$excluded = $excluded;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(Path it) {
                            return !this.$excluded.contains(((Object)it.getFileName()).toString());
                        }
                    }));
                }
                List list2 = SequencesKt.toMutableList((Sequence)sequence);
                CollectionsKt.sort((List)list2);
                List list3 = list2;
                list = list3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            list = null;
        }
        return list;
    }

    private static final void printFile(Path file2, int indent, StringBuilder sb, boolean printContent) {
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        String fileName = ((Object)file2.getFileName()).toString();
        sb.append(fileName);
        sb.append("\n");
        if (printContent && !StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
            try {
                sb.append(PathKt.readChars((Path)file2)).append("\n\n");
            }
            catch (MalformedInputException malformedInputException) {
                // empty catch block
            }
        }
    }

    private static final void appendIndentString(int indent, StringBuilder sb) {
        for (int i2 = 0; i2 < indent; ++i2) {
            sb.append("  ");
        }
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, printContent, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, false, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree) {
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, null, false, false, 7, null);
    }
}

