/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.util.Predicates;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class TreeTestUtil {
    private final JTree tree;
    private boolean selection;
    private TreeVisitor visitor = path -> TreeVisitor.Action.CONTINUE;
    private Predicate<? super TreePath> filter = Predicates.alwaysTrue();
    private Function<Object, String> converter = node2 -> PlatformTestUtil.toString(node2, null);

    public TreeTestUtil(@NotNull JTree tree) {
        TreeTestUtil.assertTreeUI(tree);
        this.tree = tree;
    }

    public TreeTestUtil withSelection() {
        return this.setSelection(true);
    }

    public TreeTestUtil setSelection(boolean selection) {
        this.selection = selection;
        return this;
    }

    public TreeTestUtil setVisitor(@NotNull TreeVisitor visitor) {
        this.visitor = visitor;
        return this;
    }

    public TreeTestUtil setFilter(@NotNull Predicate<? super TreePath> filter) {
        this.filter = filter;
        return this;
    }

    public TreeTestUtil setConverter(@NotNull Function<Object, String> converter) {
        this.converter = converter;
        return this;
    }

    public TreeTestUtil expandAll() {
        PlatformTestUtil.expandAll(this.tree);
        return this;
    }

    public void assertStructure(@NonNls String expected) {
        PlatformTestUtil.waitWhileBusy(this.tree);
        Assert.assertEquals((Object)expected, (Object)this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeUtil.visitVisibleRows((JTree)this.tree, path -> {
            TreeVisitor.Action action = this.visitor.visit(path);
            if (this.filter.test(path)) {
                boolean selected;
                int count = path.getPathCount();
                for (int i2 = 1; i2 < count; ++i2) {
                    sb.append(' ');
                }
                Object component = path.getLastPathComponent();
                if (!this.tree.getModel().isLeaf(component)) {
                    sb.append(this.tree.isExpanded(path) ? (char)'-' : (char)'+');
                }
                boolean bl = selected = this.selection && this.tree.isPathSelected(path);
                if (selected) {
                    sb.append('[');
                }
                sb.append(this.converter.apply(TreeUtil.getUserObject((Object)component)));
                if (selected) {
                    sb.append(']');
                }
                sb.append('\n');
            }
            return action;
        });
        return sb.toString();
    }

    @NotNull
    public static DefaultMutableTreeNode node(@NotNull Object object, Object ... children) {
        if (object instanceof DefaultMutableTreeNode && ArrayUtil.isEmpty((Object[])children)) {
            return (DefaultMutableTreeNode)object;
        }
        if (object instanceof TreeNode) {
            throw new IllegalArgumentException("do not use a tree node as a node content");
        }
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(object);
        for (Object child : children) {
            node2.add(TreeTestUtil.node(child, new Object[0]));
        }
        return node2;
    }

    public static void assertTreeUI(@NotNull JTree tree) {
        Assert.assertTrue((boolean)(tree.getUI() instanceof BasicTreeUI));
    }
}

