/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ChooserInterceptor
extends UiInterceptors.UiInterceptor<JBPopup> {
    final List<String> myOptions;
    final Pattern myToSelect;

    public ChooserInterceptor(@Nullable List<String> expectedOptions, @NotNull @RegExp String pattern) {
        super(JBPopup.class);
        this.myOptions = expectedOptions;
        this.myToSelect = Pattern.compile(pattern);
    }

    protected void doIntercept(@NotNull JBPopup popup) {
        List matched;
        JBList content;
        JBList jBList = content = popup.isDisposed() ? null : (JBList)UIUtil.findComponentOfType((JComponent)popup.getContent(), JBList.class);
        if (content == null) {
            Assert.fail((String)("JBList not found under " + popup.getContent()));
        }
        ListModel model = content.getModel();
        List actualOptions = IntStream.range(0, model.getSize()).mapToObj(model::getElementAt).map(Object::toString).collect(Collectors.toList());
        if (this.myOptions != null) {
            Assert.assertEquals(this.myOptions, actualOptions);
        }
        if ((matched = ContainerUtil.filter(actualOptions, opt -> this.myToSelect.matcher((CharSequence)opt).matches())).isEmpty()) {
            Assert.fail((String)("No option matches pattern " + this.myToSelect + " (available options: " + String.join((CharSequence)", ", actualOptions) + ")"));
        }
        if (matched.size() > 1) {
            Assert.fail((String)("Several options matched: " + matched + " (pattern: " + this.myToSelect + ")"));
        }
        content.setSelectedIndex(actualOptions.indexOf(matched.get(0)));
        Assert.assertTrue((boolean)popup.canClose());
        popup.closeOk(null);
    }

    public String toString() {
        return "Popup Chooser where '" + this.myToSelect + "' should be selected";
    }
}

