/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsSinkImpl;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\f\u001a\u0002H\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ7\u0010\u0010\u001a\u00020\b\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\f\u001a\u0002H\u0005H\u0004\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "doTestProvider", "", "T", "", "fileName", "", "expectedText", "provider", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "settings", "verifyHintPresence", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;Z)V", "dumpInlayHints", "sourceText", "(Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;)Ljava/lang/String;", "Companion", "HintPresence", "InlayData", "InlayType", "intellij.platform.testFramework"})
public abstract class InlayHintsProviderTestCase
extends BasePlatformTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NO_HINTS_PREFIX = "// NO_HINTS";

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings, boolean verifyHintPresence) {
        String sourceText = InlayData.Companion.getPattern().matcher(expectedText).replaceAll("");
        this.myFixture.configureByText(fileName, sourceText);
        String actualText = this.dumpInlayHints(sourceText, provider, settings);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
        if (verifyHintPresence) {
            boolean bl;
            block2: {
                Sequence $this$any$iv = StringsKt.lineSequence((CharSequence)expectedText);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)NO_HINTS_PREFIX, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            HintPresence expectedHintPresence = bl ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            HintPresence actualHintPresence = UtilKt.isEmpty(InlayData.Companion.getPattern().matcher(expectedText).results()) ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            BasePlatformTestCase.assertEquals((String)"Hint presence should match the use of the // NO_HINTS directive.", (Object)((Object)expectedHintPresence), (Object)((Object)actualHintPresence));
        }
    }

    public static /* synthetic */ void doTestProvider$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        inlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, object, bl);
    }

    @NotNull
    protected final <T> String dumpInlayHints(@NotNull String sourceText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        StringBuilder stringBuilder;
        Inlay it;
        Collection collection;
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Editor editor = this.myFixture.getEditor();
        InlayHintsSinkImpl sink = new InlayHintsSinkImpl(editor);
        InlayHintsCollector inlayHintsCollector = provider.getCollectorFor(file2, editor, settings, (InlayHintsSink)sink);
        if (inlayHintsCollector == null) {
            throw new IllegalStateException("Collector is expected".toString());
        }
        InlayHintsCollector collector = inlayHintsCollector;
        CollectorWithSettings collectorWithSettings = new CollectorWithSettings(collector, provider.getKey(), file2.getLanguage(), sink);
        collectorWithSettings.collectTraversingAndApply(editor, file2, true);
        InlayModel model = editor.getInlayModel();
        TextRange range = file2.getTextRange();
        List inlineElements = model.getInlineElementsInRange(range.getStartOffset(), range.getEndOffset());
        List afterLineElements = model.getAfterLineEndElementsInRange(range.getStartOffset(), range.getEndOffset());
        List blockElements = model.getBlockElementsInRange(range.getStartOffset(), range.getEndOffset());
        List inlays = new ArrayList();
        Iterable $this$mapTo$iv = inlineElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Inlay inlay = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new InlayData(it, InlayType.Inline));
        }
        $this$mapTo$iv = afterLineElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new InlayData(it, InlayType.Inline));
        }
        $this$mapTo$iv = blockElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl = false;
            collection.add(new InlayData(it, InlayType.Block));
        }
        Document document = this.myFixture.getDocument(file2);
        List $this$sortBy$iv = inlays;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(document){
                final /* synthetic */ Document $document$inlined;
                {
                    this.$document$inlined = document;
                }

                public final int compare(T a, T b) {
                    InlayData it = (InlayData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.effectiveOffset(this.$document$inlined));
                    it = (InlayData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.effectiveOffset(this.$document$inlined)));
                }
            });
        }
        StringBuilder $this$dumpInlayHints_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int currentOffset = 0;
        for (InlayData inlay : inlays) {
            int nextOffset = inlay.effectiveOffset(document);
            $this$dumpInlayHints_u24lambda_u245.append(sourceText.subSequence(currentOffset, nextOffset));
            $this$dumpInlayHints_u24lambda_u245.append(inlay);
            currentOffset = nextOffset;
        }
        String string = sourceText.substring(currentOffset, sourceText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$dumpInlayHints_u24lambda_u245.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String dumpInlayHints$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, InlayHintsProvider inlayHintsProvider, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dumpInlayHints");
        }
        if ((n & 4) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        return inlayHintsProviderTestCase.dumpInlayHints(string, inlayHintsProvider, object);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, settings, false, 16, null);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider) {
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, null, false, 24, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion;", "", "()V", "NO_HINTS_PREFIX", "", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$HintPresence;", "", "(Ljava/lang/String;I)V", "NO_HINTS", "SOME_HINTS", "intellij.platform.testFramework"})
    private static final class HintPresence
    extends Enum<HintPresence> {
        public static final /* enum */ HintPresence NO_HINTS = new HintPresence();
        public static final /* enum */ HintPresence SOME_HINTS = new HintPresence();
        private static final /* synthetic */ HintPresence[] $VALUES;

        public static HintPresence[] values() {
            return (HintPresence[])$VALUES.clone();
        }

        public static HintPresence valueOf(String value) {
            return Enum.valueOf(HintPresence.class, value);
        }

        static {
            $VALUES = hintPresenceArray = new HintPresence[]{HintPresence.NO_HINTS, HintPresence.SOME_HINTS};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayData;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "type", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getType", "()Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "component1", "component2", "copy", "effectiveOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.platform.testFramework"})
    private static final class InlayData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Inlay<?> inlay;
        @NotNull
        private final InlayType type;
        @NotNull
        private static final Pattern pattern = Pattern.compile("<# block ([^#]*)#>(\r\n|\r|\n)|<#([^#]*)#>");

        public InlayData(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            this.inlay = inlay;
            this.type = type;
        }

        @NotNull
        public final Inlay<?> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final InlayType getType() {
            return this.type;
        }

        public final int effectiveOffset(@NotNull Document document) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> this.inlay.getOffset();
                case 2 -> {
                    int offset = this.inlay.getOffset();
                    int lineNumber = document.getLineNumber(offset);
                    yield document.getLineStartOffset(lineNumber);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            EditorCustomElementRenderer renderer = this.inlay.getRenderer();
            if (!(renderer instanceof PresentationRenderer) && !(renderer instanceof LinearOrderInlayRenderer)) {
                throw new IllegalStateException("renderer not supported".toString());
            }
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u240.append("<# ");
            if (this.type == InlayType.Block) {
                $this$toString_u24lambda_u240.append("block ");
            }
            $this$toString_u24lambda_u240.append(renderer.toString());
            $this$toString_u24lambda_u240.append(" #>");
            if (this.type == InlayType.Block) {
                $this$toString_u24lambda_u240.append('\n');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final Inlay<?> component1() {
            return this.inlay;
        }

        @NotNull
        public final InlayType component2() {
            return this.type;
        }

        @NotNull
        public final InlayData copy(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            return new InlayData(inlay, type);
        }

        public static /* synthetic */ InlayData copy$default(InlayData inlayData, Inlay inlay, InlayType inlayType, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = inlayData.inlay;
            }
            if ((n & 2) != 0) {
                inlayType = inlayData.type;
            }
            return inlayData.copy(inlay, inlayType);
        }

        public int hashCode() {
            int result2 = this.inlay.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlayData)) {
                return false;
            }
            InlayData inlayData = (InlayData)other;
            if (!Intrinsics.areEqual(this.inlay, inlayData.inlay)) {
                return false;
            }
            return this.type == inlayData.type;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayData$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Pattern getPattern() {
                return pattern;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[InlayType.values().length];
                try {
                    nArray[InlayType.Inline.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[InlayType.Block.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "", "(Ljava/lang/String;I)V", "Inline", "Block", "intellij.platform.testFramework"})
    protected static final class InlayType
    extends Enum<InlayType> {
        public static final /* enum */ InlayType Inline = new InlayType();
        public static final /* enum */ InlayType Block = new InlayType();
        private static final /* synthetic */ InlayType[] $VALUES;

        public static InlayType[] values() {
            return (InlayType[])$VALUES.clone();
        }

        public static InlayType valueOf(String value) {
            return Enum.valueOf(InlayType.class, value);
        }

        static {
            $VALUES = inlayTypeArray = new InlayType[]{InlayType.Inline, InlayType.Block};
        }
    }
}

