/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.testFramework.utils.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0010\u001a\u00020\u00112\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\n0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J>\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\n0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010\u001e\u001a\u00020\u0011J\u0006\u0010\u001f\u001a\u00020\u0011J\u0016\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\nJH\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\n2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\n0\u00062\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker;", "", "myFixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "inlayFilter", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Inlay;", "", "inlayPresenter", "", "manager", "Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "kotlin.jvm.PlatformType", "getManager", "()Lcom/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager;", "checkInlays", "", "checkParameterHints", "extractInlaysAndCaretInfo", "Lcom/intellij/testFramework/utils/inlays/CaretAndInlaysInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "getActualInlays", "", "Lcom/intellij/testFramework/utils/inlays/InlayInfo;", "removeText", "realStartOffset", "", "matchedLength", "setUp", "tearDown", "verifyInlaysAndCaretInfo", "expectedInlaysAndCaret", "originalText", "Companion", "intellij.platform.testFramework"})
public final class InlayHintsChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeInsightTestFixture myFixture;
    private final ParameterHintsPresentationManager manager;
    @NotNull
    private final Function1<Inlay<?>, String> inlayPresenter;
    @NotNull
    private final Function1<Inlay<?>, Boolean> inlayFilter;
    @NotNull
    private static final Pattern pattern = Pattern.compile("(<caret>)|(<selection>)|(</selection>)|<(hint|HINT|Hint|hINT)\\s+text=\"([^\n\r]+?(?=\"\\s*/>))\"\\s*/>");
    @NotNull
    private static final ParameterNameHintsSettings default = new ParameterNameHintsSettings();

    public InlayHintsChecker(@NotNull CodeInsightTestFixture myFixture) {
        this.myFixture = myFixture;
        this.manager = ParameterHintsPresentationManager.getInstance();
        this.inlayPresenter = inlayPresenter.1.INSTANCE;
        this.inlayFilter = new Function1<Inlay<?>, Boolean>(this){
            final /* synthetic */ InlayHintsChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Inlay<?> it) {
                return this.this$0.getManager().isParameterHint(it);
            }
        };
    }

    public final void setUp() {
    }

    public final void tearDown() {
        ParameterNameHintsSettings hintSettings = ParameterNameHintsSettings.Companion.getInstance();
        hintSettings.loadState(default.getState());
    }

    public final ParameterHintsPresentationManager getManager() {
        return this.manager;
    }

    public final void checkParameterHints() {
        this.checkInlays(this.inlayPresenter, this.inlayFilter);
    }

    public final void checkInlays(@NotNull Function1<? super Inlay<?>, String> inlayPresenter2, @NotNull Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        Document document = this.myFixture.getDocument(file2);
        String originalText = document.getText();
        CaretAndInlaysInfo expectedInlaysAndCaret = this.extractInlaysAndCaretInfo(document);
        this.myFixture.doHighlighting();
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, inlayPresenter2, inlayFilter2);
    }

    public final void verifyInlaysAndCaretInfo(@NotNull CaretAndInlaysInfo expectedInlaysAndCaret, @NotNull String originalText) {
        this.verifyInlaysAndCaretInfo(expectedInlaysAndCaret, originalText, this.inlayPresenter, this.inlayFilter);
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyInlaysAndCaretInfo(CaretAndInlaysInfo expectedInlaysAndCaret, String originalText, Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        block17: {
            List<InlayInfo> actual;
            Document document;
            PsiFile file2;
            block16: {
                boolean bl;
                block14: {
                    PsiFile psiFile = this.myFixture.getFile();
                    Intrinsics.checkNotNull((Object)psiFile);
                    file2 = psiFile;
                    document = this.myFixture.getDocument(file2);
                    actual = this.getActualInlays(inlayPresenter2, inlayFilter2);
                    List<InlayInfo> expected = expectedInlaysAndCaret.getInlays();
                    if (expectedInlaysAndCaret.getInlays().size() != actual.size()) break block16;
                    Iterable $this$any$iv = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Iterator element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block17;
            }
            List entries = new ArrayList();
            Iterable $this$forEach$iv = actual;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                void $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241;
                InlayInfo it = (InlayInfo)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = stringBuilder;
                Integer n = it.getOffset();
                List list = entries;
                boolean bl3 = false;
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append("<");
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append(it.getHighlighted() ? "H" : "h");
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append(it.getCurrent() ? "INT" : "int");
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append(" text=\"");
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append(it.getText());
                $this$verifyInlaysAndCaretInfo_u24lambda_u242_u24lambda_u241.append("\"/>");
                Unit unit = Unit.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
                Integer n2 = n;
                list.add(new Pair((Object)n2, (Object)string));
            }
            if (expectedInlaysAndCaret.getCaretOffset() != null) {
                int n;
                int actualInlaysBeforeCaret;
                int actualCaretOffset;
                block15: {
                    actualCaretOffset = this.myFixture.getEditor().getCaretModel().getOffset();
                    actualInlaysBeforeCaret = this.myFixture.getEditor().getCaretModel().getVisualPosition().column - this.myFixture.getEditor().offsetToVisualPosition((int)actualCaretOffset).column;
                    List $this$indexOfFirst$iv = entries;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        Pair it = (Pair)item$iv;
                        boolean bl = false;
                        if (((Number)it.getFirst()).intValue() == actualCaretOffset) {
                            n = index$iv;
                            break block15;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int first = n;
                int insertIndex2 = first == -1 ? -CollectionsKt.binarySearch$default((List)entries, (int)0, (int)0, (Function1)((Function1)new Function1<Pair<? extends Integer, ? extends String>, Integer>(actualCaretOffset){
                    final /* synthetic */ int $actualCaretOffset;
                    {
                        this.$actualCaretOffset = $actualCaretOffset;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull Pair<Integer, String> it) {
                        return ((Number)it.getFirst()).intValue() - this.$actualCaretOffset;
                    }
                }), (int)3, null) - 1 : first + actualInlaysBeforeCaret;
                entries.add(insertIndex2, new Pair((Object)actualCaretOffset, (Object)"<caret>"));
            }
            StringBuilder proposedText = new StringBuilder(document.getText());
            Iterable $this$forEach$iv2 = CollectionsKt.asReversedMutable((List)entries);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                proposedText.insert(((Number)it.getFirst()).intValue(), (String)it.getSecond());
            }
            String string = (String)VfsTestUtil.TEST_DATA_FILE_PATH.get((UserDataHolder)file2.getVirtualFile());
            if (string != null) {
                String originalPath = string;
                boolean bl = false;
                throw new FileComparisonFailure("Hints differ", originalText, proposedText.toString(), originalPath);
            }
            throw new ComparisonFailure("Hints differ", originalText, proposedText.toString());
        }
        if (expectedInlaysAndCaret.getCaretOffset() != null) {
            Assert.assertEquals((String)"Unexpected caret offset", (Object)expectedInlaysAndCaret.getCaretOffset(), (Object)this.myFixture.getEditor().getCaretModel().getOffset());
            VisualPosition position = this.myFixture.getEditor().offsetToVisualPosition(expectedInlaysAndCaret.getCaretOffset().intValue());
            Assert.assertEquals((String)"Unexpected caret visual position", (Object)new VisualPosition(position.line, position.column + expectedInlaysAndCaret.getInlaysBeforeCaret()), (Object)this.myFixture.getEditor().getCaretModel().getVisualPosition());
            SelectionModel selectionModel = this.myFixture.getEditor().getSelectionModel();
            if (expectedInlaysAndCaret.getSelection() == null) {
                Assert.assertFalse((boolean)selectionModel.hasSelection());
            } else {
                Assert.assertEquals((String)"Unexpected selection", (Object)expectedInlaysAndCaret.getSelection(), (Object)new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InlayInfo> getActualInlays(Function1<? super Inlay<?>, String> inlayPresenter2, Function1<? super Inlay<?>, Boolean> inlayFilter2) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Inlay it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Editor editor = this.myFixture.getEditor();
        List allInlays = CollectionsKt.plus((Collection)editor.getInlayModel().getInlineElementsInRange(0, editor.getDocument().getTextLength()), (Iterable)editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength()));
        ParameterHintsPresentationManager hintManager = ParameterHintsPresentationManager.getInstance();
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)allInlays);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)inlayFilter2.invoke((Object)it)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Inlay)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean isHighlighted = false;
            boolean isCurrent = false;
            if (hintManager.isParameterHint(it)) {
                isHighlighted = hintManager.isHighlighted(it);
                isCurrent = hintManager.isCurrent(it);
            } else {
                isHighlighted = false;
                isCurrent = false;
            }
            collection.add(new InlayInfo(it.getOffset(), (String)inlayPresenter2.invoke((Object)it), isHighlighted, isCurrent));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InlayInfo it = (InlayInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (InlayInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CaretAndInlaysInfo extractInlaysAndCaretInfo(@NotNull Document document) {
        String text = document.getText();
        Matcher matcher = pattern.matcher(text);
        List inlays = new ArrayList();
        int extractedLength = 0;
        Integer caretOffset = null;
        int inlaysBeforeCaret = 0;
        Integer selectionStart = null;
        Integer selectionEnd = null;
        while (matcher.find()) {
            int start = matcher.start();
            int matchedLength = matcher.end() - start;
            int realStartOffset = start - extractedLength;
            if (matcher.group(1) != null) {
                void $this$forEach$iv;
                Iterable $this$takeWhile$iv;
                caretOffset = realStartOffset;
                Iterable iterable = CollectionsKt.asReversedMutable((List)inlays);
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    InlayInfo it = (InlayInfo)item$iv;
                    boolean bl = false;
                    if (!(it.getOffset() == caretOffset.intValue())) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InlayInfo it = (InlayInfo)element$iv;
                    boolean bl = false;
                    ++inlaysBeforeCaret;
                }
            } else if (matcher.group(2) != null) {
                selectionStart = realStartOffset;
            } else if (matcher.group(3) != null) {
                selectionEnd = realStartOffset;
            } else {
                ((Collection)inlays).add(new InlayInfo(realStartOffset, matcher.group(5), StringsKt.startsWith$default((String)matcher.group(4), (String)"H", (boolean)false, (int)2, null), StringsKt.endsWith$default((String)matcher.group(4), (String)"INT", (boolean)false, (int)2, null)));
            }
            this.removeText(document, realStartOffset, matchedLength);
            extractedLength += matcher.end() - start;
        }
        return new CaretAndInlaysInfo(caretOffset, inlaysBeforeCaret, selectionStart == null || selectionEnd == null ? null : new TextRange(selectionStart.intValue(), selectionEnd.intValue()), inlays);
    }

    private final void removeText(Document document, int realStartOffset, int matchedLength) {
        WriteCommandAction.runWriteCommandAction((Project)this.myFixture.getProject(), () -> InlayHintsChecker.removeText$lambda$11(document, realStartOffset, matchedLength));
    }

    private static final void removeText$lambda$11(Document $document, int $realStartOffset, int $matchedLength) {
        $document.replaceString($realStartOffset, $realStartOffset + $matchedLength, (CharSequence)"");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsChecker$Companion;", "", "()V", "default", "Lcom/intellij/codeInsight/hints/settings/ParameterNameHintsSettings;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPattern() {
            return pattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

