/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.IntentionPolicy;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import com.intellij.testFramework.propertyBased.RandomActivityInterceptor;
import com.intellij.testFramework.propertyBased.RehighlightAllEditors;
import com.intellij.ui.UiInterceptors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InvokeIntention
extends ActionOnFile {
    private static final Logger LOG = Logger.getInstance(InvokeIntention.class);
    private final IntentionPolicy myPolicy;

    public InvokeIntention(@NotNull PsiFile file2, @NotNull IntentionPolicy policy) {
        super(file2);
        this.myPolicy = policy;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        int offset = this.generateDocOffset(env, null);
        env.logMessage("Go to " + MadTestingUtil.getPositionDescription(offset, this.getDocument()));
        this.doInvokeIntention(offset, env);
    }

    @Nullable
    private static IntentionAction chooseIntention(@NotNull ImperativeCommand.Environment env, List<IntentionAction> actions) {
        if (actions.isEmpty()) {
            env.logMessage("No intentions found");
            return null;
        }
        IntentionAction result2 = (IntentionAction)env.generateValue(Generator.sampledFrom(actions).noShrink(), null);
        env.logMessage("Invoke intention " + MadTestingUtil.getIntentionDescription(result2));
        return result2;
    }

    protected void doInvokeIntention(int offset, ImperativeCommand.Environment env) {
        IntentionAction intention;
        Project project2 = this.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.getVirtualFile(), offset), true);
        assert (editor != null);
        FileViewProvider viewProvider = this.getFile().getViewProvider();
        boolean containsErrorElements = MadTestingUtil.containsErrorElements(viewProvider);
        List<HighlightInfo> errors = InvokeIntention.highlightErrors(project2, editor);
        boolean hasErrors = !errors.isEmpty() || containsErrorElements;
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)this.getProject());
        assert (file2 != null);
        List<IntentionAction> intentions = this.getAvailableIntentions(editor, file2);
        PsiElement currentElement = file2.findElementAt(editor.getCaretModel().getOffset());
        if (!containsErrorElements) {
            intentions = this.wrapAndCheck(env, editor, currentElement, hasErrors, intentions);
        }
        if ((intention = InvokeIntention.chooseIntention(env, intentions)) == null) {
            return;
        }
        if (this.myPolicy.shouldCheckPreview(intention) && intention.getElementToMakeWritable(file2) == file2) {
            this.checkPreview(intention, editor);
        }
        String intentionString = intention.toString();
        boolean checkComments = this.myPolicy.checkComments(intention) && PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiComment.class, (boolean)false) == null;
        List<String> comments = checkComments ? this.extractCommentsReformattedToSingleWhitespace(file2) : Collections.emptyList();
        boolean mayBreakCode = this.myPolicy.mayBreakCode(intention, editor, file2);
        Document changedDocument = this.getDocumentToBeChanged(intention);
        String textBefore = changedDocument == null ? null : changedDocument.getText();
        Long stampBefore = changedDocument == null ? null : Long.valueOf(changedDocument.getModificationStamp());
        Runnable r = () -> CodeInsightTestFixtureImpl.invokeIntention(intention, file2, editor);
        Disposable disposable = Disposer.newDisposable();
        try {
            Pair pair;
            UiInterceptors.register((UiInterceptors.UiInterceptor)new RandomActivityInterceptor(env, disposable));
            if (containsErrorElements) {
                Registry.get((String)"ide.check.structural.psi.text.consistency.in.tests").setValue(false, disposable);
                Disposer.register((Disposable)disposable, this::restoreAfterPotentialPsiTextInconsistency);
            }
            if ((pair = ShowIntentionActionsHandler.chooseFileForAction((PsiFile)file2, (Editor)editor, (IntentionAction)intention)) != null && pair.second instanceof EditorWindow) {
                return;
            }
            if (changedDocument != null) {
                MadTestingUtil.restrictChangesToDocument(changedDocument, r);
            } else {
                r.run();
            }
            if (changedDocument != null && PsiDocumentManager.getInstance((Project)project2).isDocumentBlockedByPsi(changedDocument)) {
                throw new AssertionError((Object)"Document is left blocked by PSI");
            }
            if (!hasErrors && stampBefore != null && stampBefore.equals(changedDocument.getModificationStamp())) {
                Object message = "No change was performed in the document";
                if (intention.startInWriteAction()) {
                    message = (String)message + ".\nIf it's by design that " + intentionString + " doesn't change source files, it should return false from 'startInWriteAction'";
                }
                throw new AssertionError(message);
            }
            PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
            if (!mayBreakCode && !hasErrors) {
                InvokeIntention.checkNoNewErrors(project2, editor, intentionString, this.myPolicy);
            }
            if (checkComments) {
                List<String> fileComments = this.extractCommentsReformattedToSingleWhitespace(file2);
                for (String comment : comments) {
                    if (!fileComments.contains(comment)) {
                        throw new AssertionError((Object)("Lost comment '" + comment + "' during " + intentionString));
                    }
                }
            }
        }
        catch (Throwable error2) {
            LOG.debug("Error occurred, text before intention invocation:\n" + textBefore);
            env.logMessage("Error happened, the file's text before invoking printed to the debug log, search for 'text before intention invocation' there");
            throw error2;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private void checkPreview(IntentionAction intention, Editor editor) {
        IntentionPreviewInfo previewInfo;
        IntentionAction unwrapped = IntentionActionDelegate.unwrap((IntentionAction)intention);
        if (unwrapped instanceof SuppressIntentionAction) {
            return;
        }
        try {
            previewInfo = (IntentionPreviewInfo)ApplicationManager.getApplication().executeOnPooledThread(() -> (IntentionPreviewInfo)ReadAction.compute(() -> IntentionPreviewPopupUpdateProcessor.getPreviewInfo((Project)this.getProject(), (IntentionAction)intention, (PsiFile)this.getFile(), (Editor)editor))).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Intention action " + MadTestingUtil.getIntentionDescription(intention) + " fails during preview", e);
        }
        if (previewInfo == null || previewInfo == IntentionPreviewInfo.EMPTY || previewInfo == IntentionPreviewInfo.FALLBACK_DIFF) {
            throw new RuntimeException("Intention action " + MadTestingUtil.getIntentionDescription(intention) + " is not preview-friendly");
        }
    }

    @NotNull
    private List<IntentionAction> wrapAndCheck(ImperativeCommand.Environment env, Editor editor, PsiElement currentElement, boolean hasErrors, List<IntentionAction> intentions) {
        if (currentElement == null) {
            return intentions;
        }
        int offset = editor.getCaretModel().getOffset();
        List elementsToWrap = ContainerUtil.filter(this.myPolicy.getElementsToWrap(currentElement), e -> e.getTextRange().getStartOffset() != offset);
        if (elementsToWrap.isEmpty()) {
            return intentions;
        }
        Project project2 = this.getProject();
        Map names = intentions.stream().collect(Collectors.toMap(IntentionAction::getText, Function.identity(), (a, b) -> a));
        PsiElement elementToWrap = (PsiElement)env.generateValue(Generator.sampledFrom((List)elementsToWrap).noShrink(), null);
        String text = elementToWrap.getText();
        String prefix = this.myPolicy.getWrapPrefix();
        String suffix = this.myPolicy.getWrapSuffix();
        env.logMessage("Wrap '" + StringUtil.shortenTextWithEllipsis((String)text.replaceAll("\\s+", " "), (int)50, (int)10) + "' with '" + prefix + "..." + suffix + "' and rerun daemon");
        TextRange range = elementToWrap.getTextRange();
        PsiFile file2 = currentElement.getContainingFile();
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            this.getDocument().insertString(range.getEndOffset(), (CharSequence)suffix);
            this.getDocument().insertString(range.getStartOffset(), (CharSequence)prefix);
            editor.getCaretModel().moveToOffset(offset + prefix.length());
        });
        ArrayList<Object> messages = new ArrayList<Object>();
        boolean newContainsErrorElements = MadTestingUtil.containsErrorElements(this.getFile().getViewProvider());
        if (newContainsErrorElements) {
            messages.add("File contains parse errors after wrapping");
        } else {
            boolean newHasErrors;
            boolean bl = newHasErrors = !InvokeIntention.highlightErrors(project2, editor).isEmpty();
            if (newHasErrors != hasErrors) {
                messages.add(newHasErrors ? "File contains errors after wrapping" : "File errors were fixed after wrapping");
            }
        }
        intentions = this.getAvailableIntentions(editor, file2);
        Map namesWithParentheses = intentions.stream().collect(Collectors.toMap(IntentionAction::getText, Function.identity(), (a, b) -> a));
        HashMap<String, IntentionAction> added = new HashMap<String, IntentionAction>(namesWithParentheses);
        added.keySet().removeAll(names.keySet());
        HashMap<String, IntentionAction> removed = new HashMap<String, IntentionAction>(names);
        removed.keySet().removeAll(namesWithParentheses.keySet());
        Function<String, String> cleaner = name -> name.replace(prefix, "").replace(suffix, "");
        Iterator iterator = added.keySet().iterator();
        while (iterator.hasNext()) {
            String newName = (String)iterator.next();
            String stripped = cleaner.apply(newName);
            if (!removed.keySet().removeIf(n -> ((String)cleaner.apply((String)n)).equals(stripped))) continue;
            iterator.remove();
        }
        if (!added.isEmpty()) {
            messages.add("Intentions added after parenthesizing:\n" + InvokeIntention.describeIntentions(added));
        }
        if (!removed.isEmpty()) {
            messages.add("Intentions removed after parenthesizing:\n" + InvokeIntention.describeIntentions(removed));
        }
        if (!messages.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                this.getDocument().deleteString(range.getStartOffset(), range.getStartOffset() + prefix.length());
                this.getDocument().deleteString(range.getEndOffset(), range.getEndOffset() + suffix.length());
                editor.getCaretModel().moveToOffset(offset);
            });
            intentions = this.getAvailableIntentions(editor, file2);
            Map namesBackAgain = intentions.stream().collect(Collectors.toMap(IntentionAction::getText, Function.identity(), (a, b) -> a));
            if (!namesBackAgain.keySet().equals(names.keySet())) {
                if (namesBackAgain.keySet().equals(namesWithParentheses.keySet())) {
                    messages.add(0, "Unstable result: intentions changed after parenthesizing, but remain the same when parentheses removed");
                } else {
                    messages.add(0, "Unstable result: intentions changed after parenthesizing, but restored in a different way when parentheses removed");
                }
            }
            LOG.debug("Error occurred, file text before adding parentheses:\n" + file2.getText());
            throw new AssertionError((Object)String.join((CharSequence)"\n", messages));
        }
        return intentions;
    }

    private static String describeIntentions(Map<String, IntentionAction> intentionMap) {
        return intentionMap.entrySet().stream().map(entry -> MadTestingUtil.getIntentionDescription((String)entry.getKey(), (IntentionAction)entry.getValue())).map("\t"::concat).collect(Collectors.joining("\n"));
    }

    private void restoreAfterPotentialPsiTextInconsistency() {
        PushedFilePropertiesUpdater.getInstance((Project)this.getProject()).filePropertiesChanged(this.getVirtualFile(), Conditions.alwaysTrue());
    }

    protected List<String> extractCommentsReformattedToSingleWhitespace(PsiFile file2) {
        return PsiTreeUtil.findChildrenOfType((PsiElement)file2, PsiComment.class).stream().filter(this.myPolicy::trackComment).map(PsiElement::getText).map(text -> text.replaceAll("[\\s*]+", " ")).collect(Collectors.toList());
    }

    private static void checkNoNewErrors(Project project2, Editor editor, String intentionString, IntentionPolicy policy) {
        List errors = ContainerUtil.filter(InvokeIntention.highlightErrors(project2, editor), info -> policy.shouldTolerateIntroducedError((HighlightInfo)info));
        if (!errors.isEmpty()) {
            throw new AssertionError((Object)("New highlighting errors introduced after invoking " + intentionString + "\nIf this is correct, add it to IntentionPolicy#mayBreakCode.\nErrors found: " + StringUtil.join((Collection)errors, InvokeIntention::shortInfoText, (String)",")));
        }
    }

    @NotNull
    private static String shortInfoText(HighlightInfo info) {
        return "'" + info.getDescription() + "'(" + info.startOffset + "," + info.endOffset + ")";
    }

    @NotNull
    static List<HighlightInfo> highlightErrors(Project project2, Editor editor) {
        List<HighlightInfo> infos = RehighlightAllEditors.highlightEditor(editor, project2);
        return ContainerUtil.filter(infos, i2 -> i2.getSeverity() == HighlightSeverity.ERROR);
    }

    @Nullable
    private Document getDocumentToBeChanged(IntentionAction intention) {
        PsiElement changedElement = intention.getElementToMakeWritable(this.getFile());
        PsiFile changedFile = changedElement == null ? null : changedElement.getContainingFile();
        return changedFile == null ? null : changedFile.getViewProvider().getDocument();
    }

    private List<IntentionAction> getAvailableIntentions(Editor editor, PsiFile file2) {
        List actions = ContainerUtil.filter(CodeInsightTestFixtureImpl.getAvailableIntentions(editor, file2), this.myPolicy::mayInvokeIntention);
        if (actions.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = editor.getCaretModel().getOffset();
        if (MadTestingUtil.isAfterError(file2, offset) || MadTestingUtil.isAfterError(file2, offset - 1)) {
            return Collections.emptyList();
        }
        return actions;
    }
}

