/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private Path myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        return this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir, @NotNull VirtualFileFilter filter) {
        this.createTempDirectory();
        return (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTempDir.toString());
                Assert.assertNotNull((Object)tempDir);
                if (!targetDir.isEmpty()) {
                    Assert.assertFalse((String)"nested directories not implemented", (boolean)targetDir.contains("/"));
                    VirtualFile child = tempDir.findChild(targetDir);
                    if (child == null) {
                        child = tempDir.createChildDirectory((Object)this, targetDir);
                    }
                    tempDir = child;
                }
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                return tempDir;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return this.createTempDirectory().toString();
    }

    public Path createTempFile(@NotNull String path) throws IOException {
        Object prefix = StringUtil.getPackageName((String)path);
        if (((String)prefix).length() < 3) {
            prefix = (String)prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)path);
        Path file2 = FileUtil.createTempFile((File)this.createTempDirectory().toFile(), (String)prefix, (String)suffix, (boolean)true).toPath();
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file2.toString()});
        return file2;
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        String fullPath = this.myTempDir.toString() + "/" + path;
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{fullPath});
        return (VirtualFile)WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath));
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name) {
        Path file2;
        try {
            file2 = TempDirTestFixtureImpl.createEmptyTempFile(this.createTempDirectory(), name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file2.toString()});
        return (VirtualFile)WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file2.toString())));
    }

    @NotNull
    public static Path createEmptyTempFile(@NotNull Path parent, @NotNull String name) throws IOException {
        Path file2 = TempDirTestFixtureImpl.resolvePath(parent, name);
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        Files.newByteChannel(file2, StandardOpenOption.CREATE, StandardOpenOption.WRITE).close();
        return file2;
    }

    @NotNull
    private static Path resolvePath(@NotNull Path parent, @NotNull String name) {
        return parent.resolve(name.startsWith("/") ? name.substring(1) : name).normalize();
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        String path = TempDirTestFixtureImpl.resolvePath(this.createTempDirectory(), name).toString();
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{path});
        return VfsUtil.createDirectories((String)path);
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text) throws IOException {
        VirtualFile file2 = this.createFile(name);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)text));
        return file2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myTempDir == null) {
            return;
        }
        try {
            VirtualFile virtualFile;
            if (this.deleteOnTearDown() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.myTempDir.toString()))) != null) {
                WriteAction.runAndWait(() -> virtualFile.delete((Object)this));
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean deleteOnTearDown() {
        return true;
    }

    @Nullable
    protected Path getTempHome() {
        return null;
    }

    @NotNull
    private Path createTempDirectory() {
        if (this.myTempDir == null) {
            this.myTempDir = this.doCreateTempDirectory();
        }
        return this.myTempDir;
    }

    @NotNull
    protected Path doCreateTempDirectory() {
        return HeavyTestHelper.createTempDirectoryForTempDirTestFixture(this.getTempHome(), "unitTest");
    }
}

