/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.fixtures.SdkTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/fixtures/impl/SdkTestFixtureImpl;", "Lcom/intellij/testFramework/fixtures/impl/BaseFixture;", "Lcom/intellij/testFramework/fixtures/SdkTestFixture;", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkType;", "versionFilter", "Lkotlin/Function1;", "", "", "(Lcom/intellij/openapi/projectRoots/SdkType;Lkotlin/jvm/functions/Function1;)V", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createAndAddSdk", "sdkHome", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findAndAddSdk", "findOrCreateSdk", "findSdkInTable", "getSdk", "setUp", "", "intellij.platform.testFramework"})
public final class SdkTestFixtureImpl
extends BaseFixture
implements SdkTestFixture {
    @NotNull
    private final SdkType sdkType;
    @NotNull
    private final Function1<String, Boolean> versionFilter;
    private Sdk sdk;

    public SdkTestFixtureImpl(@NotNull SdkType sdkType, @NotNull Function1<? super String, Boolean> versionFilter) {
        this.sdkType = sdkType;
        this.versionFilter = versionFilter;
    }

    @Override
    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.sdk;
        if (sdk == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdk");
            sdk = null;
        }
        return sdk;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.sdk = this.findOrCreateSdk();
    }

    private final Sdk findOrCreateSdk() {
        Sdk sdk = this.findSdkInTable();
        if (sdk == null && (sdk = this.findAndAddSdk()) == null) {
            throw new AssertionError((Object)"Cannot find SDK with defined parameters. Please, research SDK restrictions or discuss it with test author, and install it manually.");
        }
        return sdk;
    }

    private final Sdk findSdkInTable() {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        boolean $i$f$runReadAction = false;
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])((Object[])ApplicationManager.getApplication().runReadAction(new Computable(table){
            final /* synthetic */ ProjectJdkTable $table$inlined;
            {
                this.$table$inlined = projectJdkTable;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$table$inlined.getAllJdks();
            }
        }))), (Function1)((Function1)new Function1<Sdk, Boolean>(this){
            final /* synthetic */ SdkTestFixtureImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(Sdk it) {
                boolean bl;
                if (it.getVersionString() != null) {
                    Function1 function1 = SdkTestFixtureImpl.access$getVersionFilter$p(this.this$0);
                    String string = it.getVersionString();
                    Intrinsics.checkNotNull((Object)string);
                    if (((Boolean)function1.invoke((Object)string)).booleanValue()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$sortedBy = false;
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Sdk it = (Sdk)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getVersionString());
                it = (Sdk)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getVersionString())));
            }
        }));
    }

    private final Sdk findAndAddSdk() {
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.sdkType.suggestHomePaths()), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ SdkTestFixtureImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return SdkTestFixtureImpl.access$getSdkType$p(this.this$0).isValidSdkHome(it);
            }
        })), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends String>>(this){
            final /* synthetic */ SdkTestFixtureImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<String, String> invoke(String it) {
                return TuplesKt.to((Object)SdkTestFixtureImpl.access$getSdkType$p(this.this$0).getVersionString(it), (Object)it);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Boolean>(this){
            final /* synthetic */ SdkTestFixtureImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Pair<String, String> it) {
                boolean bl;
                if (it.getFirst() != null) {
                    Function1 function1 = SdkTestFixtureImpl.access$getVersionFilter$p(this.this$0);
                    Object object = it.getFirst();
                    Intrinsics.checkNotNull((Object)object);
                    if (((Boolean)function1.invoke(object)).booleanValue()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$sortedBy = false;
        return (Sdk)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        }), (Function1)((Function1)new Function1<Pair<? extends String, ? extends String>, Sdk>(this){
            final /* synthetic */ SdkTestFixtureImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Sdk invoke(@NotNull Pair<String, String> it) {
                return SdkTestFixtureImpl.access$createAndAddSdk(this.this$0, (String)it.getSecond(), SdkTestFixtureImpl.access$getSdkType$p(this.this$0), this.this$0.getTestRootDisposable());
            }
        })));
    }

    private final Sdk createAndAddSdk(String sdkHome, SdkType sdkType, Disposable parentDisposable) {
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        boolean $i$f$runInEdtAndGet = false;
        Sdk sdk = (Sdk)EdtTestUtil.runInEdtAndGet((ThrowableComputable)new ThrowableComputable(sdkHome, sdkType){
            final /* synthetic */ String $sdkHome$inlined;
            final /* synthetic */ SdkType $sdkType$inlined;
            {
                this.$sdkHome$inlined = string;
                this.$sdkType$inlined = sdkType;
            }

            public final Sdk compute() {
                boolean bl = false;
                return SdkConfigurationUtil.createAndAddSDK((String)this.$sdkHome$inlined, (SdkType)this.$sdkType$inlined);
            }
        });
        if (sdk != null) {
            Disposer.register((Disposable)parentDisposable, () -> SdkTestFixtureImpl.createAndAddSdk$lambda$5(table, sdk));
        }
        return sdk;
    }

    private static final void createAndAddSdk$lambda$5(ProjectJdkTable $table, Sdk $sdk) {
        boolean $i$f$runWriteActionAndWait = false;
        WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable($table, $sdk){
            final /* synthetic */ ProjectJdkTable $table$inlined;
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$table$inlined = projectJdkTable;
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                this.$table$inlined.removeJdk(this.$sdk$inlined);
                return (T)Unit.INSTANCE;
            }
        });
    }

    public static final /* synthetic */ Function1 access$getVersionFilter$p(SdkTestFixtureImpl $this) {
        return $this.versionFilter;
    }

    public static final /* synthetic */ SdkType access$getSdkType$p(SdkTestFixtureImpl $this) {
        return $this.sdkType;
    }

    public static final /* synthetic */ Sdk access$createAndAddSdk(SdkTestFixtureImpl $this, String sdkHome, SdkType sdkType, Disposable parentDisposable) {
        return $this.createAndAddSdk(sdkHome, sdkType, parentDisposable);
    }
}

