/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class ModuleFixtureBuilderImpl<T extends ModuleFixture>
implements ModuleFixtureBuilder<T> {
    private static int ourIndex;
    private final NotNullProducer<? extends ModuleType<?>> myModuleTypeProducer;
    protected final List<String> myContentRoots = new SmartList();
    protected final List<String> mySourceRoots = new SmartList();
    protected final TestFixtureBuilder<? extends IdeaProjectTestFixture> myFixtureBuilder;
    private T myModuleFixture;
    protected String myOutputPath;
    protected String myTestOutputPath;

    public ModuleFixtureBuilderImpl(@NotNull ModuleType<?> moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        this.myModuleTypeProducer = () -> moduleType;
        this.myFixtureBuilder = fixtureBuilder;
    }

    public ModuleFixtureBuilderImpl(@NotNull NotNullProducer<? extends ModuleType<?>> moduleTypeProducer, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        this.myModuleTypeProducer = moduleTypeProducer;
        this.myFixtureBuilder = fixtureBuilder;
    }

    @Override
    @NotNull
    public ModuleFixtureBuilder<T> addContentRoot(@NotNull String contentRootPath) {
        this.myContentRoots.add(contentRootPath);
        return this;
    }

    @Override
    @NotNull
    public ModuleFixtureBuilder<T> addSourceRoot(@NotNull String sourceRootPath) {
        Assert.assertFalse((String)"content root should be added first", (boolean)this.myContentRoots.isEmpty());
        this.mySourceRoots.add(sourceRootPath);
        return this;
    }

    @Override
    public void setOutputPath(@NotNull String outputPath) {
        this.myOutputPath = outputPath;
    }

    @Override
    public void setTestOutputPath(@NotNull String outputPath) {
        this.myTestOutputPath = outputPath;
    }

    @NotNull
    protected Module createModule() {
        Project project2 = this.myFixtureBuilder.getFixture().getProject();
        Assert.assertNotNull((Object)project2);
        Path moduleFilePath = ((ProjectStoreOwner)project2).getComponentStore().getProjectBasePath().getParent().resolve(ModuleFixtureBuilderImpl.getNextIndex() + ".iml");
        return ModuleManager.getInstance((Project)project2).newModule(moduleFilePath, ((ModuleType)this.myModuleTypeProducer.produce()).getId());
    }

    private static int getNextIndex() {
        return ourIndex++;
    }

    @Override
    @NotNull
    public synchronized T getFixture() {
        if (this.myModuleFixture == null) {
            this.myModuleFixture = this.instantiateFixture();
        }
        return this.myModuleFixture;
    }

    @Override
    public void addSourceContentRoot(@NotNull String path) {
        this.addContentRoot(path);
        this.addSourceRoot(path);
    }

    @NotNull
    protected abstract T instantiateFixture();

    @NotNull
    Module buildModule() {
        Module[] module2 = new Module[1];
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myFixtureBuilder.getFixture().getProject()).mergeRootsChangesDuring(() -> {
            module2[0] = this.createModule();
            this.initModule(module2[0]);
        }));
        return module2[0];
    }

    protected void initModule(Module module2) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        try {
            for (String contentRoot : this.myContentRoots) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(contentRoot);
                Assert.assertNotNull((String)("cannot find content root: " + contentRoot), (Object)virtualFile);
                ContentEntry contentEntry = rootModel.addContentEntry(virtualFile);
                for (String sourceRoot : this.mySourceRoots) {
                    VirtualFile file2;
                    String s = UriUtil.trimTrailingSlashes((String)(contentRoot + "/" + sourceRoot));
                    VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(s);
                    if (vf == null && (file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(sourceRoot)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) {
                        vf = file2;
                    }
                    if (vf != null) {
                        VirtualFile finalVf = vf;
                        if (ContainerUtil.exists((Object[])contentEntry.getSourceFolders(), folder -> finalVf.equals(folder.getFile()))) continue;
                        contentEntry.addSourceFolder(finalVf, false);
                        continue;
                    }
                    String url = VfsUtilCore.pathToUrl((String)s);
                    if (ContainerUtil.exists((Object[])contentEntry.getSourceFolders(), folder -> url.equals(folder.getUrl()))) continue;
                    contentEntry.addSourceFolder(url, false);
                }
            }
            this.setupRootModel(rootModel);
        }
        catch (Throwable e) {
            rootModel.dispose();
            throw e;
        }
        rootModel.commit();
    }

    protected void setupRootModel(ModifiableRootModel rootModel) {
    }
}

