/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.common.TestApplicationKt;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import org.jetbrains.annotations.NotNull;

public final class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;
    private final String myName;
    private SdkLeakTracker myOldSdks;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private Project myProject;
    private Module myModule;
    private final Disposable mySdkParentDisposable = Disposer.newDisposable((String)"sdk for project in light test fixture");

    public LightIdeaTestFixtureImpl(@NotNull LightProjectDescriptor projectDescriptor, @NotNull String name) {
        this.myProjectDescriptor = projectDescriptor;
        this.myName = name;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestApplicationManager application = TestApplicationManager.getInstance();
        Pair.NonNull<Project, Module> setup = LightPlatformTestCase.doSetup(this.myProjectDescriptor, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable(), this.mySdkParentDisposable, this.myName);
        this.myProject = (Project)setup.getFirst();
        this.myModule = (Module)setup.getSecond();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(this::getCurrentCodeStyleSettings);
        application.setDataProvider(new TestDataProvider(this.getProject()));
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        Project project2 = this.getProject();
        if (project2 != null) {
            CodeStyle.dropTemporarySettings((Project)project2);
        }
        new RunAll(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                TestApplicationManager.waitForProjectLeakingThreads(project2);
            }
        }, () -> super.tearDown(), () -> {
            this.myProject = null;
            this.myModule = null;
            if (project2 != null) {
                TestApplicationManager.tearDownProjectAndApp(project2);
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> Disposer.dispose((Disposable)this.mySdkParentDisposable), () -> {
            SdkLeakTracker oldSdks = this.myOldSdks;
            if (oldSdks != null) {
                oldSdks.checkForJdkTableLeaks();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                TestApplicationKt.clearIdCache(app);
            }
        }, () -> HeavyPlatformTestCase.cleanupApplicationCaches(project2)).run();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    private CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return CodeStyle.createTestSettings();
        }
        return CodeStyle.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }
}

