/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class JavaCodeInsightTestFixtureImpl
extends CodeInsightTestFixtureImpl
implements JavaCodeInsightTestFixture {
    public JavaCodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirFixture) {
        super(projectFixture, tempDirFixture);
    }

    @Override
    public JavaPsiFacadeEx getJavaFacade() {
        this.assertInitialized();
        return JavaPsiFacadeEx.getInstanceEx((Project)this.getProject());
    }

    @Override
    public PsiClass addClass(@NonNls @NotNull @Language(value="JAVA") String classText) {
        this.assertInitialized();
        String rootPath = this.getTempDirPath();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        if (rootManager != null) {
            Object[] allSourceRoots = rootManager.getSourceRoots(true);
            Object[] productionSourceRoots = rootManager.getSourceRoots(false);
            VirtualFile rootVirtualFile = this.getTempDirFixture().getFile("");
            if (!ArrayUtil.contains((Object)rootVirtualFile, (Object[])allSourceRoots) && !ArrayUtil.isEmpty((Object[])productionSourceRoots)) {
                rootPath = productionSourceRoots[0].getPath();
            }
        }
        PsiClass psiClass = this.addClass(rootPath, classText);
        VirtualFile file2 = psiClass.getContainingFile().getVirtualFile();
        this.allowTreeAccessForFile(file2);
        return psiClass;
    }

    private PsiClass addClass(@NonNls String rootPath, @NonNls @NotNull @Language(value="JAVA") String classText) {
        String qName = (String)ReadAction.compute(() -> {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.getProject());
            PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)classText);
            return javaFile.getClasses()[0].getQualifiedName();
        });
        assert (qName != null);
        PsiFile psiFile = this.addFileToProject(rootPath, qName.replace('.', '/') + ".java", classText);
        return (PsiClass)ReadAction.compute(() -> ((PsiJavaFile)psiFile).getClasses()[0]);
    }

    @Override
    @NotNull
    public PsiClass findClass(@NotNull @NonNls String name) {
        PsiClass aClass = this.getJavaFacade().findClass(name, GlobalSearchScope.allScope((Project)this.getProject()));
        Assert.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        return aClass;
    }

    @Override
    @NotNull
    public PsiPackage findPackage(@NotNull @NonNls String name) {
        PsiPackage aPackage = this.getJavaFacade().findPackage(name);
        Assert.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        return aPackage;
    }
}

