/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.SdkTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.BareTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.EmptyModuleFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.HeavyIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.HeavyTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.LightTestFixtureBuilderImpl;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureImpl;
import com.intellij.testFramework.fixtures.impl.SdkTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class IdeaTestFixtureFactoryImpl
extends IdeaTestFixtureFactory {
    private final Map<Class<? extends ModuleFixtureBuilder<?>>, Class<? extends ModuleFixtureBuilder<?>>> myFixtureBuilderProviders = new HashMap();

    public IdeaTestFixtureFactoryImpl() {
        this.registerFixtureBuilder(EmptyModuleFixtureBuilder.class, MyEmptyModuleFixtureBuilderImpl.class);
    }

    @Override
    public <T extends ModuleFixtureBuilder<?>> void registerFixtureBuilder(@NotNull Class<T> aClass, @NotNull Class<? extends T> implClass) {
        this.myFixtureBuilderProviders.put(aClass, implClass);
    }

    @Override
    public void registerFixtureBuilder(@NotNull Class<? extends ModuleFixtureBuilder<?>> aClass, @NotNull String implClassName) {
        try {
            Class<?> implClass = Class.forName(implClassName);
            Assert.assertTrue((boolean)aClass.isAssignableFrom(implClass));
            this.myFixtureBuilderProviders.put(aClass, implClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate fixture builder implementation", e);
        }
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String name, boolean isDirectoryBasedProject) {
        return new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(name, null, isDirectoryBasedProject), this.myFixtureBuilderProviders);
    }

    @Override
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String name, @Nullable Path projectPath, boolean isDirectoryBasedProject) {
        return new HeavyTestFixtureBuilderImpl(new HeavyIdeaTestFixtureImpl(name, projectPath, isDirectoryBasedProject), this.myFixtureBuilderProviders);
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@NotNull String projectName) {
        return this.createLightFixtureBuilder(null, projectName);
    }

    @Override
    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor projectDescriptor, @NotNull String projectName) {
        if (projectDescriptor == null) {
            projectDescriptor = LightProjectDescriptor.EMPTY_PROJECT_DESCRIPTOR;
        }
        return new LightTestFixtureBuilderImpl<IdeaProjectTestFixture>(new LightIdeaTestFixtureImpl(projectDescriptor, projectName));
    }

    @Override
    @NotNull
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture) {
        return this.createCodeInsightFixture(projectFixture, new TempDirTestFixtureImpl());
    }

    @Override
    @NotNull
    public CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirFixture) {
        return new CodeInsightTestFixtureImpl(projectFixture, tempDirFixture);
    }

    @Override
    @NotNull
    public TempDirTestFixture createTempDirTestFixture() {
        return new TempDirTestFixtureImpl();
    }

    @Override
    @NotNull
    public BareTestFixture createBareFixture() {
        return new BareTestFixtureImpl();
    }

    @Override
    @NotNull
    public SdkTestFixture createSdkFixture(@NotNull SdkType sdkType, @NotNull Predicate<String> versionFilter) {
        return new SdkTestFixtureImpl(sdkType, (Function1<? super String, Boolean>)((Function1)it -> versionFilter.test((String)it)));
    }

    public static final class MyEmptyModuleFixtureBuilderImpl
    extends EmptyModuleFixtureBuilderImpl {
        public MyEmptyModuleFixtureBuilderImpl(@NotNull TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
            super(testFixtureBuilder);
        }

        @Override
        @NotNull
        protected ModuleFixture instantiateFixture() {
            return new ModuleFixtureImpl(this);
        }
    }
}

