/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.analysis.AnalysisScope;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPassFactory;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.actions.HighlightUsagesAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.actions.CleanupInspectionIntention;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.find.FindManager;
import com.intellij.find.actions.SearchTarget2UsageTarget;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.mock.MockProgressIndicator;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameKt;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestActionEvent;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.TreeNodeTester;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestUtil;
import com.intellij.testFramework.fixtures.EditorTestFixture;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.testFramework.utils.inlays.CaretAndInlaysInfo;
import com.intellij.testFramework.utils.inlays.InlayHintsChecker;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import junit.framework.ComparisonFailure;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.Assert;

@TestOnly
public class CodeInsightTestFixtureImpl
extends BaseFixture
implements CodeInsightTestFixture {
    private static final com.intellij.util.Function<IntentionAction, String> INTENTION_NAME_FUN = intentionAction -> "\"" + intentionAction.getText() + "\"";
    private static final String RAINBOW = "rainbow";
    private static final String FOLD = "fold";
    private final IdeaProjectTestFixture myProjectFixture;
    private final TempDirTestFixture myTempDirFixture;
    private PsiManagerImpl myPsiManager;
    private VirtualFile myFile;
    private PsiFile myPsiFile;
    private PsiFile[] myAllPsiFiles;
    private Editor myEditor;
    private EditorTestFixture myEditorTestFixture;
    private String myTestDataPath;
    private VirtualFileFilter myVirtualFileFilter = new FileTreeAccessFilter();
    private boolean myAllowDirt;
    private boolean myCaresAboutInjection = true;
    private boolean myReadEditorMarkupModel;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    private LibraryTableTracker myLibraryTableTracker;
    private ResourceBundle[] myMessageBundles = new ResourceBundle[0];

    public CodeInsightTestFixtureImpl(@NotNull IdeaProjectTestFixture projectFixture, @NotNull TempDirTestFixture tempDirTestFixture) {
        this.myProjectFixture = projectFixture;
        this.myTempDirFixture = tempDirTestFixture;
    }

    private void setFileAndEditor(@NotNull VirtualFile file2, @NotNull Editor editor) {
        this.myFile = file2;
        this.myEditor = editor;
        this.myEditorTestFixture = new EditorTestFixture(this.getProject(), editor, file2);
        this.myPsiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile));
    }

    private void clearFileAndEditor() {
        this.myFile = null;
        this.myEditor = null;
        this.myEditorTestFixture = null;
        this.myPsiFile = null;
        this.myAllPsiFiles = null;
    }

    private static void addGutterIconRenderer(GutterMark renderer, int offset, @NotNull Map<? super Integer, List<GutterMark>> result2) {
        if (renderer == null) {
            return;
        }
        List renderers = result2.computeIfAbsent((Integer)offset, __ -> new SmartList());
        renderers.add(renderer);
    }

    private static void removeDuplicatedRangesForInjected(@NotNull List<? extends HighlightInfo> infos) {
        infos.sort((o1, o2) -> {
            int i2 = o1.startOffset - o2.startOffset;
            return i2 != 0 ? i2 : o1.getSeverity().myVal - o2.getSeverity().myVal;
        });
        HighlightInfo prevInfo = null;
        Iterator<? extends HighlightInfo> it = infos.iterator();
        while (it.hasNext()) {
            HighlightInfo info = it.next();
            if (prevInfo != null && info.getSeverity() == HighlightInfoType.SYMBOL_TYPE_SEVERITY && info.getDescription() == null && info.startOffset == prevInfo.startOffset && info.endOffset == prevInfo.endOffset) {
                it.remove();
            }
            prevInfo = info.type == HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT ? info : null;
        }
    }

    @NotNull
    @TestOnly
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor, int @NotNull [] toIgnore, boolean canChangeDocument) {
        return CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, toIgnore, canChangeDocument, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @TestOnly
    public static List<HighlightInfo> instantiateAndRun(@NotNull PsiFile file2, @NotNull Editor editor, int @NotNull [] toIgnore, boolean canChangeDocument, boolean readEditorMarkupModel) {
        Project project2 = file2.getProject();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        ProjectInspectionProfileManager.getInstance((Project)project2);
        ProcessCanceledException exception = null;
        int retries = 1000;
        for (int i2 = 0; i2 < retries; ++i2) {
            int oldDelay = settings.getAutoReparseDelay();
            try {
                settings.setAutoReparseDelay(0);
                ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
                EdtTestUtil.runInEdtAndWait(() -> {
                    codeAnalyzer.runPasses(file2, editor.getDocument(), textEditor, toIgnore, canChangeDocument, null);
                    IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
                    if (policy != null) {
                        policy.waitForHighlighting(project2, editor);
                    }
                    IdentifierHighlighterPassFactory.waitForIdentifierHighlighting();
                    infos.addAll(DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), null, (Project)project2));
                    if (readEditorMarkupModel) {
                        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
                        DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)markupModel, (Project)project2, null, (int)0, (int)editor.getDocument().getTextLength(), (Processor)Processors.cancelableCollectProcessor((Collection)infos));
                    }
                });
                infos.addAll(DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).getFileLevelHighlights(project2, file2));
                ArrayList<HighlightInfo> arrayList = infos;
                return arrayList;
            }
            catch (ProcessCanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause.getClass() != Throwable.class) {
                    throw e;
                }
                EdtTestUtil.runInEdtAndWait(() -> {
                    PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                    UIUtil.dispatchAllInvocationEvents();
                });
                exception = e;
                continue;
            }
            finally {
                settings.setAutoReparseDelay(oldDelay);
            }
        }
        throw new AssertionError("Unable to highlight after " + retries + " retries", exception);
    }

    public static void ensureIndexesUpToDate(@NotNull Project project2) {
        if (!DumbService.isDumb((Project)project2)) {
            ReadAction.run(() -> {
                for (FileBasedIndexExtension extension : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
                    FileBasedIndex.getInstance().ensureUpToDate(extension.getName(), project2, null);
                }
            });
        }
    }

    @NotNull
    @TestOnly
    public static List<IntentionAction> getAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        return (List)ReadAction.compute(() -> CodeInsightTestFixtureImpl.doGetAvailableIntentions(editor, file2));
    }

    @NotNull
    private static List<IntentionAction> doGetAvailableIntentions(@NotNull Editor editor, @NotNull PsiFile file2) {
        IdeaTestExecutionPolicy current = IdeaTestExecutionPolicy.current();
        if (current != null) {
            current.waitForHighlighting(file2.getProject(), editor);
        }
        CodeInsightTestFixtureImpl.waitForUnresolvedReferencesQuickFixesUnderCaret(file2, editor);
        ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionsPass.getActionsToShow((Editor)editor, (PsiFile)file2, (boolean)false);
        ArrayList<IntentionAction> result2 = new ArrayList<IntentionAction>();
        IntentionListStep intentionListStep = new IntentionListStep(null, editor, file2, file2.getProject(), CachedIntentions.create((Project)file2.getProject(), (PsiFile)file2, (Editor)editor, (ShowIntentionsPass.IntentionsInfo)intentions));
        for (Map.Entry entry : intentionListStep.getActionsWithSubActions().entrySet()) {
            result2.add((IntentionAction)entry.getKey());
            result2.addAll((Collection)entry.getValue());
        }
        List infos = DaemonCodeAnalyzerEx.getInstanceEx((Project)file2.getProject()).getFileLevelHighlights(file2.getProject(), file2);
        for (HighlightInfo info : infos) {
            info.findRegisteredQuickFix((descriptor, range) -> {
                if (descriptor.getAction().isAvailable(file2.getProject(), editor, file2)) {
                    result2.add(descriptor.getAction());
                    for (IntentionAction subAction : descriptor.getOptions((PsiElement)file2, editor)) {
                        if (!subAction.isAvailable(file2.getProject(), editor, file2)) continue;
                        result2.add(subAction);
                    }
                }
                return null;
            });
        }
        return result2;
    }

    public static void waitForUnresolvedReferencesQuickFixesUnderCaret(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ActionUtil.underModalProgress((Project)file2.getProject(), (String)CodeInsightBundle.message((String)"progress.title.searching.for.context.actions", (Object[])new Object[0]), () -> {
                DaemonCodeAnalyzerImpl.waitForUnresolvedReferencesQuickFixesUnderCaret((PsiFile)file2, (Editor)editor);
                return null;
            });
        } else {
            DaemonCodeAnalyzerImpl.waitForUnresolvedReferencesQuickFixesUnderCaret((PsiFile)file2, (Editor)editor);
        }
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return this.myTempDirFixture.getTempDirPath();
    }

    @Override
    @NotNull
    public TempDirTestFixture getTempDirFixture() {
        return this.myTempDirFixture;
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath) {
        return this.copyFileToProject(sourcePath, sourcePath);
    }

    @Override
    @NotNull
    public VirtualFile copyFileToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        File candidate;
        String testDataPath = this.getTestDataPath();
        File sourceFile = new File(testDataPath, FileUtil.toSystemDependentName((String)sourcePath));
        if (!sourceFile.exists() && (candidate = new File(sourcePath)).isAbsolute()) {
            sourceFile = candidate;
            if (FileUtil.pathsEqual((String)targetPath, (String)sourcePath)) {
                Path testDataPathObj = Paths.get(testDataPath, new String[0]);
                Path targetPathObj = Paths.get(targetPath, new String[0]);
                if (targetPathObj.startsWith(testDataPathObj) && !targetPathObj.equals(testDataPathObj)) {
                    targetPath = testDataPathObj.relativize(targetPathObj).toString();
                } else {
                    throw new IllegalArgumentException("Cannot guess target path for '" + sourcePath + "'; please specify explicitly");
                }
            }
        }
        targetPath = FileUtil.toSystemIndependentName((String)targetPath);
        VirtualFile targetFile = this.myTempDirFixture.getFile(targetPath);
        if (!sourceFile.exists() && targetFile != null && targetPath.equals(sourcePath)) {
            return targetFile;
        }
        CodeInsightTestFixtureImpl.assertFileEndsWithCaseSensitivePath(sourceFile);
        Assert.assertTrue((String)("Cannot find source file: " + sourceFile + "; test data path: " + testDataPath + "; sourcePath: " + sourcePath), (boolean)sourceFile.exists());
        Assert.assertTrue((String)("Not a file: " + sourceFile), (boolean)sourceFile.isFile());
        if (targetFile == null) {
            targetFile = this.myTempDirFixture.createFile(targetPath);
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(targetFile, sourcePath);
            targetFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, (Object)sourceFile.getAbsolutePath());
        }
        CodeInsightTestFixtureImpl.copyContent(sourceFile, targetFile);
        return targetFile;
    }

    private static void assertFileEndsWithCaseSensitivePath(@NotNull File sourceFile) {
        try {
            String sourceName = sourceFile.getPath();
            File realFile = sourceFile.getCanonicalFile();
            String realFileName = realFile.getPath();
            if (!sourceName.equals(realFileName) && sourceName.equalsIgnoreCase(realFileName)) {
                Assert.fail((String)("Please correct case-sensitivity of path to prevent test failure on case-sensitive file systems:\n     path " + sourceFile.getPath() + "\nreal path " + realFile.getPath()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("sourceFile=" + sourceFile, e);
        }
    }

    private static void copyContent(@NotNull File sourceFile, @NotNull VirtualFile targetFile) {
        try {
            WriteAction.runAndWait(() -> {
                targetFile.setBinaryContent(FileUtil.loadFileBytes((File)sourceFile));
                FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{targetFile});
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public VirtualFile copyDirectoryToProject(@NotNull String sourcePath, @NotNull String targetPath) {
        String testDataPath = this.getTestDataPath();
        File fromFile = new File(testDataPath + "/" + sourcePath);
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.copyAll(fromFile.getPath(), targetPath);
        }
        File targetFile = new File(this.getTempDirPath() + "/" + targetPath);
        try {
            FileUtil.copyDir((File)fromFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(targetFile);
        Assert.assertNotNull((Object)file2);
        file2.refresh(false, true);
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            PsiDirectory directory = (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findDirectory(file2));
            Assert.assertNotNull((Object)directory);
            policy.testDirectoryConfigured(directory);
        }
        return file2;
    }

    @Override
    public void enableInspections(InspectionProfileEntry ... inspections) {
        this.assertInitialized();
        InspectionsKt.enableInspectionTools(this.getProject(), this.myProjectFixture.getTestRootDisposable(), inspections);
    }

    @Override
    @SafeVarargs
    public final void enableInspections(Class<? extends LocalInspectionTool> ... inspections) {
        this.enableInspections(Arrays.asList(inspections));
    }

    @Override
    public void enableInspections(@NotNull Collection<Class<? extends LocalInspectionTool>> inspections) {
        List<InspectionProfileEntry> tools = InspectionTestUtil.instantiateTools(inspections);
        this.enableInspections(tools.toArray(new InspectionProfileEntry[0]));
    }

    @Override
    public void disableInspections(InspectionProfileEntry ... inspections) {
        InspectionsKt.disableInspections(this.getProject(), inspections);
    }

    @Override
    public void enableInspections(InspectionToolProvider ... providers) {
        List<Class<? extends LocalInspectionTool>> classes = Stream.of(providers).flatMap(p -> Stream.of(p.getInspectionClasses())).filter(LocalInspectionTool.class::isAssignableFrom).collect(Collectors.toList());
        this.enableInspections(classes);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, String ... paths) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(paths).map(this::copyFileToProject));
    }

    @Override
    public long testHighlightingAllFiles(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, VirtualFile ... files) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, Stream.of(files));
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull Stream<? extends VirtualFile> files) {
        record FileHighlighting(PsiFile file, Editor editor, ExpectedHighlightingData data) {
        }
        List<FileHighlighting> data = files.map(file2 -> {
            PsiFile psiFile = this.myPsiManager.findFile(file2);
            Assert.assertNotNull((Object)psiFile);
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            Assert.assertNotNull((Object)document);
            ExpectedHighlightingData datum = new ExpectedHighlightingData(document, checkWarnings, checkWeakWarnings, checkInfos, false, this.myMessageBundles);
            datum.init();
            return new FileHighlighting(psiFile, this.createEditor((VirtualFile)file2), datum);
        }).toList();
        long elapsed = 0L;
        for (FileHighlighting highlighting : data) {
            this.setFileAndEditor(highlighting.file().getVirtualFile(), highlighting.editor());
            elapsed += this.collectAndCheckHighlighting(highlighting.data());
        }
        return elapsed;
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.checkHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    @Override
    public long checkHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, ignoreExtraHighlighting);
    }

    @Override
    public long checkHighlighting() {
        return this.checkHighlighting(true, false, true);
    }

    @Override
    public long testHighlighting(String ... filePaths) {
        return this.testHighlighting(true, false, true, filePaths);
    }

    @Override
    public long testHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, @NotNull VirtualFile file2) {
        this.openFileInEditor(file2);
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings);
    }

    @Override
    @NotNull
    public HighlightTestInfo testFile(String ... filePath) {
        return new HighlightTestInfo(this.myProjectFixture.getTestRootDisposable(), filePath){

            @Override
            public HighlightTestInfo doTest() {
                CodeInsightTestFixtureImpl.this.configureByFiles(this.filePaths);
                ExpectedHighlightingData data = new ExpectedHighlightingData(CodeInsightTestFixtureImpl.this.myEditor.getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos, false, CodeInsightTestFixtureImpl.this.myMessageBundles);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                data.init();
                CodeInsightTestFixtureImpl.this.collectAndCheckHighlighting(data);
                return this;
            }
        };
    }

    @Override
    public void openFileInEditor(@NotNull VirtualFile file2) {
        this.setFileAndEditor(file2, this.createEditor(file2));
    }

    @Override
    public void testInspection(@NotNull String testDir, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        VirtualFile sourceDir = this.copyDirectoryToProject(new File(testDir, "src").getPath(), "");
        PsiDirectory psiDirectory = this.getPsiManager().findDirectory(sourceDir);
        Assert.assertNotNull((Object)psiDirectory);
        AnalysisScope scope = new AnalysisScope(psiDirectory);
        scope.invalidate();
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool(scope, this.getProject(), Collections.singletonList(toolWrapper));
        InspectionTestUtil.runTool(toolWrapper, scope, globalContext);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)globalContext, toolWrapper, false, new File(this.getTestDataPath(), testDir).getPath());
    }

    @Override
    @NotNull
    public PsiSymbolReference findSingleReferenceAtCaret() {
        PsiFile file2 = this.getFile();
        Assert.assertNotNull((Object)file2);
        return (PsiSymbolReference)UsefulTestCase.assertOneElement(ReferencesKt.referencesAt((PsiFile)file2, (int)this.getCaretOffset()));
    }

    @Override
    @Nullable
    public PsiReference getReferenceAtCaretPosition(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getFile().findReferenceAt(this.myEditor.getCaretModel().getOffset());
    }

    @Override
    @NotNull
    public PsiReference getReferenceAtCaretPositionWithAssertion(String ... filePaths) {
        PsiReference reference = this.getReferenceAtCaretPosition(filePaths);
        Assert.assertNotNull((String)("no reference found at " + this.myEditor.getCaretModel().getLogicalPosition()), (Object)reference);
        return reference;
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions(String ... filePaths) {
        if (filePaths.length > 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.getAvailableIntentions();
    }

    @Override
    @NotNull
    public List<IntentionAction> getAllQuickFixes(String ... filePaths) {
        if (filePaths.length != 0) {
            this.configureByFilesInner(filePaths);
        }
        return this.myEditorTestFixture.getAllQuickFixes();
    }

    @Override
    @NotNull
    public List<IntentionAction> getAvailableIntentions() {
        this.doHighlighting();
        return (List)ReadAction.compute(() -> CodeInsightTestFixtureImpl.getAvailableIntentions(this.getHostEditor(), this.getHostFileAtCaret()));
    }

    @NotNull
    private Editor getHostEditor() {
        return InjectedLanguageEditorUtil.getTopLevelEditor((Editor)this.getEditor());
    }

    @NotNull
    private PsiFile getHostFileAtCaret() {
        return Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)this.getHostEditor(), (Project)this.getProject()));
    }

    @Override
    @NotNull
    public List<IntentionAction> filterAvailableIntentions(@NotNull String hint) {
        return ContainerUtil.filter(this.getAvailableIntentions(), action -> action.getText().startsWith(hint));
    }

    @Override
    @NotNull
    public IntentionAction findSingleIntention(@NotNull String hint) {
        List<IntentionAction> list = this.filterAvailableIntentions(hint);
        if (list.isEmpty()) {
            Assert.fail((String)("\"" + hint + "\" not in [" + StringUtil.join(this.getAvailableIntentions(), INTENTION_NAME_FUN, (String)", ") + "]"));
        } else if (list.size() > 1) {
            Assert.fail((String)("Too many intentions found for \"" + hint + "\": [" + StringUtil.join(list, INTENTION_NAME_FUN, (String)", ") + "]"));
        }
        return UsefulTestCase.assertOneElement(list);
    }

    @Override
    public IntentionAction getAvailableIntention(@NotNull String intentionName, String ... filePaths) {
        List<IntentionAction> intentions = this.getAvailableIntentions(filePaths);
        IntentionAction action = CodeInsightTestUtil.findIntentionByText(intentions, intentionName);
        if (action == null) {
            System.out.println(intentionName + " not found among " + StringUtil.join(intentions, IntentionAction::getText, (String)","));
        }
        return action;
    }

    @Override
    public void checkPreviewAndLaunchAction(@NotNull IntentionAction action) {
        if (CodeInsightTestFixtureImpl.skipPreview(action)) {
            this.launchAction(action);
        } else {
            String text = this.getIntentionPreviewText(action);
            Assert.assertNotNull((String)action.getText(), (Object)text);
            this.launchAction(action);
            Assert.assertEquals((String)action.getText(), (Object)this.getFile().getText(), (Object)text);
        }
    }

    private static boolean skipPreview(@NotNull IntentionAction action) {
        return IntentionActionDelegate.unwrap((IntentionAction)action) instanceof CleanupInspectionIntention;
    }

    @Override
    @Nullable
    public String getIntentionPreviewText(@NotNull IntentionAction action) {
        try {
            return (String)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewText((Project)this.getProject(), (IntentionAction)action, (PsiFile)this.getFile(), (Editor)this.getEditor())).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkIntentionPreviewHtml(@NotNull IntentionAction action, @NotNull @Language(value="HTML") String expected) {
        IntentionPreviewInfo info;
        try {
            info = (IntentionPreviewInfo)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewInfo((Project)this.getProject(), (IntentionAction)action, (PsiFile)this.getFile(), (Editor)this.getEditor())).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)action.getText(), (boolean)(info instanceof IntentionPreviewInfo.Html));
        Assert.assertEquals((String)action.getText(), (Object)expected, (Object)((IntentionPreviewInfo.Html)info).content().toString());
    }

    @Override
    public void launchAction(@NotNull IntentionAction action) {
        EdtTestUtil.runInEdtAndWait(() -> CodeInsightTestFixtureImpl.invokeIntention(action, this.getHostFileAtCaret(), this.getHostEditor()));
    }

    @Override
    public void testCompletion(String @NotNull [] filesBefore, @NotNull @TestDataFile String fileAfter) {
        this.testCompletionTyping(filesBefore, "", fileAfter);
    }

    @Override
    public void testCompletionTyping(String @NotNull [] filesBefore, @NotNull String toType, @NotNull String fileAfter) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        this.complete(CompletionType.BASIC);
        this.type(toType);
        try {
            this.checkResultByFile(fileAfter);
        }
        catch (RuntimeException e) {
            System.out.println("LookupElementStrings = " + this.getLookupElementStrings());
            throw e;
        }
    }

    protected void assertInitialized() {
        Assert.assertNotNull((String)"setUp() hasn't been called", (Object)this.myPsiManager);
    }

    @Override
    public void testCompletion(@NotNull String fileBefore, @NotNull String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping(fileBefore, "", fileAfter, additionalFiles);
    }

    @Override
    public void testCompletionTyping(@NotNull @TestDataFile String fileBefore, @NotNull String toType, @NotNull @TestDataFile String fileAfter, String ... additionalFiles) {
        this.testCompletionTyping((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))), toType, fileAfter);
    }

    @Override
    public void testCompletionVariants(@NotNull String fileBefore, String ... expectedItems) {
        this.assertInitialized();
        List<String> result2 = this.getCompletionVariants(fileBefore);
        Assert.assertNotNull(result2);
        UsefulTestCase.assertSameElements(result2, expectedItems);
    }

    @Override
    public List<String> getCompletionVariants(String ... filesBefore) {
        this.assertInitialized();
        this.configureByFiles(filesBefore);
        LookupElement[] items = this.complete(CompletionType.BASIC);
        Assert.assertNotNull((String)"No lookup was shown, probably there was only one lookup element that was inserted automatically", (Object)items);
        return this.getLookupElementStrings();
    }

    @Override
    @Nullable
    public List<String> getLookupElementStrings() {
        this.assertInitialized();
        return this.myEditorTestFixture.getLookupElementStrings();
    }

    @Override
    public void finishLookup(char completionChar) {
        this.myEditorTestFixture.finishLookup(completionChar);
    }

    @Override
    public void testRename(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))));
        this.testRename(fileAfter, newName);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileBefore, @NotNull String fileAfter, @NotNull String newName, String ... additionalFiles) {
        this.assertInitialized();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)fileBefore))));
        this.testRenameUsingHandler(fileAfter, newName);
    }

    @Override
    public void testRenameUsingHandler(@NotNull String fileAfter, @NotNull String newName) {
        this.renameElementAtCaretUsingHandler(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    public void testRename(@NotNull String fileAfter, @NotNull String newName) {
        this.renameElementAtCaret(newName);
        this.checkResultByFile(fileAfter);
    }

    @Override
    @NotNull
    public PsiElement getElementAtCaret() {
        this.assertInitialized();
        return this.myEditorTestFixture.getElementAtCaret();
    }

    @Override
    public void renameElementAtCaret(@NotNull String newName) {
        this.renameElement(this.getElementAtCaret(), newName);
    }

    @Override
    public void renameElementAtCaretUsingHandler(@NotNull String newName) {
        DataContext editorContext = ((EditorEx)this.myEditor).getDataContext();
        DataContext context2 = dataId -> PsiElementRenameHandler.DEFAULT_NAME.is(dataId) ? newName : editorContext.getData(dataId);
        RenameHandler renameHandler = RenameHandlerRegistry.getInstance().getRenameHandler(context2);
        Assert.assertNotNull((String)"No handler for this context", (Object)renameHandler);
        renameHandler.invoke(this.getProject(), this.myEditor, this.getFile(), context2);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName) {
        boolean searchInComments = false;
        boolean searchTextOccurrences = false;
        this.renameElement(element, newName, false, false);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, boolean searchInComments, boolean searchTextOccurrences) {
        PsiElement substitution = RenamePsiElementProcessor.forElement((PsiElement)element).substituteElementToRename(element, this.myEditor);
        if (substitution == null) {
            return;
        }
        new RenameProcessor(this.getProject(), substitution, newName, searchInComments, searchTextOccurrences).run();
    }

    @Override
    public void renameTarget(@NotNull RenameTarget renameTarget, @NotNull String newName) {
        RenameKt.renameAndWait((Project)this.getProject(), (RenameTarget)renameTarget, (String)newName);
    }

    @Override
    public <T extends PsiElement> T findElementByText(@NotNull String text, @NotNull Class<T> elementClass) {
        return this.myEditorTestFixture.findElementByText(text, elementClass);
    }

    @Override
    public void type(char c) {
        this.assertInitialized();
        this.myEditorTestFixture.type(c);
    }

    @Override
    public void type(@NotNull String s) {
        this.myEditorTestFixture.type(s);
    }

    @Override
    public void performEditorAction(@NotNull String actionId) {
        this.assertInitialized();
        EdtTestUtil.runInEdtAndWait(() -> this.myEditorTestFixture.performEditorAction(actionId));
    }

    @Override
    @NotNull
    public Presentation testAction(@NotNull AnAction action) {
        TestActionEvent e = new TestActionEvent(action);
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)e, (boolean)true)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)e);
        }
        return e.getPresentation();
    }

    @Override
    @NotNull
    public Collection<UsageInfo> testFindUsages(String ... fileNames) {
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        int flags = 3;
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)flags);
        Assert.assertNotNull((String)"Cannot find referenced element", (Object)targetElement);
        return this.findUsages(targetElement);
    }

    @Override
    @NotNull
    public Collection<Usage> testFindUsagesUsingAction(String ... fileNames) {
        this.assertInitialized();
        if (fileNames.length > 0) {
            this.configureByFiles(fileNames);
        }
        EdtTestUtil.runInEdtAndWait(() -> this.myEditorTestFixture.performEditorAction("FindUsages"));
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> {
            Content selectedContent;
            UsageViewContentManager usageViewManager = UsageViewContentManager.getInstance((Project)this.getProject());
            while ((selectedContent = usageViewManager.getSelectedContent()) != null) {
                usageViewManager.closeContent(selectedContent);
            }
        });
        return (Collection)EdtTestUtil.runInEdtAndGet(() -> {
            UsageView view;
            long startMillis = System.currentTimeMillis();
            boolean viewWasInitialized = false;
            while ((view = UsageViewManager.getInstance((Project)this.getProject()).getSelectedUsageView()) == null || view.isSearchInProgress()) {
                IdeEventQueue.getInstance().flushQueue();
                if ((viewWasInitialized |= view != null) || System.currentTimeMillis() - startMillis <= TimeUnit.SECONDS.toMillis(10L)) continue;
                Assert.fail((String)"UsageView wasn't shown");
                return Collections.emptyList();
            }
            return view.getUsages();
        });
    }

    @Override
    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement) {
        return this.findUsages(targetElement, null);
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull Collection<? extends UsageInfo> usages) {
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(UsageTarget.EMPTY_ARRAY, ContainerUtil.map(usages, usage -> new UsageInfo2UsageAdapter(usage)).toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        return this.getUsageViewTreeTextRepresentation(usageView);
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull List<UsageTarget> usageTargets, @NotNull Collection<? extends Usage> usages) {
        UsageViewImpl usageView = (UsageViewImpl)UsageViewManager.getInstance((Project)this.getProject()).createUsageView(usageTargets.toArray(UsageTarget.EMPTY_ARRAY), usages.toArray(Usage.EMPTY_ARRAY), new UsageViewPresentation(), null);
        return this.getUsageViewTreeTextRepresentation(usageView);
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull PsiElement targetElement) {
        FindUsagesManager usagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.getProject())).getFindUsagesManager();
        FindUsagesHandler handler = usagesManager.getFindUsagesHandler(targetElement, false);
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler);
        UsageViewImpl usageView = (UsageViewImpl)usagesManager.doFindUsages(handler.getPrimaryElements(), handler.getSecondaryElements(), (FindUsagesHandlerBase)handler, handler.getFindUsagesOptions(), false);
        return this.getUsageViewTreeTextRepresentation(usageView);
    }

    @Override
    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull SearchTarget target) {
        Project project2 = this.getProject();
        SearchScope searchScope = (SearchScope)ObjectUtils.coalesce((Object)target.getMaximalSearchScope(), (Object)GlobalSearchScope.allScope((Project)project2));
        AllSearchOptions allOptions = new AllSearchOptions(UsageOptions.createOptions((SearchScope)searchScope), Boolean.valueOf(true));
        List<SearchTarget2UsageTarget> usageTargets = List.of(new SearchTarget2UsageTarget(project2, target, allOptions));
        Collection usages = ImplKt.buildUsageViewQuery((Project)this.getProject(), (SearchTarget)target, (AllSearchOptions)allOptions).findAll();
        return this.getUsageViewTreeTextRepresentation(usageTargets, usages);
    }

    @NotNull
    public Collection<UsageInfo> findUsages(@NotNull PsiElement targetElement, @Nullable SearchScope scope) {
        Project project2 = this.getProject();
        FindUsagesHandler handler = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager().getFindUsagesHandler(targetElement, false);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(Collections.synchronizedList(new ArrayList()));
        Assert.assertNotNull((String)("Cannot find handler for: " + targetElement), (Object)handler);
        PsiElement[] psiElements = (PsiElement[])ArrayUtil.mergeArrays((Object[])handler.getPrimaryElements(), (Object[])handler.getSecondaryElements());
        FindUsagesOptions options2 = handler.getFindUsagesOptions(null);
        if (scope != null) {
            options2.searchScope = scope;
        }
        for (PsiElement psiElement : psiElements) {
            handler.processElementUsages(psiElement, (Processor)processor, options2);
        }
        return processor.getResults();
    }

    @Override
    public RangeHighlighter @NotNull [] testHighlightUsages(String ... files) {
        this.configureByFiles(files);
        this.testAction((AnAction)new HighlightUsagesAction());
        Editor editor = this.getEditor();
        return editor.getMarkupModel().getAllHighlighters();
    }

    @Override
    public void moveFile(@NotNull String filePath, @NotNull String to, String ... additionalFiles) {
        this.assertInitialized();
        Project project2 = this.getProject();
        this.configureByFiles((String[])ArrayUtil.reverseArray((Object[])((String[])ArrayUtil.append((Object[])additionalFiles, (Object)filePath))));
        VirtualFile file2 = this.findFileInTempDir(to);
        Assert.assertNotNull((String)("Directory " + to + " not found"), (Object)file2);
        Assert.assertTrue((String)(to + " is not a directory"), (boolean)file2.isDirectory());
        PsiDirectory directory = this.myPsiManager.findDirectory(file2);
        new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{this.getFile()}, directory, false, false, null, null).run();
    }

    @Override
    @Nullable
    public GutterMark findGutter(@NotNull String filePath) {
        this.configureByFilesInner(filePath);
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), (Processor<? super GutterMark>)processor);
        return (GutterMark)processor.getFoundValue();
    }

    @Override
    @NotNull
    public List<GutterMark> findGuttersAtCaret() {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.doHighlighting();
        CodeInsightTestFixtureImpl.processGuttersAtCaret(this.myEditor, this.getProject(), (Processor<? super GutterMark>)processor);
        return new ArrayList<GutterMark>(processor.getResults());
    }

    public static boolean processGuttersAtCaret(Editor editor, Project project2, @NotNull Processor<? super GutterMark> processor) {
        RangeHighlighter[] highlighters;
        int offset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            GutterIconRenderer renderer = highlighter.getGutterIconRenderer();
            if (renderer == null || editor.getDocument().getLineNumber(offset) != editor.getDocument().getLineNumber(highlighter.getStartOffset()) || processor.process((Object)renderer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters(@NotNull String filePath) {
        this.configureByFilesInner(filePath);
        return this.findAllGutters();
    }

    @Override
    @NotNull
    public List<GutterMark> findAllGutters() {
        RangeHighlighter[] highlighters;
        Project project2 = this.getProject();
        TreeMap result2 = new TreeMap();
        List<HighlightInfo> infos = this.doHighlighting();
        for (HighlightInfo info : infos) {
            CodeInsightTestFixtureImpl.addGutterIconRenderer(info.getGutterIconRenderer(), info.startOffset, result2);
        }
        for (RangeHighlighter highlighter : highlighters = DocumentMarkupModel.forDocument((Document)this.myEditor.getDocument(), (Project)project2, (boolean)true).getAllHighlighters()) {
            if (!highlighter.isValid()) continue;
            CodeInsightTestFixtureImpl.addGutterIconRenderer((GutterMark)highlighter.getGutterIconRenderer(), highlighter.getStartOffset(), result2);
        }
        return ContainerUtil.concat(result2.values());
    }

    @Override
    public PsiFile addFileToProject(@NotNull String relativePath, @NotNull String fileText) {
        this.assertInitialized();
        return this.addFileToProject(this.getTempDirPath(), relativePath, fileText);
    }

    protected PsiFile addFileToProject(@NotNull String rootPath, @NotNull String relativePath, @NotNull String fileText) {
        try {
            VirtualFile file2 = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
                try {
                    VirtualFile f = this.myTempDirFixture instanceof LightTempDirTestFixtureImpl ? this.myTempDirFixture.createFile(relativePath, fileText) : (this.myProjectFixture instanceof HeavyIdeaTestFixture ? ((HeavyIdeaTestFixture)this.myProjectFixture).addFileToProject(rootPath, relativePath, fileText).getViewProvider().getVirtualFile() : this.myTempDirFixture.createFile(relativePath, fileText));
                    this.prepareVirtualFile(f);
                    VirtualFile virtualFile = f;
                    return virtualFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    PsiManager.getInstance((Project)this.getProject()).dropPsiCaches();
                }
            });
            return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(file2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> epName, @NotNull T extension) {
        this.assertInitialized();
        area.getExtensionPoint(epName).registerExtension(extension, this.myProjectFixture.getTestRootDisposable());
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type) {
        return this.myEditorTestFixture.complete(type);
    }

    @Override
    public LookupElement[] complete(@NotNull CompletionType type, int invocationCount) {
        this.assertInitialized();
        return this.myEditorTestFixture.complete(type, invocationCount);
    }

    @Override
    public LookupElement @Nullable [] completeBasic() {
        return this.myEditorTestFixture.completeBasic();
    }

    @Override
    @NotNull
    public final List<LookupElement> completeBasicAllCarets(@Nullable Character charToTypeAfterCompletion) {
        return this.myEditorTestFixture.completeBasicAllCarets(charToTypeAfterCompletion);
    }

    @Override
    public void saveText(@NotNull VirtualFile file2, @NotNull String text) {
        try {
            WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)text));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LookupElement @Nullable [] getLookupElements() {
        return this.myEditorTestFixture.getLookupElements();
    }

    @Override
    public void checkResult(@NotNull String expectedText) {
        this.checkResult(expectedText, false);
    }

    @Override
    public void checkResult(@NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), this.getHostFile().getText());
        });
    }

    @Override
    public void checkResult(@NotNull String filePath, @NotNull String expectedText, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            policy.beforeCheckResult(this.getFile());
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            PsiFile psiFile = this.getFileToCheck(filePath);
            this.checkResult("TEXT", stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromText(expectedText), psiFile.getText());
        });
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile) {
        this.checkResultByFile(expectedFile, false);
    }

    @Override
    public void checkResultByFile(@NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getHostFile(), ignoreTrailingWhitespaces));
    }

    @Override
    public void checkResultByFile(@NotNull String filePath, @NotNull String expectedFile, boolean ignoreTrailingWhitespaces) {
        this.assertInitialized();
        ApplicationManager.getApplication().invokeAndWait(() -> this.checkResultByFile(expectedFile, this.getFileToCheck(filePath), ignoreTrailingWhitespaces));
    }

    private PsiFile getFileToCheck(String filePath) {
        String path = filePath.replace(File.separatorChar, '/');
        VirtualFile copy = this.findFileInTempDir(path);
        Assert.assertNotNull((String)("could not find results file " + path), (Object)copy);
        PsiFile psiFile = this.myPsiManager.findFile(copy);
        Assert.assertNotNull((String)copy.getPath(), (Object)psiFile);
        return psiFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        EdtTestUtil.runInEdtAndWait(() -> {
            this.myProjectFixture.setUp();
            this.myTempDirFixture.setUp();
            VirtualFile tempDir = this.myTempDirFixture.getFile("");
            Assert.assertNotNull((Object)tempDir);
            HeavyPlatformTestCase.synchronizeTempDirVfs(tempDir);
            this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.getProject());
            InspectionsKt.configureInspections((InspectionProfileEntry[])LocalInspectionTool.EMPTY_ARRAY, this.getProject(), this.myProjectFixture.getTestRootDisposable());
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            daemonCodeAnalyzer.prepareForTest();
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
            CodeInsightTestFixtureImpl.ensureIndexesUpToDate(this.getProject());
            CodeStyle.setTemporarySettings((Project)this.getProject(), (CodeStyleSettings)CodeStyle.createTestSettings());
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.setUp(this.getProject(), this.getTestRootDisposable(), this.getTestDataPath());
            }
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)new EmptyAction(true), (AnActionEvent)AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataContext.EMPTY_CONTEXT));
        });
        for (Module module2 : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            ModuleRootManager.getInstance((Module)module2).orderEntries().getAllLibrariesAndSdkClassesRoots();
        }
        if (this.shouldTrackVirtualFilePointers()) {
            this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
        }
        this.myLibraryTableTracker = new LibraryTableTracker();
    }

    protected boolean shouldTrackVirtualFilePointers() {
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        AtomicReference projectRootManagerComponentRef = new AtomicReference();
        RunAll.runAll(() -> EdtTestUtil.runInEdtAndWait(() -> {
            DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings;
            Project project2;
            if (ApplicationManager.getApplication() == null) {
                return;
            }
            try {
                project2 = this.myProjectFixture.getProject();
            }
            catch (AssertionError | UninitializedPropertyAccessException ignore) {
                project2 = null;
            }
            if (project2 != null) {
                CodeStyle.dropTemporarySettings((Project)project2);
                AutoPopupController autoPopupController = (AutoPopupController)project2.getServiceIfCreated(AutoPopupController.class);
                if (autoPopupController != null) {
                    autoPopupController.cancelAllRequests();
                }
            }
            if ((daemonCodeAnalyzerSettings = (DaemonCodeAnalyzerSettings)ApplicationManager.getApplication().getServiceIfCreated(DaemonCodeAnalyzerSettings.class)) != null) {
                daemonCodeAnalyzerSettings.setImportHintEnabled(true);
            }
            if (project2 != null) {
                this.closeOpenFiles();
                ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2)).cleanupAfterTest();
                ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).clearScopesCachesForModules();
                projectRootManagerComponentRef.set((ProjectRootManagerComponent)ObjectUtils.tryCast((Object)ProjectRootManager.getInstance((Project)project2), ProjectRootManagerComponent.class));
            }
        }), () -> {
            this.clearFileAndEditor();
            this.myPsiManager = null;
        }, () -> this.disposeRootDisposable(), () -> EdtTestUtil.runInEdtAndWait(() -> this.myProjectFixture.tearDown()), () -> EdtTestUtil.runInEdtAndWait(() -> this.myTempDirFixture.tearDown()), () -> super.tearDown(), () -> {
            ProjectRootManagerComponent projectRootManagerComponent = projectRootManagerComponentRef.getAndSet(null);
            if (projectRootManagerComponent != null) {
                projectRootManagerComponent.disposeVirtualFilePointersAfterTest();
            }
            if (this.myVirtualFilePointerTracker != null) {
                this.myVirtualFilePointerTracker.assertPointersAreDisposed();
            }
        }, () -> {
            if (this.myLibraryTableTracker != null) {
                this.myLibraryTableTracker.assertDisposed();
            }
        });
    }

    private void closeOpenFiles() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return;
        }
        LookupManager.hideActiveLookup((Project)project2);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles();
        EditorHistoryManager.getInstance((Project)project2).removeAllFiles();
    }

    private PsiFile @NotNull [] configureByFilesInner(String ... filePaths) {
        this.assertInitialized();
        this.clearFileAndEditor();
        this.myAllPsiFiles = new PsiFile[filePaths.length];
        for (int i2 = filePaths.length - 1; i2 >= 0; --i2) {
            this.myAllPsiFiles[i2] = this.configureByFileInner(filePaths[i2]);
        }
        return this.myAllPsiFiles;
    }

    @Override
    public PsiFile configureByFile(@NotNull String file2) {
        this.configureByFilesInner(file2);
        return this.getFile();
    }

    @Override
    public PsiFile @NotNull [] configureByFiles(String ... files) {
        return this.configureByFilesInner(files);
    }

    @Override
    public PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        this.assertInitialized();
        String extension = fileType.getDefaultExtension();
        CodeInsightTestFixtureImpl.associateExtensionTemporarily(fileType, extension, this.getTestRootDisposable());
        String fileName = "aaa." + extension;
        return this.configureByText(fileName, text);
    }

    public static void associateExtensionTemporarily(@NotNull FileType fileType, @NotNull String extension, @NotNull Disposable parentDisposable) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (!fileType.equals(fileTypeManager.getFileTypeByExtension(extension))) {
            WriteAction.runAndWait(() -> fileTypeManager.associateExtension(fileType, extension));
            Disposer.register((Disposable)parentDisposable, () -> WriteAction.runAndWait(() -> fileTypeManager.removeAssociatedExtension(fileType, extension)));
        }
    }

    @Override
    public PsiFile configureByText(@NotNull String fileName, @NotNull String text) {
        this.assertInitialized();
        VirtualFile vFile = this.createFile(fileName, text);
        this.configureInner(vFile, SelectionAndCaretMarkupLoader.fromFile(vFile));
        return this.getFile();
    }

    @Override
    public VirtualFile createFile(@NotNull String fileName, @NotNull String text) {
        this.assertInitialized();
        try {
            return (VirtualFile)WriteCommandAction.writeCommandAction((Project)this.getProject()).compute(() -> {
                VirtualFile file2;
                if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
                    VirtualFile root = LightPlatformTestCase.getSourceRoot();
                    root.refresh(false, false);
                    file2 = root.findOrCreateChildData((Object)this, fileName);
                    Assert.assertNotNull((String)(fileName + " not found in " + root.getPath()), (Object)file2);
                } else if (this.myTempDirFixture instanceof TempDirTestFixtureImpl) {
                    Path tempFile = ((TempDirTestFixtureImpl)this.myTempDirFixture).createTempFile(fileName);
                    file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempFile.toString()));
                    Assert.assertNotNull((String)(tempFile + " not found"), (Object)file2);
                } else {
                    file2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.getTempDirPath(), fileName));
                    Assert.assertNotNull((String)(fileName + " not found in " + this.getTempDirPath()), (Object)file2);
                }
                this.prepareVirtualFile(file2);
                Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)this.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text);
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        this.assertInitialized();
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    private PsiFile configureByFileInner(@NotNull String filePath) {
        this.assertInitialized();
        VirtualFile file2 = this.copyFileToProject(filePath);
        return this.configureByFileInner(file2);
    }

    @Override
    public PsiFile configureFromTempProjectFile(@NotNull String filePath) {
        VirtualFile fileInTempDir = this.findFileInTempDir(filePath);
        if (fileInTempDir == null) {
            throw new IllegalArgumentException("Could not find file in temp dir: " + filePath);
        }
        return this.configureByFileInner(fileInTempDir);
    }

    @Override
    public void configureFromExistingVirtualFile(@NotNull VirtualFile virtualFile) {
        this.configureByFileInner(virtualFile);
    }

    private PsiFile configureByFileInner(@NotNull VirtualFile copy) {
        return this.configureInner(copy, SelectionAndCaretMarkupLoader.fromFile(copy));
    }

    private PsiFile configureInner(@NotNull VirtualFile copy, @NotNull SelectionAndCaretMarkupLoader loader) {
        this.assertInitialized();
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            IdeaTestExecutionPolicy policy;
            if (!copy.getFileType().isBinary()) {
                try {
                    WriteAction.run(() -> copy.setBinaryContent(loader.newFileText.getBytes(copy.getCharset())));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setFileAndEditor(copy, this.createEditor(copy));
            if (this.myEditor == null) {
                Assert.fail((String)("editor couldn't be created for: " + copy.getPath() + ", use copyFileToProject() instead of configureByFile()"));
            }
            EditorTestUtil.setCaretsAndSelection(this.myEditor, loader.caretState);
            Module module2 = this.getModule();
            if (module2 != null) {
                for (Facet facet : FacetManager.getInstance((Module)module2).getAllFacets()) {
                    FacetManager.getInstance((Module)module2).facetConfigurationChanged(facet);
                }
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            if (this.myCaresAboutInjection) {
                this.setupEditorForInjectedLanguage();
            }
            if ((policy = IdeaTestExecutionPolicy.current()) != null) {
                policy.testFileConfigured(this.getFile());
            }
            return null;
        }));
        return this.getFile();
    }

    protected void prepareVirtualFile(@NotNull VirtualFile file2) {
    }

    private void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myEditor, (PsiFile)this.getFile());
        if (editor instanceof EditorWindow) {
            this.setFileAndEditor(((EditorWindow)editor).getInjectedFile().getViewProvider().getVirtualFile(), editor);
        }
    }

    @Override
    public VirtualFile findFileInTempDir(@NotNull String filePath) {
        if (this.myTempDirFixture instanceof LightTempDirTestFixtureImpl) {
            return this.myTempDirFixture.getFile(filePath);
        }
        String fullPath = this.getTempDirPath() + "/" + filePath;
        VirtualFile copy = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath.replace(File.separatorChar, '/'));
        Assert.assertNotNull((String)("file " + fullPath + " not found"), (Object)copy);
        VfsTestUtil.assertFilePathEndsWithCaseSensitivePath(copy, filePath);
        return copy;
    }

    @NotNull
    protected Editor createEditor(@NotNull VirtualFile file2) {
        Project project2 = this.getProject();
        FileEditorManager instance2 = FileEditorManager.getInstance((Project)project2);
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        Editor editor = instance2.openTextEditor(new OpenFileDescriptor(project2, file2), false);
        UIUtil.markAsFocused((JComponent)editor.getContentComponent(), (boolean)true);
        EditorTestUtil.waitForLoading(editor);
        DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        return editor;
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings) {
        return this.collectAndCheckHighlighting(checkWarnings, checkInfos, checkWeakWarnings, false);
    }

    private long collectAndCheckHighlighting(boolean checkWarnings, boolean checkInfos, boolean checkWeakWarnings, boolean ignoreExtraHighlighting) {
        if (this.myEditor == null) {
            throw new IllegalStateException("Fixture is not configured. Call something like configureByFile() or configureByText()");
        }
        ExpectedHighlightingData data = new ExpectedHighlightingData(this.myEditor.getDocument(), checkWarnings, checkWeakWarnings, checkInfos, ignoreExtraHighlighting, this.myMessageBundles);
        data.init();
        return this.collectAndCheckHighlighting(data);
    }

    private PsiFile getHostFile() {
        VirtualFile hostVFile = this.myFile instanceof VirtualFileWindow ? ((VirtualFileWindow)this.myFile).getDelegate() : this.myFile;
        return (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(hostVFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long collectAndCheckHighlighting(@NotNull ExpectedHighlightingData data) {
        List<HighlightInfo> infos;
        Project project2 = this.getProject();
        EdtTestUtil.runInEdtAndWait(() -> PsiDocumentManager.getInstance((Project)project2).commitAllDocuments());
        PsiFileImpl file2 = (PsiFileImpl)this.getHostFile();
        FileElement hardRefToFileElement = file2.calcTreeElement();
        CodeInsightTestFixtureImpl.ensureIndexesUpToDate(project2);
        long start = System.currentTimeMillis();
        VirtualFileFilter fileTreeAccessFilter = this.myVirtualFileFilter;
        Disposable disposable = Disposer.newDisposable();
        if (fileTreeAccessFilter != null) {
            PsiManagerEx.getInstanceEx((Project)project2).setAssertOnFileLoadingFilter(fileTreeAccessFilter, disposable);
        }
        try {
            infos = this.doHighlighting();
            CodeInsightTestFixtureImpl.removeDuplicatedRangesForInjected(infos);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        long elapsed = System.currentTimeMillis() - start;
        data.checkResult((PsiFile)file2, infos, file2.getText());
        if (data.hasLineMarkers()) {
            Document document = this.getDocument(this.getFile());
            data.checkLineMarkers((PsiFile)file2, DaemonCodeAnalyzerImpl.getLineMarkers((Document)document, (Project)this.getProject()), document.getText());
        }
        Reference.reachabilityFence(hardRefToFileElement);
        return elapsed;
    }

    public void setVirtualFileFilter(@Nullable VirtualFileFilter filter) {
        this.myVirtualFileFilter = filter;
    }

    public void setMessageBundles(ResourceBundle ... messageBundles) {
        this.myMessageBundles = messageBundles;
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting() {
        return this.myEditorTestFixture.doHighlighting(this.myAllowDirt, this.myReadEditorMarkupModel);
    }

    @Override
    @NotNull
    public List<HighlightInfo> doHighlighting(@NotNull HighlightSeverity minimalSeverity) {
        return ContainerUtil.filter(this.doHighlighting(), info -> info.getSeverity().compareTo(minimalSeverity) >= 0);
    }

    @Override
    @NotNull
    public String getTestDataPath() {
        return this.myTestDataPath;
    }

    @Override
    public void setTestDataPath(@NotNull String dataPath) {
        this.myTestDataPath = dataPath;
    }

    @Override
    public final Project getProject() {
        return this.myProjectFixture.getProject();
    }

    @Override
    public Module getModule() {
        return this.myProjectFixture.getModule();
    }

    @Override
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public int getCaretOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public PsiFile getFile() {
        return this.myFile != null ? (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findFile(this.myFile)) : null;
    }

    @Override
    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForFile(file2);
    }

    @Override
    public void allowTreeAccessForAllFiles() {
        assert (this.myVirtualFileFilter instanceof FileTreeAccessFilter) : "configured filter does not support this method";
        ((FileTreeAccessFilter)this.myVirtualFileFilter).allowTreeAccessForAllFiles();
    }

    private void checkResultByFile(@NotNull String expectedFile, @NotNull PsiFile originalFile, boolean stripTrailingSpaces) {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            policy.beforeCheckResult(this.getFile());
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (!stripTrailingSpaces) {
            EditorUtil.fillVirtualSpaceUntilCaret((Editor)this.getHostEditor());
        }
        String fileText = originalFile.getText();
        String path = this.getTestDataPath() + "/" + expectedFile;
        String charset = Optional.ofNullable(originalFile.getVirtualFile()).map(f -> f.getCharset().name()).orElse(null);
        this.checkResult(expectedFile, stripTrailingSpaces, SelectionAndCaretMarkupLoader.fromFile(path, charset), fileText);
    }

    private void checkResult(@NotNull String expectedFile, boolean stripTrailingSpaces, @NotNull SelectionAndCaretMarkupLoader loader, @NotNull String actualText) {
        this.assertInitialized();
        Project project2 = this.getProject();
        Editor editor = this.getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        UsefulTestCase.doPostponedFormatting(this.getProject());
        if (stripTrailingSpaces) {
            actualText = this.stripTrailingSpaces(actualText);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        String expectedText = loader.newFileText;
        if (stripTrailingSpaces) {
            expectedText = this.stripTrailingSpaces(expectedText);
        }
        if (!Objects.equals(expectedText, actualText = StringUtil.convertLineSeparators((String)actualText))) {
            if (loader.filePath == null) {
                throw new ComparisonFailure(expectedFile, expectedText, actualText);
            }
            if (loader.caretState.hasExplicitCaret()) {
                int offset = editor.getCaretModel().getOffset();
                if (offset > -1) {
                    actualText = new StringBuilder(actualText).insert(offset, "<caret>").toString();
                }
                expectedText = loader.fileText;
                if (stripTrailingSpaces) {
                    expectedText = this.stripTrailingSpaces(expectedText);
                }
            }
            throw new FileComparisonFailure(expectedFile, expectedText, actualText, loader.filePath);
        }
        EditorTestUtil.verifyCaretAndSelectionState(editor, loader.caretState, expectedFile);
    }

    @NotNull
    private String stripTrailingSpaces(@NotNull String actualText) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)actualText);
        ((DocumentImpl)document).stripTrailingSpaces(this.getProject());
        actualText = document.getText();
        return actualText;
    }

    public void canChangeDocumentDuringHighlighting(boolean canI) {
        this.myAllowDirt = canI;
    }

    @NotNull
    public String getFoldingDescription(boolean withCollapseStatus) {
        Editor topEditor = this.getHostEditor();
        return (String)EdtTestUtil.runInEdtAndGet(() -> {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            if (policy != null) {
                policy.waitForHighlighting(this.getProject(), topEditor);
            }
            CodeFoldingManager.getInstance((Project)this.getProject()).buildInitialFoldings(topEditor);
            return CodeInsightTestFixtureImpl.getFoldingData(topEditor, withCollapseStatus);
        });
    }

    @NotNull
    public static String getFoldingData(Editor topEditor, boolean withCollapseStatus) {
        return CodeInsightTestFixtureImpl.getTagsFromSegments(topEditor.getDocument().getText(), Arrays.asList(topEditor.getFoldingModel().getAllFoldRegions()), FOLD, foldRegion -> "text='" + foldRegion.getPlaceholderText() + "'" + (String)(withCollapseStatus ? " expand='" + foldRegion.isExpanded() + "'" : ""));
    }

    @NotNull
    public static <T extends Segment> String getTagsFromSegments(@NotNull String text, @NotNull Collection<? extends T> segments, @NotNull String tagName, @Nullable com.intellij.util.Function<? super T, String> attrCalculator) {
        LinkedList<Border> borders = new LinkedList<Border>();
        for (Segment region : segments) {
            String attr = attrCalculator == null ? null : (String)attrCalculator.fun((Object)region);
            borders.add(new Border(true, region.getStartOffset(), attr));
            borders.add(new Border(false, region.getEndOffset(), ""));
        }
        Collections.sort(borders);
        StringBuilder result2 = new StringBuilder(text);
        for (Border border : borders) {
            StringBuilder info = new StringBuilder();
            info.append('<');
            if (border.isLeftBorder) {
                info.append(tagName);
                if (border.text != null) {
                    info.append(' ').append(border.text);
                }
            } else {
                info.append('/').append(tagName);
            }
            info.append('>');
            result2.insert(border.offset, info);
        }
        return result2.toString();
    }

    private void testFoldingRegions(@NotNull String verificationFileName, @Nullable String destinationFileName, boolean doCheckCollapseStatus) {
        String expectedContent;
        File verificationFile;
        try {
            verificationFile = new File(verificationFileName);
            expectedContent = FileUtil.loadFile((File)verificationFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNotNull((Object)expectedContent);
        expectedContent = StringUtil.replace((String)expectedContent, (String)"\r", (String)"");
        String cleanContent = CodeInsightTestFixtureImpl.removeFoldingMarkers(expectedContent);
        if (destinationFileName == null) {
            String fileName = PathUtil.getFileName((String)verificationFileName);
            this.configureByText(fileName, cleanContent);
        } else {
            try {
                String tempDirPrefix = this.myTempDirFixture.getFile("").getUrl();
                if (destinationFileName.startsWith(tempDirPrefix)) {
                    VirtualFile file2 = this.myTempDirFixture.createFile(destinationFileName.substring(tempDirPrefix.length()), cleanContent);
                    Assert.assertNotNull((Object)file2);
                    this.configureFromExistingVirtualFile(file2);
                } else {
                    FileUtil.writeToFile((File)new File(destinationFileName), (String)cleanContent);
                    VirtualFile file3 = LocalFileSystem.getInstance().refreshAndFindFileByPath(destinationFileName);
                    Assert.assertNotNull((Object)file3);
                    this.configureFromExistingVirtualFile(file3);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String actual = this.getFoldingDescription(doCheckCollapseStatus);
        if (!expectedContent.equals(actual)) {
            throw new FileComparisonFailure(verificationFile.getName(), expectedContent, actual, verificationFile.getPath());
        }
    }

    @NotNull
    public static String removeFoldingMarkers(String expectedContent) {
        return expectedContent.replaceAll("<fold\\stext='[^']*'(\\sexpand='[^']*')*>", "").replace("</fold>", "");
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName) {
        this.testFoldingRegions(verificationFileName, null, true);
    }

    @Override
    public void testFoldingWithCollapseStatus(@NotNull String verificationFileName, @Nullable String destinationFileName) {
        this.testFoldingRegions(verificationFileName, destinationFileName, true);
    }

    @Override
    public void testFolding(@NotNull String verificationFileName) {
        this.testFoldingRegions(verificationFileName, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRainbow(@NotNull String fileName, @NotNull String text, boolean isRainbowOn, boolean withColor) {
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        boolean isRainbowOnInScheme = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)globalScheme, null);
        try {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, (Boolean)isRainbowOn);
            this.configureByText(fileName, text.replaceAll("<rainbow(\\scolor='[^']*')?>", "").replace("</rainbow>", ""));
            List highlighting = ContainerUtil.filter(this.doHighlighting(), info -> info.type == RainbowHighlighter.RAINBOW_ELEMENT);
            Assert.assertEquals((Object)text, (Object)CodeInsightTestFixtureImpl.getTagsFromSegments(this.myEditor.getDocument().getText(), highlighting, RAINBOW, highlightInfo -> {
                if (!withColor) {
                    return null;
                }
                TextAttributes attributes = highlightInfo.getTextAttributes(null, null);
                String color = attributes == null ? "null" : (attributes.getForegroundColor() == null ? "null" : Integer.toHexString(attributes.getForegroundColor().getRGB()));
                return "color='" + color + "'";
            }));
        }
        finally {
            RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)globalScheme, null, (Boolean)isRainbowOnInScheme);
        }
    }

    @Override
    public void testInlays() {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkParameterHints();
        }
        finally {
            checker.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testInlays(Function<? super Inlay<?>, String> inlayPresenter2, Predicate<? super Inlay<?>> inlayFilter2) {
        InlayHintsChecker checker = new InlayHintsChecker(this);
        try {
            checker.setUp();
            checker.checkInlays(inlayPresenter2::apply, inlayFilter2::test);
        }
        finally {
            checker.tearDown();
        }
    }

    @Override
    public void checkResultWithInlays(String text) {
        DocumentImpl checkDocument = new DocumentImpl(text);
        InlayHintsChecker checker = new InlayHintsChecker(this);
        CaretAndInlaysInfo inlaysAndCaretInfo = checker.extractInlaysAndCaretInfo((Document)checkDocument);
        this.checkResult(checkDocument.getText());
        checker.verifyInlaysAndCaretInfo(inlaysAndCaretInfo, text);
    }

    @Override
    public void assertPreferredCompletionItems(int selected, String ... expected) {
        this.myEditorTestFixture.assertPreferredCompletionItems(selected, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void testStructureView(@NotNull Consumer<? super StructureViewComponent> consumer) {
        Assert.assertNotNull((String)"configure first", (Object)this.myFile);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(this.myFile);
        Assert.assertNotNull((String)("editor not opened for " + this.myFile), (Object)this.myFile);
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(this.getFile());
        Assert.assertNotNull((String)("no builder for " + this.myFile), (Object)builder);
        StructureViewComponent component = null;
        try {
            component = (StructureViewComponent)builder.createStructureView(fileEditor, this.getProject());
            PlatformTestUtil.waitForPromise(component.rebuildAndUpdate());
            consumer.consume((Object)component);
            if (component == null) return;
        }
        catch (Throwable throwable) {
            if (component == null) throw throwable;
            Disposer.dispose(component);
            throw throwable;
        }
        Disposer.dispose((Disposable)component);
    }

    @Override
    public void setCaresAboutInjection(boolean caresAboutInjection) {
        this.myCaresAboutInjection = caresAboutInjection;
    }

    @Override
    public void setReadEditorMarkupModel(boolean readEditorMarkupModel) {
        this.myReadEditorMarkupModel = readEditorMarkupModel;
    }

    public LookupImpl getLookup() {
        return this.myEditorTestFixture.getLookup();
    }

    @Override
    @NotNull
    public List<Object> getGotoClassResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        SearchEverywhereContributor<Object> contributor = this.createMockClassSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), (Processor)new CommonProcessors.CollectProcessor(results));
        return results;
    }

    @Override
    @NotNull
    public List<Object> getGotoSymbolResults(@NotNull String pattern, boolean searchEverywhere, @Nullable PsiElement contextForSorting) {
        SearchEverywhereContributor<Object> contributor = this.createMockSymbolSearchEverywhereContributor(searchEverywhere);
        ArrayList<Object> results = new ArrayList<Object>();
        contributor.fetchElements(pattern, (ProgressIndicator)new MockProgressIndicator(), (Processor)new CommonProcessors.CollectProcessor(results));
        return results;
    }

    @Override
    @NotNull
    public List<Crumb> getBreadcrumbsAtCaret() {
        return this.myEditorTestFixture.getBreadcrumbsAtCaret();
    }

    private SearchEverywhereContributor<Object> createMockClassSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        ClassSearchEverywhereContributor contributor = new ClassSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor((SearchScope)FindSymbolParameters.searchScopeFor((Project)this.myProject, (boolean)everywhere));
            }
        };
        Disposer.register((Disposable)this.getProjectDisposable(), (Disposable)contributor);
        return contributor;
    }

    private SearchEverywhereContributor<Object> createMockSymbolSearchEverywhereContributor(final boolean everywhere) {
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.getProject());
        AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
        SymbolSearchEverywhereContributor contributor = new SymbolSearchEverywhereContributor(event){
            {
                super(arg0);
                this.myScopeDescriptor = new ScopeDescriptor((SearchScope)FindSymbolParameters.searchScopeFor((Project)this.myProject, (boolean)everywhere));
            }
        };
        Disposer.register((Disposable)this.getProjectDisposable(), (Disposable)contributor);
        return contributor;
    }

    protected void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        if (this.myEditor instanceof EditorWindow) {
            Document document = ((DocumentWindow)this.myEditor.getDocument()).getDelegate();
            this.setFileAndEditor(FileDocumentManager.getInstance().getFile(document), ((EditorWindow)this.myEditor).getDelegate());
        }
    }

    public static boolean invokeIntention(@NotNull IntentionAction action, @NotNull PsiFile file2, @NotNull Editor editor) {
        Project project2 = file2.getProject();
        VirtualFile vFile = Objects.requireNonNull(InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file2)).getVirtualFile();
        AtomicBoolean result2 = new AtomicBoolean();
        CodeInsightTestFixtureImpl.withReadOnlyFile(vFile, project2, () -> {
            try {
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        result2.set(ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)file2, (Editor)editor, (IntentionAction)action, (String)action.getText()));
                    }
                    catch (StubTextInconsistencyException e) {
                        PsiTestUtil.compareStubTexts(e);
                    }
                });
                UIUtil.dispatchAllInvocationEvents();
                CodeInsightTestFixtureImpl.checkPsiTextConsistency(project2, vFile);
            }
            catch (AssertionError e) {
                ExceptionUtil.rethrowUnchecked((Throwable)ExceptionUtil.getRootCause((Throwable)((Object)e)));
                throw e;
            }
        });
        return result2.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean withReadOnlyFile(VirtualFile vFile, Project project2, Runnable action) {
        boolean writable;
        ReadonlyStatusHandlerImpl handler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)project2);
        CodeInsightTestFixtureImpl.setReadOnly(vFile, true);
        handler.setClearReadOnlyInTests(true);
        try {
            action.run();
        }
        finally {
            writable = vFile.isWritable();
            handler.setClearReadOnlyInTests(false);
            CodeInsightTestFixtureImpl.setReadOnly(vFile, false);
        }
        return writable;
    }

    private static void checkPsiTextConsistency(@NotNull Project project2, @NotNull VirtualFile vFile) {
        PsiFile topLevelPsi;
        PsiFile psiFile = topLevelPsi = vFile.isValid() ? PsiManager.getInstance((Project)project2).findFile(vFile) : null;
        if (topLevelPsi != null) {
            if (Registry.is((String)"ide.check.structural.psi.text.consistency.in.tests")) {
                PsiTestUtil.checkPsiStructureWithCommit(topLevelPsi, PsiTestUtil::checkPsiMatchesTextIgnoringNonCode);
            } else {
                PsiTestUtil.checkStubsMatchText(topLevelPsi);
            }
        }
    }

    private static void setReadOnly(VirtualFile vFile, boolean readOnlyStatus) {
        try {
            WriteAction.runAndWait(() -> ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)vFile, (boolean)readOnlyStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public String getUsageViewTreeTextRepresentation(@NotNull UsageViewImpl usageView) {
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)usageView);
        usageView.expandAll();
        return TreeNodeTester.forNode((TreeNode)usageView.getRoot()).withPresenter(arg_0 -> ((UsageViewImpl)usageView).getNodeText(arg_0)).constructTextRepresentation();
    }

    @Override
    @NotNull
    public Disposable getProjectDisposable() {
        return this.myProjectFixture.getTestRootDisposable();
    }

    private static final class SelectionAndCaretMarkupLoader {
        private final String fileText;
        private final String filePath;
        private final String newFileText;
        private final EditorTestUtil.CaretAndSelectionState caretState;

        private SelectionAndCaretMarkupLoader(@NotNull String fileText, String filePath) {
            this.fileText = fileText;
            this.filePath = filePath;
            Document document = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            this.caretState = EditorTestUtil.extractCaretAndSelectionMarkers(document);
            this.newFileText = document.getText();
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull String path, String charset) {
            return SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> FileUtil.loadFile((File)new File(path), (String)charset)), path);
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromFile(@NotNull VirtualFile file2) {
            return SelectionAndCaretMarkupLoader.fromIoSource((ThrowableComputable<String, IOException>)((ThrowableComputable)() -> VfsUtilCore.loadText((VirtualFile)file2)), file2.getPath());
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromIoSource(@NotNull ThrowableComputable<String, IOException> source, String path) {
            try {
                return new SelectionAndCaretMarkupLoader(StringUtil.convertLineSeparators((String)((String)source.compute())), path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @NotNull
        private static SelectionAndCaretMarkupLoader fromText(@NotNull String text) {
            return new SelectionAndCaretMarkupLoader(text, null);
        }
    }

    private static final class Border
    implements Comparable<Border> {
        private final boolean isLeftBorder;
        private final int offset;
        private final String text;

        private Border(boolean isLeftBorder, int offset, String text) {
            this.isLeftBorder = isLeftBorder;
            this.offset = offset;
            this.text = text;
        }

        @Override
        public int compareTo(@NotNull Border o) {
            return this.offset < o.offset ? 1 : -1;
        }
    }
}

