/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.SdkTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.IdeaTestFixtureFactoryImpl;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaTestFixtureFactory {
    private static final IdeaTestFixtureFactory ourInstance = new IdeaTestFixtureFactoryImpl();

    @NotNull
    public static IdeaTestFixtureFactory getFixtureFactory() {
        return ourInstance;
    }

    public abstract <T extends ModuleFixtureBuilder<?>> void registerFixtureBuilder(@NotNull Class<T> var1, @NotNull Class<? extends T> var2);

    public abstract void registerFixtureBuilder(@NotNull Class<? extends ModuleFixtureBuilder<?>> var1, @NotNull String var2);

    @NotNull
    public TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String name) {
        return this.createFixtureBuilder(name, false);
    }

    @NotNull
    public abstract TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String var1, boolean var2);

    public abstract TestFixtureBuilder<IdeaProjectTestFixture> createFixtureBuilder(@NotNull String var1, @Nullable Path var2, boolean var3);

    @NotNull
    public abstract TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@NotNull String var1);

    @NotNull
    public abstract TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor var1, @NotNull String var2);

    @Deprecated
    public TestFixtureBuilder<IdeaProjectTestFixture> createLightFixtureBuilder(@Nullable LightProjectDescriptor projectDescriptor) {
        String message = "Use createLightFixtureBuilder(LightProjectDescriptor, String) instead";
        Logger.getInstance(IdeaTestFixtureFactory.class).warn((Throwable)new RuntimeException(message));
        return this.createLightFixtureBuilder(projectDescriptor, message);
    }

    @NotNull
    public abstract CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture var1);

    @NotNull
    public abstract CodeInsightTestFixture createCodeInsightFixture(@NotNull IdeaProjectTestFixture var1, @NotNull TempDirTestFixture var2);

    @NotNull
    public abstract TempDirTestFixture createTempDirTestFixture();

    @NotNull
    public abstract BareTestFixture createBareFixture();

    @NotNull
    public abstract SdkTestFixture createSdkFixture(@NotNull SdkType var1, @NotNull Predicate<String> var2);
}

